/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Form;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebForm;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestFilterSubscription
extends BaseJiraFuncTest {
    private static final String SUBSCRIPTIONS_ELEMENT_ID = "issuenav";
    private static final String EDIT_SUBSCRIPTIONS_LINK_ID = "edit_subscription";
    private static final String SUBSCRIBER_SELECT_NAME = "groupName";
    private static final String EDIT_SUBSCRIPTION_FROM_ID = "filter-subscription";
    private static final String UPDATE_BUTTON_NAME = "Update";
    private static final String SUBSCRIBE_BUTTON_NAME = "Subscribe";
    private static final String CRON_EXPRESSION_INPUT_NAME = "filter.subscription.prefix.cronString";
    private static final String ADD_SUBSCRIPTION_BUTTON_TEXT = "Add subscription";
    private static final String SUBSCRIPTION_INTERVAL_FIELD_NAME = "filter.subscription.prefix.interval";
    private static final String RUN_TO_HOURS_FIELD_NAME = "filter.subscription.prefix.runToHours";
    private static final String RUN_TO_MERIDIAN_FIELD_NAME = "filter.subscription.prefix.runToMeridian";
    private static final String SUBSCRIPTION_TYPE_FIELD_NAME = "filter.subscription.prefix.dailyWeeklyMonthly";
    private static final String RUN_FROM_HOURS_FIELD_NAME = "filter.subscription.prefix.runFromHours";
    private static final String RUN_FROM_MERIDIAN_FIELD_NAME = "filter.subscription.prefix.runFromMeridian";
    private static final String WEEKDAY_FIELD_NAME = "filter.subscription.prefix.weekday";
    private static final String DAYS_OF_MONTH_OPT_FIELD_NAME = "filter.subscription.prefix.daysOfMonthOpt";
    private static final String WEEK_FIELD_NAME = "filter.subscription.prefix.week";
    private static final String DAY_FIELD_NAME = "filter.subscription.prefix.day";
    private static final String RUN_ONCE_MERIDIAN_FIELD_NAME = "filter.subscription.prefix.runOnceMeridian";
    @Inject
    private Form form;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        String filter = this.backdoor.filters().createFilter("", "Test Filter");
        this.navigation.manageFilters().manageSubscriptions(Integer.parseInt(filter, 10));
    }

    @Test
    public void testDefaultDailyTrigger() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 ? * *");
        this.tester.assertTextPresent("Daily at 1:00 am");
    }

    @Test
    public void testNonDefaultDailyTriggerEvery2Hours() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 2 hours");
        this.tester.selectOption(RUN_TO_HOURS_FIELD_NAME, "5");
        this.tester.selectOption(RUN_TO_MERIDIAN_FIELD_NAME, "pm");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1-16/2 ? * *");
        this.tester.assertTextPresent("Daily every 2 hours from 1:00 am to 5:00 pm");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.setWorkingForm(EDIT_SUBSCRIPTION_FROM_ID);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelectedById(SUBSCRIPTION_TYPE_FIELD_NAME, "daily");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 2 hours");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_FROM_HOURS_FIELD_NAME, "1");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_FROM_MERIDIAN_FIELD_NAME, "am");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_TO_HOURS_FIELD_NAME, "5");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_TO_MERIDIAN_FIELD_NAME, "pm");
    }

    @Test
    public void testNonDefaultDailyTriggerEvery2HoursAllDay() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 2 hours");
        this.tester.selectOption(RUN_FROM_HOURS_FIELD_NAME, "5");
        this.tester.selectOption(RUN_FROM_MERIDIAN_FIELD_NAME, "pm");
        this.tester.selectOption(RUN_TO_HOURS_FIELD_NAME, "5");
        this.tester.selectOption(RUN_TO_MERIDIAN_FIELD_NAME, "pm");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 */2 ? * *");
        this.tester.assertTextPresent("Daily every 2 hours");
        this.tester.assertTextNotPresent("from 5:00 pm to 5:00 pm");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.setWorkingForm(EDIT_SUBSCRIPTION_FROM_ID);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelectedById(SUBSCRIPTION_TYPE_FIELD_NAME, "daily");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 2 hours");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_FROM_HOURS_FIELD_NAME, "12");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_FROM_MERIDIAN_FIELD_NAME, "am");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_TO_HOURS_FIELD_NAME, "12");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_TO_MERIDIAN_FIELD_NAME, "am");
    }

    @Test
    public void testAdvancedExpressionWithBothMinuteAndHourIncrements() {
        String cronExpr = "0 0/15 */3 ? * *";
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "advanced");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 0/15 */3 ? * *");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0/15 */3 ? * *");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        WebForm webForm = this.form.switchTo(EDIT_SUBSCRIPTION_FROM_ID);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelectedById(SUBSCRIPTION_TYPE_FIELD_NAME, "advanced");
        Assert.assertEquals((Object)"0 0/15 */3 ? * *", (Object)webForm.getParameterValue(CRON_EXPRESSION_INPUT_NAME));
    }

    @Test
    public void testAdvancedExpressionWithMinuteIncrementButSingleHour() {
        String cronExpr = "0 0/15 7 ? * *";
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "advanced");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 0/15 7 ? * *");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0/15 7 ? * *");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        WebForm webForm = this.form.switchTo(EDIT_SUBSCRIPTION_FROM_ID);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelectedById(SUBSCRIPTION_TYPE_FIELD_NAME, "advanced");
        Assert.assertEquals((Object)"0 0/15 7 ? * *", (Object)webForm.getParameterValue(CRON_EXPRESSION_INPUT_NAME));
    }

    @Test
    public void testAdvancedExpressionWithMinuteIncrementAndSingleHourRange() {
        String cronExpr = "0 0/15 7-7 ? * *";
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "advanced");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 0/15 7-7 ? * *");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0/15 7-7 ? * *");
        this.tester.assertTextPresent("Daily every 15 minutes from 7:00 am to 8:00 am");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.setWorkingForm(EDIT_SUBSCRIPTION_FROM_ID);
        this.assertions.getJiraFormAssertions().assertSelectElementByIdHasOptionSelectedById(SUBSCRIPTION_TYPE_FIELD_NAME, "daily");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 15 minutes");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_FROM_HOURS_FIELD_NAME, "7");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_FROM_MERIDIAN_FIELD_NAME, "am");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_TO_HOURS_FIELD_NAME, "8");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected(RUN_TO_MERIDIAN_FIELD_NAME, "am");
    }

    @Test
    public void testDailyInvalidRange() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daily");
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 3 hours");
        this.tester.selectOption(RUN_FROM_HOURS_FIELD_NAME, "1");
        this.tester.selectOption(RUN_TO_HOURS_FIELD_NAME, "12");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("You must select a from time that is before the to time.");
    }

    @Test
    public void testDefaultDaysPerWeekSingleDay() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfWeek");
        this.tester.checkCheckbox(WEEKDAY_FIELD_NAME, "2");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 ? * 2");
        this.tester.assertTextPresent("Monday at 1:00 am");
    }

    @Test
    public void testDefaultDaysPerWeekMultipleDays() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfWeek");
        this.tester.checkCheckbox(WEEKDAY_FIELD_NAME, "2");
        this.tester.checkCheckbox(WEEKDAY_FIELD_NAME, "3");
        this.tester.checkCheckbox(WEEKDAY_FIELD_NAME, "5");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 ? * 2,3,5");
        this.tester.assertTextPresent("Each Monday, Tuesday and Thursday at 1:00 am");
    }

    @Test
    public void testNoDaysPerWeekSelected() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfWeek");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("You must select one or more days of the week for the Days per Week mode.");
    }

    @Test
    public void testDaysPerWeekInvalidRange() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfWeek");
        this.tester.checkCheckbox(WEEKDAY_FIELD_NAME, "1");
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 3 hours");
        this.tester.selectOption(RUN_FROM_HOURS_FIELD_NAME, "1");
        this.tester.selectOption(RUN_TO_HOURS_FIELD_NAME, "12");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("You must select a from time that is before the to time.");
    }

    @Test
    public void testInvalidForOneModeButValidForThisMode() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfWeek");
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 3 hours");
        this.tester.selectOption(RUN_TO_HOURS_FIELD_NAME, "12");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("You must select a from time that is before the to time.");
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "3");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 3 1 * ?");
        this.tester.assertTextPresent("The 1st day of every month at 3:00 am");
    }

    @Test
    public void testEditDaily() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 ? * *");
        this.tester.assertTextPresent("Daily at 1:00 am");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daily");
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "every 2 hours");
        this.tester.selectOption(RUN_FROM_HOURS_FIELD_NAME, "10");
        this.tester.selectOption(RUN_TO_HOURS_FIELD_NAME, "8");
        this.tester.selectOption(RUN_TO_MERIDIAN_FIELD_NAME, "pm");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 10-19/2 ? * *");
        this.tester.assertTextPresent("Daily every 2 hours from 10:00 am to 8:00 pm");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.selectOption(SUBSCRIPTION_INTERVAL_FIELD_NAME, "once per day");
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfWeek");
        this.tester.checkCheckbox(WEEKDAY_FIELD_NAME, "2");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "6");
        this.tester.selectOption("filter.subscription.prefix.runOnceMins", "35");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("0 35 6 ? * 2");
        this.tester.assertTextPresent("Each Monday at 6:35 am");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("0 35 6 1 * ?");
        this.tester.assertTextPresent("The 1st day of every month at 6:35 am");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.checkCheckbox(DAYS_OF_MONTH_OPT_FIELD_NAME, "dayOfWeekOfMonth");
        this.tester.selectOption(WEEK_FIELD_NAME, "last");
        this.tester.selectOption(DAY_FIELD_NAME, "Wednesday");
        this.tester.selectOption(RUN_ONCE_MERIDIAN_FIELD_NAME, "pm");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("0 35 18 ? * 4L");
        this.tester.assertTextPresent("The last Wednesday of every month at 6:35 pm");
    }

    @Test
    public void testDefaultDayOfMonthMode() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 1 * ?");
        this.tester.assertTextPresent("The 1st day of every month at 1:00 am");
    }

    @Test
    public void testLastDayOfMonthMode() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
        this.tester.selectOption("filter.subscription.prefix.monthDay", "last");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "12");
        this.tester.selectOption("filter.subscription.prefix.runOnceMins", "35");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 35 0 L * ?");
        this.tester.assertTextPresent("The last day of every month at 12:35 am");
    }

    @Test
    public void testComplexMonthMode() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
        this.tester.checkCheckbox(DAYS_OF_MONTH_OPT_FIELD_NAME, "dayOfWeekOfMonth");
        this.tester.selectOption(WEEK_FIELD_NAME, "fourth");
        this.tester.selectOption(DAY_FIELD_NAME, "Thursday");
        this.tester.selectOption("filter.subscription.prefix.runOnceHours", "4");
        this.tester.selectOption("filter.subscription.prefix.runOnceMins", "35");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 35 4 ? * 5#4");
        this.tester.assertTextPresent("The fourth Thursday of every month at 4:35 am");
    }

    @Test
    public void testAdvancedMode() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "advanced");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "Invalid");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("This field does not support names: &#39;INVALID&#39;");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 0 2 * Invalid ?");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("Invalid month name: &#39;INVALID&#39;");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 0 2 ? * Invalid");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("Invalid day-of-week name: &#39;INVALID&#39;");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 35 4 * * *");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("You must use &#39;?&#39; for either the day-of-month or day-of-week.");
        this.tester.setFormElement(CRON_EXPRESSION_INPUT_NAME, "0 37 4 * * ?");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 37 4 * * ?");
        this.tester.assertTextNotPresent("Daily at 4:37 am");
    }

    @Test
    public void testDeleteSubscription() {
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 1 * ?");
        this.tester.assertTextPresent("The 1st day of every month at 1:00 am");
        this.tester.clickLinkWithText("Delete");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header h2"), "Subscriptions");
        this.tester.assertTextNotPresent("0 0 1 1 * ?");
    }

    @Test
    public void testSubscriptionsOfAnotherUserAreNotVisible() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            int filterId = this.createFilterAsUser("fred");
            this.navigation.manageFilters().manageSubscriptions(filterId);
            this.tester.assertTextNotPresent("Daily at 1:00 am");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testSubscriptionsOfAnotherUserAreNotVisibleForRegularUsers() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            int filterId = this.createFilterAsUser("admin");
            this.navigation.logout();
            this.navigation.login("fred");
            this.navigation.manageFilters().manageSubscriptions(filterId);
            this.tester.assertTextNotPresent("Daily at 1:00 am");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testDeleteSubscriptionOfAnotherUserWithFfEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            int filterId = this.createFilterAsUser("fred");
            this.navigation.manageFilters().manageSubscriptions(filterId);
            this.tester.assertTextPresent("Daily at 1:00 am");
            this.tester.clickLinkWithText("Delete");
            this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header h2"), "Subscriptions");
            this.tester.assertTextNotPresent("Daily at 1:00 am");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testEditSubscriptionOfAnotherUserWithFfEnabled() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            int filterId = this.createFilterAsUser("fred");
            this.navigation.manageFilters().manageSubscriptions(filterId);
            this.tester.assertTextPresent("Daily at 1:00 am");
            this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
            this.tester.checkCheckbox(SUBSCRIPTION_TYPE_FIELD_NAME, "daysOfMonth");
            this.tester.submit(UPDATE_BUTTON_NAME);
            this.tester.assertTextPresent("The 1st day of every month at 1:00 am");
            this.tester.assertTextInElement(SUBSCRIPTIONS_ELEMENT_ID, "Fred Normal");
            this.tester.assertTextNotInElement(SUBSCRIPTIONS_ELEMENT_ID, "Administrator");
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testAddSubscriptionForGroup() {
        int filterId = this.createFilterAsUser("fred");
        this.backdoor.permissions().addGlobalPermission(24, "jira-users");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.manageFilters().manageSubscriptions(filterId);
        this.tester.assertTextNotInElement(SUBSCRIPTIONS_ELEMENT_ID, "jira-users");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.selectOption(SUBSCRIBER_SELECT_NAME, "jira-users");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextInElement(SUBSCRIPTIONS_ELEMENT_ID, "Fred Normal");
    }

    @Test
    public void testAddSubscriptionForUnavailableGroup() {
        int filterId = this.createFilterAsUser("fred");
        this.backdoor.permissions().addGlobalPermission(24, "jira-users");
        this.navigation.logout();
        this.navigation.login("fred");
        this.backdoor.usersAndGroups().addUserToGroup("fred", "jira-administrators");
        this.navigation.manageFilters().manageSubscriptions(filterId);
        this.tester.assertTextNotInElement(SUBSCRIPTIONS_ELEMENT_ID, "jira-administrators");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.selectOption(SUBSCRIBER_SELECT_NAME, "jira-administrators");
        this.backdoor.usersAndGroups().removeUserFromGroup("fred", "jira-administrators");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("Please select a valid group or choose &quot;Personal subscription&quot; option");
        this.navigation.manageFilters().manageSubscriptions(filterId);
        this.tester.assertTextNotInElement(SUBSCRIPTIONS_ELEMENT_ID, "jira-administrators");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.assertTextNotInElement(EDIT_SUBSCRIPTION_FROM_ID, "jira-administrators");
    }

    @Test
    public void testAddSubscriptionWithoutPermission() {
        int filterId = this.createFilterAsUser("fred");
        this.backdoor.permissions().addGlobalPermission(24, "jira-users");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.manageFilters().manageSubscriptions(filterId);
        this.tester.assertTextNotInElement(SUBSCRIPTIONS_ELEMENT_ID, "jira-users");
        this.tester.clickLink(EDIT_SUBSCRIPTIONS_LINK_ID);
        this.tester.selectOption(SUBSCRIBER_SELECT_NAME, "jira-users");
        this.backdoor.permissions().removeGlobalPermission(24, "jira-users");
        this.tester.submit(UPDATE_BUTTON_NAME);
        this.tester.assertTextPresent("You don&#39;t have permission to manage group filter subscriptions");
    }

    @Test
    public void testSubscribeToFilterWithNoPermissions() {
        this.navigation.logout();
        this.navigation.login("fred");
        this.tester.gotoPage("/secure/EditSubscription!default.jspa?filterId=10000");
        this.tester.assertTextPresent("The selected filter is not available to you, perhaps it has been deleted or had its permissions changed.");
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Access Denied", "It seems that you have tried to perform an operation which you are not permitted to perform."});
    }

    @Test
    public void testDeleteGroupWithSubscription() {
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", "delete-me");
        this.tester.submit("add_group");
        String filter = this.backdoor.filters().createFilter("", "delete-group-filter");
        this.backdoor.filterSubscriptions().addSubscription(Long.parseLong(filter, 10), "delete-me", "0 0 0 ? 1 MON#3", false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.clickLink("del_delete-me");
        this.textAssertions.assertTextPresent(this.locator.page(), "This group is referenced in the following filter subscriptions:");
        this.textAssertions.assertTextPresent(this.locator.page(), "'delete-group-filter' owned by user : 'admin'");
        this.textAssertions.assertTextPresent(this.locator.page(), "These filter subscriptions will be automatically deleted.");
        this.tester.submit("Delete");
        this.navigation.manageFilters().goToDefault();
        this.textAssertions.assertTextNotPresent(this.locator.page(), "1 Subscription");
    }

    private int createFilterAsUser(String username) {
        this.backdoor.permissions().addGlobalPermission(22, "jira-users");
        this.navigation.logout();
        this.navigation.login(username);
        int filterId = Integer.parseInt(this.backdoor.filters().createFilter("", "AFilter", username, "jira-users"), 10);
        this.navigation.manageFilters().manageSubscriptions(filterId);
        this.tester.clickLinkWithText(ADD_SUBSCRIPTION_BUTTON_TEXT);
        this.tester.submit(SUBSCRIBE_BUTTON_NAME);
        this.tester.assertTextPresent("0 0 1 ? * *");
        this.tester.assertTextPresent("Daily at 1:00 am");
        this.navigation.logout();
        this.navigation.login("admin");
        return filterId;
    }
}

