/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.FilterList;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@RestoreOnce(value="sharedfilters/TestBrowseFiltersShareType.xml")
@LoginAs(user="admin")
public class TestSearchFiltersShareType
extends BaseJiraFuncTest {
    private static final Long HOMOSAPIEN_PROJECT_ID = 10000L;
    private static final Long MONKEY_PROJECT_ID = 10001L;
    private static final Long NAGGERS_ROLE_ID = 10010L;
    private static final String NAGGERS_ROLE_NAME = "Naggers";
    private static final String ADMIN_USER_STRING = "Administrator (admin)";
    private static final String WIFE_USER_STRING = "wife the nagger (wife)";
    private static final int PAGE_SIZE = 20;
    private static final String NEXT_LINK_TEXT = "Next >>";
    private static final String PREVIOUS_LINK_TEXT = "<< Previous";
    private static final FilterItem ADMIN_GROUP_FILTER = new FilterItem(10080L, "developer", "", "developer the great and wise (developer)", (List<WebTestSharePermission>)ImmutableList.of((Object)new WebTestSharePermission("group", "jira-developers", null), (Object)new WebTestSharePermission("project", "monkey", "Naggers")), Boolean.FALSE, 0L, Collections.emptyList(), 1L);
    private static final FilterItem WIFE_GROUP_FILTER = new FilterItem(10080L, "developer", "", "developer the great and wise (developer)", (List<WebTestSharePermission>)ImmutableList.of((Object)new WebTestSharePermission("project", "monkey", "Naggers")), Boolean.FALSE, 0L, Collections.emptyList(), 1L);
    private FilterNavigation[] filterNavigationScreens;
    @Inject
    private Parser parse;

    @Before
    public void setUpTest() {
        this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        this.filterNavigationScreens = new FilterNavigation[]{this.navigation.manageFilters(), this.navigation.filterPickerPopup()};
    }

    @After
    public void tearDownTest() {
        this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
    }

    @Test
    public void testFindUsingAnonymous() {
        ArrayList expectedAdminItems = Lists.newArrayList();
        this.addGroupFilters(expectedAdminItems, "groupusers", 'a', 'e', 10040L, "jira-users");
        this.addAuthenticatedUserFilters(expectedAdminItems, "loggedin", 'k', '0', 10050L);
        this.executeGroupSearch("jira-users", null, this.navigation.manageFilters());
        this.checkSearchResults(expectedAdminItems);
        this.navigation.logout();
        ArrayList expectedAnonymousItems = Lists.newArrayList();
        this.addPublicFilters(expectedAnonymousItems, "", 'a', 'z', 10005L);
        this.searchAll();
        this.checkSearchResults(expectedAnonymousItems, false);
        this.navigation.login("admin");
        this.executeGroupSearch("jira-users", null, this.navigation.manageFilters());
        this.checkSearchResults(expectedAdminItems);
    }

    @Test
    public void testFindAdminGroupsNoResults() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindAdminGroupsNoResults(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindDeveloperGroups() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindDeveloperGroups(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindDeveloperWithConditions() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindDeveloperWithConditions(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindUsersGroups() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindUsersGroups(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindHomosapienProjectNoResults() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindHomosapienProjectNoResults(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindMonkeyProjectAsAdmin() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectAsAdmin(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindMonkeyProjectAsWife() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectAsWife(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindMonkeyProjectWithRoleNaggersAsWife() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectWithRoleNaggersAsWife(aFilterNavigationScreen);
        }
    }

    @Test
    public void testFindMonkeyProjectWithRoleNaggersAsWifeAndConditions() {
        for (FilterNavigation aFilterNavigationScreen : this.filterNavigationScreens) {
            this.testFindMonkeyProjectWithRoleNaggersAsWifeAndConditions(aFilterNavigationScreen);
        }
    }

    public void testFindAdminGroupsNoResults(FilterNavigation filterNavigation) {
        this.executeGroupSearch("jira-administrators", null, filterNavigation);
        Assert.assertTrue((boolean)this.parseBrowse().isEmpty());
    }

    public void testFindDeveloperGroups(FilterNavigation filterNavigation) {
        List<Object> expectedItems = Lists.newArrayList();
        expectedItems.add(ADMIN_GROUP_FILTER);
        this.addGroupFilters(expectedItems, "groupdevs", 'a', 'z', 10045L, "jira-developers");
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeGroupSearch("jira-developers", null, filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    public void testFindDeveloperWithConditions(FilterNavigation filterNavigation) {
        this.executeGroupSearch("jira-developers", "developer", filterNavigation);
        List<Object> expectedItems = Lists.newArrayList((Object[])new FilterItem[]{ADMIN_GROUP_FILTER});
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.checkSearchResults(expectedItems);
    }

    public void testFindUsersGroups(FilterNavigation filterNavigation) {
        List<Object> expectedItems = Lists.newArrayList();
        this.addGroupFilters(expectedItems, "groupusers", 'a', 'e', 10040L, "jira-users");
        this.executeGroupSearch("jira-users", null, filterNavigation);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.checkSearchResults(expectedItems);
    }

    public void testFindHomosapienProjectNoResults(FilterNavigation filterNavigation) {
        this.executeProjectSearch(HOMOSAPIEN_PROJECT_ID, null, null, filterNavigation);
        Assert.assertTrue((boolean)this.parseBrowse().isEmpty());
    }

    public void testFindMonkeyProjectAsAdmin(FilterNavigation filterNavigation) {
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "projectmonkey", 'a', 'z', 10090L, ADMIN_USER_STRING, "monkey", null);
        this.executeProjectSearch(MONKEY_PROJECT_ID, null, null, filterNavigation);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.checkSearchResults(expectedItems);
    }

    public void testFindMonkeyProjectAsWife(FilterNavigation filterNavigation) {
        this.navigation.logout();
        this.navigation.login("wife", "wife");
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "projectmonkey", 'a', 'z', 10090L, ADMIN_USER_STRING, "monkey", null);
        this.addProjectFilters(expectedItems, "naggers", 'a', 'j', 10120L, WIFE_USER_STRING, "monkey", NAGGERS_ROLE_NAME);
        expectedItems.add(WIFE_GROUP_FILTER);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeProjectSearch(MONKEY_PROJECT_ID, null, null, filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    public void testFindMonkeyProjectWithRoleNaggersAsWife(FilterNavigation filterNavigation) {
        this.navigation.logout();
        this.navigation.login("wife", "wife");
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "naggers", 'a', 'j', 10120L, WIFE_USER_STRING, "monkey", NAGGERS_ROLE_NAME);
        expectedItems.add(WIFE_GROUP_FILTER);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeProjectSearch(MONKEY_PROJECT_ID, NAGGERS_ROLE_ID, null, filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    public void testFindMonkeyProjectWithRoleNaggersAsWifeAndConditions(FilterNavigation filterNavigation) {
        this.navigation.logout();
        this.navigation.login("wife", "wife");
        List<Object> expectedItems = Lists.newArrayList();
        this.addProjectFilters(expectedItems, "naggers", 'a', 'j', 10120L, WIFE_USER_STRING, "monkey", NAGGERS_ROLE_NAME);
        expectedItems = filterNavigation.sanitiseSearchFilterItems(expectedItems);
        this.executeProjectSearch(MONKEY_PROJECT_ID, NAGGERS_ROLE_ID, "naggers*", filterNavigation);
        this.checkSearchResults(expectedItems);
    }

    private void searchAll() {
        this.navigation.manageFilters().searchFilters();
        this.tester.setWorkingForm("filterSearchForm");
        this.tester.submit("Search");
    }

    private void checkSearchResults(List<FilterItem> expectedItems) {
        this.checkSearchResults(expectedItems, true);
    }

    private void checkSearchResults(List<FilterItem> expectedItems, boolean isAuthorizedUser) {
        expectedItems.sort(NameComparator.NAME_COMPARATOR);
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_name");
        expectedItems.sort((Comparator<FilterItem>)Ordering.from((Comparator)NameComparator.NAME_COMPARATOR).reverse());
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        if (isAuthorizedUser) {
            this.tester.clickLink("filter_sort_owner");
            expectedItems.sort(this.createAuthorComparator(false));
            this.checkNext(expectedItems);
            this.checkPrevious(expectedItems);
            this.tester.clickLink("filter_sort_owner");
            expectedItems.sort(this.createAuthorComparator(true));
            this.checkNext(expectedItems);
            this.checkPrevious(expectedItems);
        }
        this.tester.clickLink("filter_sort_popularity");
        expectedItems.sort(this.createPopularComparator(true));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
        this.tester.clickLink("filter_sort_popularity");
        expectedItems.sort(this.createPopularComparator(false));
        this.checkNext(expectedItems);
        this.checkPrevious(expectedItems);
    }

    private Comparator<FilterItem> createAuthorComparator(boolean reverse) {
        AuthorComparator authorComparator = AuthorComparator.AUTHOR_COMPARATOR;
        if (reverse) {
            authorComparator = Ordering.from((Comparator)authorComparator).reverse();
        }
        return Ordering.from((Comparator)authorComparator).compound((Comparator)NameComparator.NAME_COMPARATOR);
    }

    private Comparator<FilterItem> createPopularComparator(boolean reverse) {
        PopularComparator authorComparator = PopularComparator.POPULAR_COMPARATOR;
        if (reverse) {
            authorComparator = Ordering.from((Comparator)authorComparator).reverse();
        }
        return Ordering.from((Comparator)authorComparator).compound((Comparator)NameComparator.NAME_COMPARATOR);
    }

    private void addProjectFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId, String userName, String project, String roleId) {
        WebTestSharePermission permission = new WebTestSharePermission("project", project, roleId);
        this.addFilters(items, name, startChar, endChar, initialId, userName, Collections.singletonList(permission));
    }

    private void addGroupFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId, String groupName) {
        WebTestSharePermission permission = new WebTestSharePermission("group", groupName, null);
        this.addFilters(items, name, startChar, endChar, initialId, ADMIN_USER_STRING, Collections.singletonList(permission));
    }

    private void addPublicFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId) {
        WebTestSharePermission permission = new WebTestSharePermission("global", null, null);
        this.addFilters(items, name, startChar, endChar, initialId, ADMIN_USER_STRING, Collections.singletonList(permission));
        items.forEach(item -> item.setAuthor(null));
    }

    private void addAuthenticatedUserFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId) {
        WebTestSharePermission permission = new WebTestSharePermission("loggedin", null, null);
        this.addFilters(items, name, startChar, endChar, initialId, ADMIN_USER_STRING, Collections.singletonList(permission));
    }

    private void addFilters(List<FilterItem> items, String name, char startChar, char endChar, long initialId, String user, List<WebTestSharePermission> shares) {
        long currentId = initialId;
        for (char currentChar = startChar; currentChar <= endChar; currentChar = (char)(currentChar + '\u0001')) {
            items.add(new FilterItem(currentId, name + currentChar, "", user, shares, Boolean.FALSE, 0L, Collections.emptyList(), 0L));
            ++currentId;
        }
    }

    private void executeProjectSearch(Long projectId, Long roleId, String text, FilterNavigation filterNavigation) {
        filterNavigation.searchFilters();
        this.tester.setWorkingForm("filterSearchForm");
        this.fillInOtherParameters(text);
        this.tester.setFormElement("searchShareType", "project");
        this.tester.setFormElement("projectShare", projectId.toString());
        this.tester.setFormElement("roleShare", roleId == null ? "" : roleId.toString());
        this.tester.submit("Search");
    }

    private void executeGroupSearch(String groupName, String text, FilterNavigation filterNavigation) {
        filterNavigation.searchFilters();
        this.tester.gotoPage(String.format("secure/ManageFilters.jspa?filterView=search&searchName=%s&searchShareType=group&groupShare=%s&Search=Search", StringUtils.defaultString((String)text), StringUtils.defaultString((String)groupName)));
        this.tester.setWorkingForm("filterSearchForm");
    }

    private void fillInOtherParameters(String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            this.tester.setFormElement("searchName", text);
        }
    }

    private void checkNext(List<FilterItem> items) {
        int iterations = items.size() / 20;
        int remainder = items.size() % 20;
        if (iterations == 0 || 20 == items.size()) {
            this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
            this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
            Assert.assertEquals((String)"All filters not on first screen.", items, this.parseBrowse());
        } else {
            for (int i = 1; i <= iterations; ++i) {
                int startPos = (i - 1) * 20;
                int endPos = i * 20;
                List<FilterItem> expectedItems = items.subList(startPos, endPos);
                List<FilterItem> list = this.parseBrowse();
                this.assertions.assertEquals("Page " + i + " did not contain expected items.", expectedItems, list);
                if (i == 1) {
                    this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
                } else {
                    this.tester.assertLinkPresentWithText(PREVIOUS_LINK_TEXT);
                }
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + endPos);
                if (remainder == 0 && i == iterations) {
                    this.tester.assertLinkNotPresent(NEXT_LINK_TEXT);
                    continue;
                }
                this.tester.assertLinkPresentWithText(NEXT_LINK_TEXT);
                this.tester.clickLinkWithText(NEXT_LINK_TEXT);
            }
            if (remainder != 0) {
                this.tester.assertLinkPresentWithText(PREVIOUS_LINK_TEXT);
                this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
                int startPos = iterations * 20;
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + items.size());
                List<FilterItem> expectedItems = items.subList(startPos, items.size());
                Assert.assertEquals((String)"Last page did not contain expected items.", expectedItems, this.parseBrowse());
            }
        }
    }

    private void checkPrevious(List items) {
        int iterations = items.size() / 20;
        int remainder = items.size() % 20;
        if (iterations == 0 || items.size() == 20) {
            this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
            this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
            Assert.assertEquals((String)"All filters not on first screen.", (Object)items, this.parseBrowse());
        } else {
            if (remainder != 0) {
                this.tester.assertLinkNotPresentWithText(NEXT_LINK_TEXT);
                int startPos = iterations * 20;
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + items.size());
                List expectedItems = items.subList(startPos, items.size());
                Assert.assertEquals((String)"Last page did not contain expected items.", expectedItems, this.parseBrowse());
                this.tester.clickLinkWithText(PREVIOUS_LINK_TEXT);
            }
            for (int i = iterations; i > 0; --i) {
                int startPos = (i - 1) * 20;
                int endPos = i * 20;
                List expectedItems = items.subList(startPos, endPos);
                Assert.assertEquals((String)("Page " + i + " did not contain expected items."), expectedItems, this.parseBrowse());
                this.tester.assertTextPresent("" + (startPos + 1) + " - " + endPos);
                if (i == 1) {
                    this.tester.assertLinkNotPresentWithText(PREVIOUS_LINK_TEXT);
                } else {
                    this.tester.clickLinkWithText(PREVIOUS_LINK_TEXT);
                }
                if (remainder == 0 && i == iterations) {
                    this.tester.assertLinkNotPresent(NEXT_LINK_TEXT);
                    continue;
                }
                this.tester.assertLinkPresentWithText(NEXT_LINK_TEXT);
            }
        }
    }

    private List<FilterItem> parseBrowse() {
        FilterList list = this.parse.filter().parseFilterList("mf_browse");
        if (list == null) {
            return Collections.emptyList();
        }
        List<FilterItem> items = list.getFilterItems();
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    private static class NameComparator
    implements Comparator<FilterItem> {
        public static final NameComparator NAME_COMPARATOR = new NameComparator();

        private NameComparator() {
        }

        @Override
        public int compare(FilterItem item1, FilterItem item2) {
            return item1.getName().compareTo(item2.getName());
        }
    }

    private static class PopularComparator
    implements Comparator<FilterItem> {
        public static final PopularComparator POPULAR_COMPARATOR = new PopularComparator();

        private PopularComparator() {
        }

        @Override
        public int compare(FilterItem item1, FilterItem item2) {
            return item1.getFavCount().compareTo(item2.getFavCount());
        }
    }

    private static class AuthorComparator
    implements Comparator<FilterItem> {
        public static final AuthorComparator AUTHOR_COMPARATOR = new AuthorComparator();
        private static final Pattern NAME_REGEX = Pattern.compile("\\((.*)\\)");

        private AuthorComparator() {
        }

        private static String getName(String authorName) {
            Matcher matcher = NAME_REGEX.matcher(authorName);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return authorName;
        }

        @Override
        public int compare(FilterItem item1, FilterItem item2) {
            String author1 = AuthorComparator.getName(item1.getAuthor());
            String author2 = AuthorComparator.getName(item2.getAuthor());
            return author1.compareTo(author2);
        }
    }
}

