/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.edit;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.sharing.SimpleTestSharingPermission;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.sharing.rights.ShareRights;
import com.atlassian.jira.webtests.ztests.filter.edit.TestEditFilter;
import java.util.Collections;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
public class TestSharePermissionWithRights
extends TestEditFilter {
    @Override
    String getRestoreDataXmlName() {
        return "sharedfilters/TestSharePermissionWithRights.xml";
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=712001)
    public void testUserWhoIsInEditorsGroupCanSeeEditPageAndEditFilterData() {
        this.navigation.login("editor_by_jira_developers_group");
        this.navigation.issueNavigator().editFilter(10030L);
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "You may only create, modify or delete filters that you own.");
        HashSet<SimpleTestSharingPermission> permissions = new HashSet<SimpleTestSharingPermission>();
        permissions.add(new SimpleTestSharingPermission("group", "jira-developers", null, ShareRights.VIEW_EDIT));
        permissions.add(new SimpleTestSharingPermission("group", "jira-users", null, ShareRights.VIEW));
        long id = this.editFilter(10030L, "new Name added by Editor", "new description added by Editor", false, permissions);
        Assert.assertEquals((long)id, (long)10030L);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=712001)
    public void testEditorCanRemovePermissionWhichGivesThemEditRights() {
        this.navigation.login("editor_by_jira_developers_group");
        this.navigation.issueNavigator().editFilter(10030L);
        long id = this.editFilter(10030L, "any name", "any description", false, Collections.singleton(new SimpleTestSharingPermission("group", "jira-users", null, ShareRights.VIEW)));
        Assert.assertEquals((long)id, (long)10030L);
        this.navigation.issueNavigator().editFilter(10030L);
        this.textAssertions.assertTextPresent(new WebPageLocator(this.tester), "Unable to change a filter that you do not have permission to edit.");
    }
}

