/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter.management;

import com.atlassian.integrationtesting.runner.restore.RestoreOnce;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS})
@LoginAs(user="admin")
@RestoreOnce(value="TestSharedFilterSearchingByAdmins.xml")
public class TestSharedFilterSearchingByAdmins
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=811000)
    public void testFilterNameIsALink() {
        this.administration.sharedFilters().goTo().searchAll();
        this.tester.assertLinkPresent("filterlink_10010");
        this.tester.assertLinkPresentWithText("Shared Filter with Anyone owned by developer");
    }

    @Test
    public void testAnAdminIsAbleToSearchForFiltersSharedWithAGroupHeDoesNotBelongTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10006L).name("Shared Filter With Group jira-developers owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        Assert.assertNotNull(actualFilterItems);
        MatcherAssert.assertThat(actualFilterItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForFiltersSharedWithAGroupHeBelongsTo() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10010L).name("Shared Filter with Anyone owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10009L).name("Shared Filter With group jira-administrators owned by admin").owner("Administrator").build(), (Object)new FilterItem.Builder().id(10002L).name("Shared Filter With Group jira-users owned by fred").owner("Fred Normal").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        Assert.assertNotNull(actualFilterItems);
        MatcherAssert.assertThat(actualFilterItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForFiltersSharedWithARoleHeIsNotPartOf() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10004L).name("Shared Filter With Role Developers on homosapien owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        Assert.assertNotNull(actualFilterItems);
        MatcherAssert.assertThat(actualFilterItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForFiltersSharedWithARoleHeIsPartOf() {
        ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10001L).name("Shared Filter With Role Users on homosapien owned by fred").owner("Fred Normal").build(), (Object)new FilterItem.Builder().id(10007L).name("Shared Filter With All Roles on monkey owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10005L).name("Shared Filter With Role Developers on monkey owned by developer").owner("Developer").build());
        List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
        Assert.assertNotNull(actualFilterItems);
        MatcherAssert.assertThat(actualFilterItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
        Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
    }

    @Test
    public void testAnAdminIsAbleToSearchForFiltersThatArePrivate() {
        try {
            this.backdoor.darkFeatures().enableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            ImmutableList expectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10003L).name("Private Filter Owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10000L).name("Private Filter Owned by fred").owner("Fred Normal").build(), (Object)new FilterItem.Builder().id(10008L).name("Private Filter owned by admin").owner("Administrator").build());
            List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
            Assert.assertNotNull(actualFilterItems);
            MatcherAssert.assertThat(actualFilterItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
            Assert.assertTrue((boolean)Iterables.all((Iterable)expectedFilterItems, (Predicate)Predicates.in(actualFilterItems)));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }

    @Test
    public void testAnAdminIsNotAbleToSearchForFiltersThatArePrivateWithFfDisabled() {
        try {
            this.backdoor.darkFeatures().disableForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
            ImmutableList nonExpectedFilterItems = ImmutableList.of((Object)new FilterItem.Builder().id(10003L).name("Private Filter Owned by developer").owner("Developer").build(), (Object)new FilterItem.Builder().id(10000L).name("Private Filter Owned by fred").owner("Fred Normal").build(), (Object)new FilterItem.Builder().id(10008L).name("Private Filter owned by admin").owner("Administrator").build());
            List<FilterItem> actualFilterItems = this.administration.sharedFilters().goTo().searchAll().filters().list();
            Assert.assertNotNull(actualFilterItems);
            MatcherAssert.assertThat(actualFilterItems, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)Matchers.empty())));
            Assert.assertTrue((boolean)Iterables.all((Iterable)nonExpectedFilterItems, (Predicate)Predicates.not((Predicate)Predicates.in(actualFilterItems))));
        }
        finally {
            this.backdoor.darkFeatures().resetForSite(FunctTestConstants.ADMINS_CAN_EDIT_PRIVATE_FILTERS_AND_DASHBOARDS);
        }
    }
}

