/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.i18n;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.I18N})
@LoginAs(user="admin")
public class TestTranslateSubTasks
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @After
    public void tearDownTest() {
        this.administration.generalConfiguration().setJiraLocaleToSystemDefault();
    }

    @Test
    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestTranslateSubTasks.xml");
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink("translate_sub_tasks");
        this.textAssertions.assertTextPresent("Sprache: Deutsch (Deutschland)");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("selectedLocale", "Deutsch (Deutschland)");
    }

    @Test
    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestTranslateSubTasks.xml");
        this.administration.subtasks().enable();
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SUBTASKS);
        this.tester.clickLink("translate_sub_tasks");
        this.textAssertions.assertTextPresent("Lenguaje: espa\u00f1ol (Espa\u00f1a)");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("selectedLocale", "espa\u00f1ol (Espa\u00f1a)");
    }
}

