/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.ProjectImportTypeFix;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.junit.Assert;

public abstract class BaseJiraProjectImportFuncTest
extends BaseJiraFuncTest {
    @Inject
    protected Administration administration;

    public void advanceThroughWaitingPage() {
        int count = 0;
        while (this.tester.getDialog().getResponseText().contains("Project Import: Progress")) {
            this.tester.submit("Refresh");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (++count < 100) continue;
            Assert.fail((String)"Our project import backup selection has taken too long!");
        }
    }

    public File doProjectImport(String backupFileName, String currentSystemXML) {
        return this.doProjectImport(backupFileName, currentSystemXML, false);
    }

    public File doProjectImport(String backupFileName, String currentSystemXML, String projectName) {
        return this.doProjectImport(backupFileName, currentSystemXML, projectName, false);
    }

    public File doProjectImport(String backupFileName, String currentSystemXML, String projectName, boolean doPluginsRefresh) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML, doPluginsRefresh);
        this.importToPreImportSummaryPage(tempFile, projectName);
        return tempFile;
    }

    public File doProjectImport(String backupFileName, String currentSystemXML, boolean doPluginsRefresh) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML, doPluginsRefresh);
        this.importToPreImportSummaryPage(tempFile);
        return tempFile;
    }

    protected File copyFileToJiraImportDirectory(File file) {
        File jiraImportDirectory = new File(this.administration.getJiraHomeDirectory(), "import");
        if (file.getParentFile().equals(jiraImportDirectory)) {
            return file;
        }
        try {
            FileUtils.copyFileToDirectory((File)file, (File)jiraImportDirectory);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not copy file " + file.getAbsolutePath() + " to the import directory in jira home " + jiraImportDirectory, e);
        }
        return new File(jiraImportDirectory, file.getName());
    }

    public void importToPreImportSummaryPage(File tempFile) {
        this.importToPreImportSummaryPage(tempFile, "monkey");
    }

    public void importToPreImportSummaryPage(File tempFile, String projectName) {
        this.copyFileToJiraImportDirectory(tempFile);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", tempFile.getName());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", projectName);
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
    }

    public File importAndExportBackupAndSetupCurrentInstance(String backupFileName, String currentSystemXML) {
        return this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML, false);
    }

    public File importAndExportBackupAndSetupCurrentInstance(String backupFileName, String currentSystemXML, boolean doPluginsRefresh) {
        if (doPluginsRefresh) {
            this.administration.restoreDataSlowOldWay(backupFileName);
        } else {
            this.backdoor.restoreDataFromResource(backupFileName);
        }
        File backupFile = this.administration.exportDataToFile(FilenameUtils.removeExtension((String)backupFileName) + "_out.xml");
        ProjectImportTypeFix fix = new ProjectImportTypeFix(this.backdoor);
        fix.rewriteProjectTypes(backupFile);
        backupFile = this.copyFileToJiraImportDirectory(backupFile);
        this.backdoor.restoreDataFromResource(currentSystemXML);
        fix.updateAllProjectsToBusinessType();
        this.administration.attachments().enable();
        return backupFile;
    }
}

