/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.imports.project.BaseJiraProjectImportFuncTest;
import java.io.File;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT, Category.DATABASE})
public class TestProjectImportPluginData
extends BaseJiraProjectImportFuncTest
implements FunctTestConstants {
    @Test
    @LoginAs(user="admin")
    public void aoDataImported() throws Exception {
        try (AutoCloseable tmp = this.tempFile(this.doProjectImport("TestAoProjectImport.zip", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));){
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
            String projectDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Reference entities: 3"));
            this.administration.usersAndGroups().deleteGroup("TestPluginGroup");
            this.navigation.gotoPage("/plugins/servlet/refentity/list");
            this.tester.assertTextPresent("TestEntity1");
            this.tester.assertTextPresent("TestEntity2");
            this.tester.assertTextPresent("TestEntity3");
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferenceAoPreImport.args.set"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferenceAoPostImport.args.set"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferenceOfBizPreImport.args.set"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferenceOfBizPostImport.args.set"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferencePreImportPluginRun"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferencePreImportPluginRun.args.set"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferencePostImportPluginRun"), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.backdoor.applicationProperties().getOption("ReferencePostImportPluginRun.args.set"), (Matcher)Is.is((Object)true));
            this.navigation.gotoDashboard();
        }
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    @Test
    @LoginAs(user="admin")
    public void refPluginValidationError() throws Exception {
        try (AutoCloseable tmp = this.tempFile(this.doProjectImport("TestAoProjectImport.zip", "TestProjectImportStandardSimpleDataNoIssues.xml", "homosapien"));){
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertTextPresent("There is no ref entity for this project. Please add &#39;HSP&#39;.");
            this.tester.assertSubmitButtonNotPresent("Import");
            this.tester.assertSubmitButtonPresent("refreshValidationButton");
        }
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    private AutoCloseable tempFile(File file) {
        return file::delete;
    }
}

