/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.FunctTestConstants;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.imports.project.BaseJiraProjectImportFuncTest;
import java.io.File;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT, Category.DATABASE})
public class TestProjectImportRespectsJiraCharacterLimit
extends BaseJiraProjectImportFuncTest
implements FunctTestConstants {
    @Inject
    private TextAssertions textAssertions;

    @Test
    @LoginAs(user="admin")
    public void givesValidationErrorsWhenIssueTextFieldsExceedLimit() throws Exception {
        try (AutoCloseable ignored = this.tempFile(this.doProjectImport("TestProjectImportRespectsJiraCharacterLimit.zip", "TestProjectImportStandardSimpleDataNoIssuesWith3kLimit.xml", "homosapien"));){
            this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
            this.tester.assertSubmitButtonNotPresent("Import");
            XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='system-fields']//div[@class='description']");
            Assert.assertThat((Object)pathLocator.getNodes(), (Matcher)Matchers.arrayWithSize((int)1));
            this.textAssertions.assertTextPresent(pathLocator, "The largest text field with length of 4646 exceeds the allowed limit of 3000. Increase the limit in advanced settings to continue.");
            pathLocator = new XPathLocator(this.tester, "//div[@id='custom-fields']//div[@class='description']");
            Assert.assertThat((Object)pathLocator.getNodes(), (Matcher)Matchers.arrayWithSize((int)1));
            this.textAssertions.assertTextPresent(pathLocator, "The largest text field with length of 4661 exceeds the allowed limit of 3000. Increase the limit in advanced settings to continue.");
        }
    }

    private AutoCloseable tempFile(File file) {
        return file::delete;
    }
}

