/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.Parser;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryField;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistorySet;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.parser.comment.Comment;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.parser.worklog.Worklog;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;
import com.atlassian.jira.functest.rule.Rules;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.functest.rule.TemporaryFileRule;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.testkit.client.restclient.Component;
import com.atlassian.jira.testkit.client.restclient.Project;
import com.atlassian.jira.testkit.client.restclient.ProjectClient;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.atlassian.jira.testkit.client.restclient.Version;
import com.atlassian.jira.webtests.ztests.imports.project.BaseJiraProjectImportFuncTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT, Category.DATABASE})
@LoginAs(user="admin")
public class TestProjectImportResults
extends BaseJiraProjectImportFuncTest {
    private static final String CHANGE_HISTORY = "History";
    private static final String COMMENTS = "Comments";
    private static final String PAGE_USER_BROWSER = "/secure/admin/user/UserBrowser.jspa";
    public static final String TRANSITION_BE_DANGEROUS = "action_id_721";
    @Inject
    private Parser parse;
    @Inject
    private Assertions assertions;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private EnvironmentUtils environmentUtils;
    @Inject
    private WorkflowUtil workflowUtil;
    @Rule
    public TemporaryFileRule temporaryFileRule = Rules.temporaryFile();

    @Test
    public void testProjectNullAssigneeTypeUnassignedOn() throws Exception {
        this.testProjectNullAssigneeType("TestProjectImportNoProjectWithUnassignedOn.xml", "Unassigned", Project.AssigneeType.UNASSIGNED);
    }

    @Test
    public void testProjectNullAssigneeTypeUnassignedOff() throws Exception {
        this.testProjectNullAssigneeType("TestProjectImportNoProjectWithUnassignedOff.xml", "Project Lead", Project.AssigneeType.PROJECT_LEAD);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testProjectNullAssigneeType(String currentSystemXML, String defaultAssignee, Project.AssigneeType defaultAssigneeCode) throws Exception {
        File tempFile = null;
        try {
            tempFile = this.doProjectImport("TestProjectImportNoAssigneeType.xml", currentSystemXML);
            this.doImportAndAssertDefaultAssignee(defaultAssignee, defaultAssigneeCode);
            this.importToPreImportSummaryPage(tempFile);
            this.doImportAndAssertDefaultAssignee(defaultAssignee, defaultAssigneeCode);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    private void doImportAndAssertDefaultAssignee(String defaultAssignee, Project.AssigneeType defaultAssigneeType) {
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        this.textAssertions.assertTextSequence(new IdLocator(this.tester, "systemfields"), "Default Assignee", defaultAssignee);
        Assert.assertThat((Object)new ProjectClient((JIRAEnvironmentData)this.environmentData).get((String)"MKY").assigneeType, (Matcher)CoreMatchers.equalTo((Object)defaultAssigneeType));
    }

    @Test
    public void testProjectNotEmptyWhenTryingToImport() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportResults.xml", "TestProjectImportResults2.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.navigation.issue().createIssue("monkey", "Bug", "I am breaking the project import");
        this.tester.gotoPage("/secure/admin/ProjectImportSummary!default.jspa");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Select Project to Import");
        this.textAssertions.assertTextPresentHtmlEncoded("The existing project with key 'MKY' contains '1' issues.");
        this.tester.assertTextPresent("The project import was aborted before it began because the project is no longer importable.");
    }

    @Test
    public void testCustomFieldNoLongerExistsTryingToImport() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportResults.xml", "TestProjectImportResults2.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.gotoPage("/secure/admin/DeleteCustomField!default.jspa?id=10030");
        this.tester.submit("Delete");
        this.tester.gotoPage("/secure/admin/ProjectImportSummary!default.jspa");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Pre-Import Summary");
        this.tester.assertTextPresent("The data mappings have produced errors, you can not import this project until all errors have been resolved. See below for details.");
        this.tester.assertTextPresent("The project import was aborted before it began because the project import mappings are no longer valid.");
        this.textAssertions.assertTextPresentHtmlEncoded("The custom field 'Cascading Select CF' of type 'Select List (cascading)' is required for the import but does not exist in the current Jira instance.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateUsers() throws Exception {
        try {
            this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
            String projectDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Lead: Fred Normal"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"URL: http://monkeyproject.example.com"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Default Assignee: Project Lead"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Components: 3"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/table");
            String userRoleIssueResults = xPathLocator.getText();
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 2 out of 2"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Administrators: 1 users, 1 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Developers: 1 users, 2 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 1 users, 2 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Issues created: 2 out of 2"));
            this.administration.usersAndGroups().gotoViewUser("wilma");
            this.tester.assertTextPresent("Wilma Flinstone");
            this.tester.assertTextPresent("wilma@example.com");
            this.tester.assertTextPresent("jira-users");
            this.tester.assertTextPresent("ice cream");
            this.tester.assertTextPresent("strawberry");
            this.tester.assertTextPresent("24");
            this.tester.assertTextPresent("4 x 6");
            this.administration.usersAndGroups().gotoViewUser("fred");
            this.tester.assertTextPresent("Fred Normal");
            this.tester.assertTextPresent("fred@example.com");
            this.tester.assertTextPresent("jira-users");
            try (OnboardingEnabler oe = new OnboardingEnabler();){
                this.setPasswordForUser("fred", "another");
                this.navigation.login("fred", "another");
                this.tester.assertElementPresent("dashboard");
            }
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    private void setPasswordForUser(String username, String password) {
        this.administration.usersAndGroups().gotoViewUser(username);
        this.tester.clickLinkWithText("Set Password");
        this.tester.setFormElement("password", password);
        this.tester.setFormElement("confirm", password);
        this.tester.submit("Update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssueDataCommentAndWorklogVisiblity() throws Exception {
        try {
            this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
            String projectDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Lead: Fred Normal"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"URL: http://monkeyproject.example.com"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Default Assignee: Project Lead"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Components: 3"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/table");
            String userRoleIssueResults = xPathLocator.getText();
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 2 out of 2"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Administrators: 1 users, 1 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Developers: 1 users, 2 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 1 users, 2 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Issues created: 2 out of 2"));
            this.navigateToUser("wilma");
            this.tester.clickLinkWithText("Set Password");
            this.tester.setFormElement("password", "wilma");
            this.tester.setFormElement("confirm", "wilma");
            this.tester.submit("Update");
            this.navigation.logout();
            this.navigation.login("wilma", "wilma");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            Assert.assertEquals((Object)"MKY-1", (Object)details.getKey());
            Assert.assertEquals((Object)"Bug", (Object)details.getIssueType());
            Assert.assertEquals((Object)"Blocker", (Object)details.getPriority());
            Assert.assertEquals((Object)"Fred Normal", (Object)details.getAssignee());
            Assert.assertEquals((Object)"Wilma Flinstone", (Object)details.getReporter());
            this.gotoTab(COMMENTS);
            List<Comment> comments = this.parse.issue().parseComments();
            Assert.assertEquals((long)1L, (long)comments.size());
            Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Wilma, that has been edited.", "Wilma Flinstone added a comment  - 12/Jun/08 3:03 PM - edited")));
            this.tester.clickLinkWithText("Work Log");
            List<Worklog> worklogs = this.parse.issue().parseWorklogs();
            Assert.assertEquals((long)1L, (long)worklogs.size());
            Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am a worklog added by Mrs. Rubble.", "2 hours", "betty logged work  - 12/Jun/08 3:18 PM")));
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testCanEditIssue() throws Exception {
        boolean isOracle = this.environmentUtils.isOracle();
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("summary", "This is the test bug with all the field values set, and I have edited it.");
        this.tester.setFormElement("description", "I am a description field");
        this.tester.setFormElement("environment", "I am environment field");
        this.tester.setFormElement("customfield_10011", "I am free text field value.");
        this.tester.setFormElement("customfield_10016", "fred");
        this.tester.submit("Update");
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"MKY-1", (Object)details.getKey());
        Assert.assertEquals((Object)"Bug", (Object)details.getIssueType());
        Assert.assertEquals((Object)"Blocker", (Object)details.getPriority());
        Assert.assertEquals((Object)"Fred Normal", (Object)details.getAssignee());
        Assert.assertEquals((Object)"Wilma Flinstone", (Object)details.getReporter());
        Assert.assertEquals((Object)"1", (Object)details.getVotes());
        this.tester.clickLink("view-voters");
        this.tester.assertTextPresent("voter_link_admin");
        this.tester.clickLinkWithText("MKY-1");
        Assert.assertEquals((Object)"1", (Object)details.getWatchers());
        this.tester.clickLink("manage-watchers");
        this.tester.assertLinkPresent("watcher_link_wilma");
        this.tester.clickLinkWithText("MKY-1");
        Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Resolve Issue"));
        Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
        Assert.assertEquals((Object)"monkey", (Object)details.getProjectName());
        Assert.assertEquals((Object)"This is the test bug with all the field values set, and I have edited it.", (Object)details.getSummary());
        Assert.assertEquals((Object)"I am a description field", (Object)details.getDescription());
        Assert.assertEquals((Object)"03/Jun/08 3:00 PM", (Object)details.getCreatedDate());
        Assert.assertEquals((Object)"09/Jun/08", (Object)details.getDueDate());
        Assert.assertTrue((boolean)details.getComponents().contains("First Test Component"));
        Assert.assertTrue((boolean)details.getComponents().contains("Second Test Component"));
        Assert.assertTrue((boolean)details.getAffectsVersions().contains("Cool Version"));
        Assert.assertTrue((boolean)details.getAffectsVersions().contains("Uncool Version"));
        Assert.assertTrue((boolean)details.getFixVersions().contains("Uncool Version"));
        Assert.assertTrue((boolean)details.getFixVersions().contains("Medium Cool Version"));
        Assert.assertEquals((Object)"2d", (Object)details.getOriginalEstimate());
        Assert.assertEquals((Object)"20h", (Object)details.getRemainingEstimate());
        Assert.assertEquals((Object)"1d 4h", (Object)details.getTimeSpent());
        Assert.assertEquals((Object)"I am environment field", (Object)details.getEnvironment());
        this.tester.assertLinkPresentWithText("MKY-2");
        this.tester.assertLinkPresentWithText("HSP-1");
        Assert.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Parent Option 1"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Child Option 1"));
        Assert.assertEquals((Object)"01/Jun/08 2:57 PM", (Object)details.getCustomFields().get("Date Time CF"));
        Assert.assertEquals((Object)"user-dudes", (Object)details.getCustomFields().get("Group Picker CF"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 2"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 1"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 1"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 2"));
        Assert.assertEquals((Object)"42.01", (Object)details.getCustomFields().get("Number Field CF"));
        Assert.assertEquals((Object)"Radio Option 1", (Object)details.getCustomFields().get("Radio Buttons CF"));
        Assert.assertEquals((Object)"Select List Option 1", (Object)details.getCustomFields().get("Select List CF"));
        Assert.assertEquals((Object)"I am text field 255 value.", (Object)details.getCustomFields().get("Text Field 255"));
        Assert.assertEquals((Object)"Fred Normal", (Object)details.getCustomFields().get("User Picker CF"));
        Assert.assertEquals((Object)"01/Apr/08", (Object)details.getCustomFields().get("Date Picker CF"));
        Assert.assertEquals((Object)"I am free text field value.", (Object)details.getCustomFields().get("Free Text Field CF"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "admin-dudes"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "dev-dudes"));
        Assert.assertEquals((Object)"homosapien", (Object)details.getCustomFields().get("Project Picker CF"));
        Assert.assertEquals((Object)"Fred Normal", (Object)details.getCustomFields().get("Multi User Picker CF"));
        Assert.assertEquals((Object)"Medium Cool Version", (Object)details.getCustomFields().get("Single Version Picker CF"));
        Assert.assertEquals((Object)"http://www.google.com", (Object)details.getCustomFields().get("URL Field CF"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Medium Cool Version"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Cool Version"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Uncool Version"));
        this.gotoTab(COMMENTS);
        List<Comment> comments = this.parse.issue().parseComments();
        Assert.assertEquals((long)4L, (long)comments.size());
        Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Wilma, that has been edited.", "Wilma Flinstone added a comment  - 12/Jun/08 3:03 PM - edited")));
        Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Adminstrator.", "Adminitrator added a comment  - 12/Jun/08 3:11 PM - Restricted to Developers")));
        Assert.assertTrue((boolean)comments.contains(new Comment("I am another Admin comment", "Adminitrator added a comment  - 12/Jun/08 3:15 PM - Restricted to jira-administrators")));
        Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by betty.", "betty added a comment  - 12/Jun/08 3:16 PM - Restricted to jira-developers - edited")));
        this.tester.clickLinkWithText("Work Log");
        List<Worklog> worklogs = this.parse.issue().parseWorklogs();
        Assert.assertEquals((long)3L, (long)worklogs.size());
        Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am Fred logging work, edited.", "1 day", "Fred Normal logged work  - 12/Jun/08 3:13 PM - Restricted to Developers - edited")));
        Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am admin worklog.", "2 hours", "Adminitrator logged work  - 12/Jun/08 3:15 PM - Restricted to jira-developers")));
        Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am a worklog added by Mrs. Rubble.", "2 hours", "betty logged work  - 12/Jun/08 3:18 PM")));
        this.tester.clickLinkWithText(CHANGE_HISTORY);
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsChangeHistory(this.getExpectedChangeHistoryListForAllData());
    }

    @Test
    public void testCustomFieldIssueTypeConstraints() throws Exception {
        String cfId = "customfield_10008";
        long textFieldDefaultConfigSchemeId = 10018L;
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportCustomFieldConfig.xml", "TestProjectImportCustomFieldConfigEmptyMKYProject.xml"));
        this.textAssertions.assertTextPresentHtmlEncoded("The custom field 'Text Field 255' in the backup project is used by issue types 'Bug, Improvement' but the field with the same name in the current Jira instance is not available to those issue types in this project.");
        this.tester.assertSubmitButtonNotPresent("Import");
        this.backdoor.fieldConfigScheme().updateFieldConfigScheme("customfield_10008", 10018L, null, null, Arrays.asList("1", "4"));
        this.tester.gotoPage("/secure/admin/ProjectImportSummary!reMapAndValidate.jspa");
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.assertTextNotPresent("I am a hidden value that will only be shown when the configuration changes.");
        this.backdoor.fieldConfigScheme().updateFieldConfigScheme("customfield_10008", 10018L, null, null, Arrays.asList("1", "4", "2"));
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.assertTextPresent("I am a hidden value that will only be shown when the configuration changes.");
    }

    @Test
    public void testCanTransitionIssue() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.assertTextPresent("This is the test bug with all the field values set.");
        this.workflowUtil.clickAction("action_id_5");
        this.tester.assertTextPresent("Resolve Issue");
        this.tester.assertTextPresent("Resolving an issue indicates that the developers are satisfied the issue is finished.");
        this.tester.submit("Transition");
        ViewIssueDetails viewIssueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"Fixed", (Object)viewIssueDetails.getResolution());
        Assert.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Close Issue"));
        Assert.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Reopen Issue"));
        Assert.assertEquals((long)2L, (long)viewIssueDetails.getAvailableWorkflowActions().size());
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804001)
    public void testIssueDataSimpleAllData() throws Exception {
        this.testSimpleImport("10000_bsattach.txt");
        this.testSimpleImport("10000");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSimpleImport(String attachmentFilename) throws Exception {
        File tempFile = null;
        File attachmentsBackupDir = null;
        File projectDir = null;
        File issueDir = null;
        File attachmentFile = null;
        try {
            attachmentsBackupDir = new File(new File(this.administration.getJiraHomeDirectory(), "import"), "attachments");
            attachmentsBackupDir.mkdir();
            projectDir = new File(attachmentsBackupDir, "MKY");
            projectDir.mkdir();
            issueDir = new File(projectDir, "MKY-1");
            issueDir.mkdir();
            attachmentFile = new File(issueDir, attachmentFilename);
            attachmentFile.createNewFile();
            tempFile = this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml");
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
            String projectDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Lead: Fred Normal"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"URL: http://monkeyproject.example.com"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Default Assignee: Project Lead"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Components: 3"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Versions: 3"));
            xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/table");
            String userRoleIssueResults = xPathLocator.getText();
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 2 out of 2"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Administrators: 1 users, 1 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Developers: 1 users, 2 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 1 users, 2 groups"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Issues created: 2 out of 2"));
            Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Attachments: 1 out of 1"));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("MKY-2");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            Assert.assertEquals((Object)"MKY-1", (Object)details.getKey());
            Assert.assertEquals((Object)"Bug", (Object)details.getIssueType());
            Assert.assertEquals((Object)"Blocker", (Object)details.getPriority());
            Assert.assertEquals((Object)"Fred Normal", (Object)details.getAssignee());
            Assert.assertEquals((Object)"Wilma Flinstone", (Object)details.getReporter());
            Assert.assertEquals((Object)"1", (Object)details.getVotes());
            this.tester.clickLink("view-voters");
            this.tester.assertTextPresent("voter_link_admin");
            this.tester.clickLinkWithText("MKY-1");
            Assert.assertEquals((Object)"1", (Object)details.getWatchers());
            this.tester.clickLink("manage-watchers");
            this.tester.assertLinkPresent("watcher_link_wilma");
            this.tester.clickLinkWithText("MKY-1");
            Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Resolve Issue"));
            Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
            Assert.assertEquals((Object)"monkey", (Object)details.getProjectName());
            Assert.assertEquals((Object)"This is the test bug with all the field values set.", (Object)details.getSummary());
            Assert.assertEquals((Object)"I am a description field", (Object)details.getDescription());
            Assert.assertEquals((Object)"03/Jun/08 3:00 PM", (Object)details.getCreatedDate());
            Assert.assertEquals((Object)"06/Jun/08 2:09 PM", (Object)details.getUpdatedDate());
            Assert.assertEquals((Object)"09/Jun/08", (Object)details.getDueDate());
            Assert.assertEquals(null, (Object)details.getResolutionDate());
            Assert.assertTrue((boolean)details.getComponents().contains("First Test Component"));
            Assert.assertTrue((boolean)details.getComponents().contains("Second Test Component"));
            Assert.assertTrue((boolean)details.getAffectsVersions().contains("Cool Version"));
            Assert.assertTrue((boolean)details.getAffectsVersions().contains("Uncool Version"));
            Assert.assertTrue((boolean)details.getFixVersions().contains("Uncool Version"));
            Assert.assertTrue((boolean)details.getFixVersions().contains("Medium Cool Version"));
            Assert.assertEquals((long)3L, (long)details.getLabels().size());
            Assert.assertTrue((boolean)details.getLabels().contains("duderino"));
            Assert.assertTrue((boolean)details.getLabels().contains("fancy"));
            Assert.assertTrue((boolean)details.getLabels().contains("labelset"));
            Assert.assertEquals((Object)"2d", (Object)details.getOriginalEstimate());
            Assert.assertEquals((Object)"20h", (Object)details.getRemainingEstimate());
            Assert.assertEquals((Object)"1d 4h", (Object)details.getTimeSpent());
            Assert.assertTrue((boolean)details.getAttachments().contains("bsattach.txt"));
            Assert.assertEquals((Object)"I am environment field", (Object)details.getEnvironment());
            this.tester.assertLinkPresentWithText("MKY-2");
            this.tester.assertLinkPresentWithText("HSP-1");
            this.tester.assertLinkPresentWithText("HSP-2");
            Assert.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Parent Option 1"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Child Option 1"));
            Assert.assertEquals((Object)"01/Jun/08 2:57 PM", (Object)details.getCustomFields().get("Date Time CF"));
            Assert.assertEquals((Object)"user-dudes", (Object)details.getCustomFields().get("Group Picker CF"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Labels CF", "duck duffy mickey mouse"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 2"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 1"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 1"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 2"));
            Assert.assertEquals((Object)"42.01", (Object)details.getCustomFields().get("Number Field CF"));
            Assert.assertEquals((Object)"Radio Option 1", (Object)details.getCustomFields().get("Radio Buttons CF"));
            Assert.assertEquals((Object)"Select List Option 1", (Object)details.getCustomFields().get("Select List CF"));
            Assert.assertEquals((Object)"I am text field 255 value.", (Object)details.getCustomFields().get("Text Field 255"));
            Assert.assertEquals((Object)"Fred Normal", (Object)details.getCustomFields().get("User Picker CF"));
            Assert.assertEquals((Object)"01/Apr/08", (Object)details.getCustomFields().get("Date Picker CF"));
            Assert.assertEquals((Object)"I am free text field value.", (Object)details.getCustomFields().get("Free Text Field CF"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "admin-dudes"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "dev-dudes"));
            Assert.assertEquals((Object)"homosapien", (Object)details.getCustomFields().get("Project Picker CF"));
            Assert.assertEquals((Object)"betty, Fred Normal", (Object)details.getCustomFields().get("Multi User Picker CF"));
            Assert.assertEquals((Object)"Medium Cool Version", (Object)details.getCustomFields().get("Single Version Picker CF"));
            Assert.assertEquals((Object)"http://www.google.com", (Object)details.getCustomFields().get("URL Field CF"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Medium Cool Version"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Cool Version"));
            Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Uncool Version"));
            this.gotoTab(COMMENTS);
            List<Comment> comments = this.parse.issue().parseComments();
            Assert.assertEquals((long)4L, (long)comments.size());
            Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Wilma, that has been edited.", "Wilma Flinstone added a comment  - 12/Jun/08 3:03 PM - edited")));
            Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by Adminstrator.", "Adminitrator added a comment  - 12/Jun/08 3:11 PM - Restricted to Developers")));
            Assert.assertTrue((boolean)comments.contains(new Comment("I am another Admin comment", "Adminitrator added a comment  - 12/Jun/08 3:15 PM - Restricted to jira-administrators")));
            Assert.assertTrue((boolean)comments.contains(new Comment("I am a comment added by betty.", "betty added a comment  - 12/Jun/08 3:16 PM - Restricted to jira-developers - edited")));
            this.gotoTab("Work Log");
            List<Worklog> worklogs = this.parse.issue().parseWorklogs();
            Assert.assertEquals((long)3L, (long)worklogs.size());
            Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am Fred logging work, edited.", "1 day", "Fred Normal logged work  - 12/Jun/08 3:13 PM - Restricted to Developers - edited")));
            Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am admin worklog.", "2 hours", "Adminitrator logged work  - 12/Jun/08 3:15 PM - Restricted to jira-developers")));
            Assert.assertTrue((boolean)worklogs.contains(new Worklog("I am a worklog added by Mrs. Rubble.", "2 hours", "betty logged work  - 12/Jun/08 3:18 PM")));
            this.gotoTab(CHANGE_HISTORY);
            ChangeHistoryList list = this.parse.issue().parseChangeHistory();
            list.assertContainsChangeHistory(this.getExpectedChangeHistoryListForAllData());
            this.navigation.issue().gotoIssue("HSP-1");
            this.tester.assertTextPresent("I am a homosap task");
            this.tester.assertLinkPresentWithText("MKY-1");
            ChangeHistoryList hsp1ChangeHistoryList = this.parse.issue().parseChangeHistory();
            hsp1ChangeHistoryList.assertContainsChangeHistory(this.getExpectedHSP1ChangeHistory());
            this.navigation.issue().viewIssue("HSP-2");
            ChangeHistoryList hsp2ChangeHistoryList = this.parse.issue().parseChangeHistory();
            hsp2ChangeHistoryList.assertContainsChangeHistory(this.getExpectedHSP2ChangeHistory());
        }
        finally {
            if (attachmentFile != null) {
                attachmentFile.delete();
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            if (issueDir != null) {
                issueDir.delete();
            }
            if (projectDir != null) {
                projectDir.delete();
            }
        }
    }

    private void gotoTab(String tab) {
        if (this.tester.getDialog().isLinkPresentWithText(tab)) {
            this.tester.clickLinkWithText(tab);
        }
    }

    @Test
    public void testIssueDataSimpleAllDataResolutionDate() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleDataResolutionDate.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Lead: Fred Normal"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"URL: http://monkeyproject.example.com"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Default Assignee: Project Lead"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Components: 3"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Versions: 3"));
        xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/table");
        String userRoleIssueResults = xPathLocator.getText();
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 2 out of 2"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Administrators: 1 users, 1 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Developers: 1 users, 2 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 1 users, 2 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Issues created: 3 out of 3"));
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("MKY-2");
        this.tester.assertTextPresent("MKY-3");
        this.navigation.issue().viewIssue("MKY-1");
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"monkey", (Object)details.getProjectName());
        Assert.assertEquals((Object)"This is the test bug with all the field values set.", (Object)details.getSummary());
        Assert.assertEquals((Object)"I am a description field", (Object)details.getDescription());
        Assert.assertEquals((Object)"03/Jun/08 3:00 PM", (Object)details.getCreatedDate());
        Assert.assertEquals((Object)"06/Jun/08 2:09 PM", (Object)details.getUpdatedDate());
        Assert.assertEquals((Object)"09/Jun/08", (Object)details.getDueDate());
        Assert.assertEquals(null, (Object)details.getResolutionDate());
        this.navigation.issue().viewIssue("MKY-3");
        ViewIssueDetails resolvedDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"This is the test bug with all the field values set and with resolution", (Object)resolvedDetails.getSummary());
        Assert.assertEquals((Object)"01/May/08 2:04 PM", (Object)resolvedDetails.getCreatedDate());
        Assert.assertEquals((Object)"01/Dec/08 2:05 PM", (Object)resolvedDetails.getUpdatedDate());
        Assert.assertEquals((Object)"09/Jun/08", (Object)resolvedDetails.getDueDate());
        Assert.assertEquals((Object)"19/Nov/08 2:04 PM", (Object)resolvedDetails.getResolutionDate());
    }

    @Test
    public void testNonExistantCustomFieldValueIsIgnoredAndImportIsSuccessful() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardNonExistantCustomFieldData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.textAssertions.assertTextPresentHtmlEncoded("The custom field 'Resolved date CF' will not be imported because the custom field type 'com.atlassian.jira.toolkit:resolveddate' is not installed.");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Lead: Fred Normal"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"URL: http://monkeyproject.example.com"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Default Assignee: Project Lead"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Components: 3"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Versions: 3"));
        xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/table");
        String userRoleIssueResults = xPathLocator.getText();
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 2 out of 2"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Administrators: 1 users, 1 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Developers: 1 users, 2 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 1 users, 2 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Issues created: 2 out of 2"));
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("MKY-2");
        this.navigation.issue().viewIssue("MKY-1");
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"MKY-1", (Object)details.getKey());
        Assert.assertEquals((Object)"Bug", (Object)details.getIssueType());
        Assert.assertEquals((Object)"Blocker", (Object)details.getPriority());
        Assert.assertEquals((Object)"Fred Normal", (Object)details.getAssignee());
        Assert.assertEquals((Object)"Wilma Flinstone", (Object)details.getReporter());
        Assert.assertEquals((Object)"1", (Object)details.getVotes());
        this.tester.clickLink("view-voters");
        this.tester.assertTextPresent("voter_link_admin");
        this.tester.clickLinkWithText("MKY-1");
        Assert.assertEquals((Object)"1", (Object)details.getWatchers());
        this.tester.clickLink("manage-watchers");
        this.tester.assertLinkPresent("watcher_link_wilma");
        this.tester.clickLinkWithText("MKY-1");
        Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Reopen Issue"));
        Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
        Assert.assertEquals((Object)"monkey", (Object)details.getProjectName());
        Assert.assertEquals((Object)"This is the test bug with all the field values set.", (Object)details.getSummary());
        Assert.assertEquals((Object)"I am a description field", (Object)details.getDescription());
        Assert.assertEquals((Object)"03/Jun/08 3:00 PM", (Object)details.getCreatedDate());
        Assert.assertEquals((Object)"06/Jun/08 2:09 PM", (Object)details.getUpdatedDate());
        Assert.assertEquals((Object)"09/Jun/08", (Object)details.getDueDate());
        Assert.assertTrue((boolean)details.getComponents().contains("First Test Component"));
        Assert.assertTrue((boolean)details.getComponents().contains("Second Test Component"));
        Assert.assertTrue((boolean)details.getAffectsVersions().contains("Cool Version"));
        Assert.assertTrue((boolean)details.getAffectsVersions().contains("Uncool Version"));
        Assert.assertTrue((boolean)details.getFixVersions().contains("Uncool Version"));
        Assert.assertTrue((boolean)details.getFixVersions().contains("Medium Cool Version"));
        Assert.assertEquals((Object)"2d", (Object)details.getOriginalEstimate());
        Assert.assertEquals((Object)"20h", (Object)details.getRemainingEstimate());
        Assert.assertEquals((Object)"1d 4h", (Object)details.getTimeSpent());
        Assert.assertEquals((Object)"I am environment field", (Object)details.getEnvironment());
        this.tester.assertLinkPresentWithText("MKY-2");
        this.tester.assertLinkPresentWithText("HSP-1");
        Assert.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Parent Option 1"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Cascading Select CF", "Child Option 1"));
        Assert.assertEquals((Object)"01/Jun/08 2:57 PM", (Object)details.getCustomFields().get("Date Time CF"));
        Assert.assertEquals((Object)"user-dudes", (Object)details.getCustomFields().get("Group Picker CF"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 2"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Checkboxes CF", "Multi Checkbox Option 1"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 1"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Select CF", "Multi Select Option 2"));
        Assert.assertEquals((Object)"42.01", (Object)details.getCustomFields().get("Number Field CF"));
        Assert.assertEquals((Object)"Radio Option 1", (Object)details.getCustomFields().get("Radio Buttons CF"));
        Assert.assertEquals((Object)"Select List Option 1", (Object)details.getCustomFields().get("Select List CF"));
        Assert.assertEquals((Object)"I am text field 255 value.", (Object)details.getCustomFields().get("Text Field 255"));
        Assert.assertEquals((Object)"Fred Normal", (Object)details.getCustomFields().get("User Picker CF"));
        Assert.assertEquals((Object)"01/Apr/08", (Object)details.getCustomFields().get("Date Picker CF"));
        Assert.assertEquals((Object)"I am free text field value.", (Object)details.getCustomFields().get("Free Text Field CF"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "admin-dudes"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Multi Group Picker CF", "dev-dudes"));
        Assert.assertEquals((Object)"homosapien", (Object)details.getCustomFields().get("Project Picker CF"));
        Assert.assertEquals((Object)"betty, Fred Normal", (Object)details.getCustomFields().get("Multi User Picker CF"));
        Assert.assertEquals((Object)"Medium Cool Version", (Object)details.getCustomFields().get("Single Version Picker CF"));
        Assert.assertEquals((Object)"http://www.google.com", (Object)details.getCustomFields().get("URL Field CF"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Medium Cool Version"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Cool Version"));
        Assert.assertTrue((boolean)details.customFieldValueContains("Version Picker CF", "Uncool Version"));
        Assert.assertNull((Object)details.getCustomFields().get("Resolved date CF"));
        this.tester.assertTextNotPresent("Resolved date CF");
    }

    @Test
    public void testIssueDataSimpleMinimalData() throws Exception {
        String expectedCreatedDate = "01/Jun/08 3:20 PM";
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Lead: Fred Normal"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"URL: http://monkeyproject.example.com"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Default Assignee: Project Lead"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Components: 3"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Versions: 3"));
        xPathLocator = new XPathLocator(this.tester, "//div[@id='customfields']/table");
        String userRoleIssueResults = xPathLocator.getText();
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 2 out of 2"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Administrators: 1 users, 1 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Developers: 1 users, 2 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Users: 1 users, 2 groups"));
        Assert.assertThat((Object)userRoleIssueResults, (Matcher)JUnitMatchers.containsString((String)"Issues created: 2 out of 2"));
        this.navigation.issue().viewIssue("MKY-2");
        ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"MKY-2", (Object)details.getKey());
        Assert.assertEquals((Object)"New Feature", (Object)details.getIssueType());
        Assert.assertEquals((Object)"Critical", (Object)details.getPriority());
        Assert.assertEquals((Object)"Fred Normal", (Object)details.getAssignee());
        Assert.assertEquals((Object)"Adminitrator", (Object)details.getReporter());
        Assert.assertEquals((Object)"0", (Object)details.getVotes());
        Assert.assertEquals((Object)"0", (Object)details.getWatchers());
        Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Resolve Issue"));
        Assert.assertTrue((boolean)details.getAvailableWorkflowActions().contains("Close Issue"));
        Assert.assertEquals((Object)"monkey", (Object)details.getProjectName());
        Assert.assertEquals((Object)"I am a test issue with almost no field values set", (Object)details.getSummary());
        Assert.assertEquals((Object)"01/Jun/08 3:20 PM", (Object)details.getCreatedDate());
        Assert.assertEquals((Object)"02/Jun/08 3:53 PM", (Object)details.getUpdatedDate());
        Assert.assertEquals(null, (Object)details.getDueDate());
        Assert.assertEquals((Object)"Click to add description", (Object)details.getDescription());
        Assert.assertTrue((boolean)details.getComponents().contains("None"));
        Assert.assertTrue((boolean)details.getAffectsVersions().contains("None"));
        Assert.assertTrue((boolean)details.getFixVersions().contains("None"));
        Assert.assertEquals(null, (Object)details.getOriginalEstimate());
        Assert.assertEquals(null, (Object)details.getRemainingEstimate());
        Assert.assertEquals(null, (Object)details.getTimeSpent());
        Assert.assertEquals((long)0L, (long)details.getAttachments().size());
        Assert.assertEquals(null, (Object)details.getEnvironment());
        this.tester.assertLinkPresentWithText("MKY-1");
        Assert.assertEquals((long)1L, (long)details.getCustomFields().size());
        Assert.assertEquals((Object)"betty", (Object)details.getCustomFields().get("User Picker CF"));
        this.gotoTab(COMMENTS);
        List<Comment> comments = this.parse.issue().parseComments();
        Assert.assertEquals((long)0L, (long)comments.size());
        this.tester.clickLinkWithText("Work Log");
        List<Worklog> worklogs = this.parse.issue().parseWorklogs();
        Assert.assertEquals((long)0L, (long)worklogs.size());
        this.tester.clickLinkWithText(CHANGE_HISTORY);
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsChangeHistory(this.getExpectedChangeHistoryListForMinimal());
        ChangeHistorySet changeHistorySet = (ChangeHistorySet)list.get(list.size() - 1);
        Assert.assertEquals((Object)"Adminitrator", (Object)changeHistorySet.getChangedBy());
        Assert.assertEquals((Object)"Link", (Object)((ChangeHistoryField)changeHistorySet.getFieldChanges().iterator().next()).getFieldName());
    }

    private ChangeHistoryList getExpectedChangeHistoryListForMinimal() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Adminitrator").add("Link", null, "This issue duplicates MKY-1 [ MKY-1 ]");
        expectedList.addChangeSet("Adminitrator").add("User Picker CF", null, "betty");
        return expectedList;
    }

    private ChangeHistoryList getExpectedHSP1ChangeHistory() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("fred").add("Link", null, "This issue duplicates MKY-1 [ MKY-1 ]");
        expectedList.addChangeSet("Adminitrator").add("Link", "This issue duplicates MKY-1 [ MKY-1 ]", null);
        expectedList.addChangeSet("Adminitrator").add("Reporter", "Fred Normal [ deactivated user ]", "Adminitrator [ admin ]");
        expectedList.addChangeSet("Adminitrator").add("Link", null, "This issue duplicates MKY-1 [ MKY-1 ]");
        return expectedList;
    }

    private ChangeHistoryList getExpectedHSP2ChangeHistory() {
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Adminitrator").add("Link", null, "This issue is duplicated by MKY-1 [ MKY-1 ]");
        return expectedList;
    }

    private ChangeHistoryList getExpectedChangeHistoryListForAllData() {
        String VERSION_PICKER_CF_FINAL_VALUE = "Cool Version, Uncool Version, Medium Cool Version [ 10010, 10011, 10012 ]";
        String LABELS_FIELD = "Labels";
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Adminitrator").add("Labels CF", "duffy duck mickey mouse").add("Version Picker CF", "Cool Version, Medium Cool Version, Uncool Version [ 10010, 10012, 10011 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10010, 10011, 10012 ]").add("Labels", "[ duderino fancy labelset ]", "[ duderino fancy labelset ]");
        expectedList.addChangeSet("Adminitrator").add("Version Picker CF", "Medium Cool Version, Uncool Version, Cool Version [ 10012, 10011, 10010 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10010, 10011, 10012 ]").add("Labels", "[ dude is sweat this ]", "[ duderino fancy labelset ]");
        expectedList.addChangeSet("Adminitrator").add("Version Picker CF", "Medium Cool Version, Cool Version, Uncool Version [ 10012, 10010, 10011 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10010, 10011, 10012 ]").add("Labels", "[ is sweat this ]", "[ dude is sweat this ]");
        expectedList.addChangeSet("Adminitrator").add("Link", "This issue duplicates HSP-2 [ HSP-2 ]");
        expectedList.addChangeSet("Adminitrator").add("Fix Version/s", null, "Uncool Version [ 10001 ]").add("Fix Version/s", null, "Medium Cool Version [ 10002 ]").add("Multi Checkboxes CF", "[Multi Checkbox Option 2, Multi Checkbox Option 1]", "[Multi Checkbox Option 1, Multi Checkbox Option 2]").add("Version Picker CF", "Medium Cool Version, Cool Version, Uncool Version [ 10012, 10010, 10011 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10010, 10011, 10012 ]");
        expectedList.addChangeSet("Fred Normal").add("Link", null, "This issue is duplicated by HSP-1 [ HSP-1 ]");
        expectedList.addChangeSet("Fred Normal").add("Version Picker CF", "Medium Cool Version, Uncool Version, Cool Version [ 10012, 10011, 10010 ]", "Cool Version, Uncool Version, Medium Cool Version [ 10010, 10011, 10012 ]").add("Multi Checkboxes CF", "[Multi Checkbox Option 2, Multi Checkbox Option 1]", "[Multi Checkbox Option 1, Multi Checkbox Option 2]").add("Due Date", "2008-07-02 00:00:00.0").add("Multi Select CF", "[Multi Select Option 2, Multi Select Option 1]", "[Multi Select Option 1, Multi Select Option 2]");
        expectedList.addChangeSet("Fred Normal").add("Status", "Open [ 1 ]", "In Progress [ 3 ]");
        return expectedList;
    }

    @Test
    public void testCreateProject() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataEmptyMKYProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        this.tester.clickLinkWithText("MKY");
        this.assertions.getSidebarAssertions().assertProjectName("monkey");
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project project = pc.get("MKY");
        Assert.assertEquals((Object)"monkey", (Object)project.name);
        Assert.assertEquals((Object)"This is a description for a monkey project.", (Object)project.description);
        Assert.assertEquals((Object)"http://monkeyproject.example.com", (Object)project.url);
        Assert.assertEquals((Object)"Fred Normal", (Object)project.lead.displayName);
        this.assertMonkeyProjectParts(false);
    }

    private void assertMonkeyProjectParts(boolean testComponentLead) {
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        List components = pc.getComponents("MKY");
        Assert.assertEquals((long)3L, (long)components.size());
        Assert.assertEquals((Object)"First Test Component", (Object)((Component)components.get((int)0)).name);
        if (testComponentLead) {
            Assert.assertEquals((Object)"wilma", (Object)((Component)components.get((int)0)).lead.name);
        }
        Assert.assertEquals((Object)"Second Test Component", (Object)((Component)components.get((int)1)).name);
        Assert.assertEquals((Object)"Third Test Component", (Object)((Component)components.get((int)2)).name);
        List versions = pc.getVersions("MKY");
        Assert.assertEquals((long)3L, (long)versions.size());
        Assert.assertEquals((Object)"Cool Version", (Object)((Version)versions.get((int)0)).name);
        Assert.assertEquals((Object)"Uncool Version", (Object)((Version)versions.get((int)1)).name);
        Assert.assertEquals((Object)"Medium Cool Version", (Object)((Version)versions.get((int)2)).name);
        ProjectRoleClient prc = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        Map mky = prc.get("MKY");
        Assert.assertEquals((long)3L, (long)mky.size());
        ProjectRole projectRole = prc.get("MKY", "Administrators");
        Assert.assertEquals((long)2L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"admin-dudes", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).type);
        Assert.assertEquals((Object)"admin", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).name);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).type);
        projectRole = prc.get("MKY", "Developers");
        Assert.assertEquals((long)3L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"dev-dudes", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).type);
        Assert.assertEquals((Object)"fred", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).name);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).type);
        Assert.assertEquals((Object)"jira-developers", (Object)((ProjectRole.Actor)projectRole.actors.get((int)2)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)2)).type);
        projectRole = prc.get("MKY", "Users");
        Assert.assertEquals((long)3L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"jira-users", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).type);
        Assert.assertEquals((Object)"user-dudes", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)1)).type);
        Assert.assertEquals((Object)"wilma", (Object)((ProjectRole.Actor)projectRole.actors.get((int)2)).name);
        Assert.assertEquals((Object)"atlassian-user-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)2)).type);
    }

    @Test
    public void testUpdateProjectOverwriteDetails() throws Exception {
        this.temporaryFileRule.add(this.doProjectImportUpdateProject("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml", true));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        this.tester.submit("OK");
        this.assertions.getSidebarAssertions().assertProjectName("monkey");
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project project = pc.get("MKY");
        Assert.assertEquals((Object)"monkey", (Object)project.name);
        Assert.assertEquals((Object)"This is a description for a monkey project.", (Object)project.description);
        Assert.assertEquals((Object)"http://monkeyproject.example.com", (Object)project.url);
        Assert.assertEquals((Object)"Fred Normal", (Object)project.lead.displayName);
        this.assertMonkeyProjectParts(false);
    }

    @Test
    public void testUpdateProjectOverwriteDetailsWithSenderAddressAndComponentLeads() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportEnterpriseSimpleData.xml", "TestProjectImportEnterpriseSimpleDataEmptyProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Sender Address: jira-monkey-test@example.com"));
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project mky = pc.get("MKY");
        Assert.assertEquals((Object)"MKY", (Object)mky.key);
        Assert.assertEquals((Object)"monkey", (Object)mky.name);
        Assert.assertEquals((Object)"This is a description for a monkey project.", (Object)mky.description);
        Assert.assertEquals((Object)"fred", (Object)mky.lead.name);
        Assert.assertThat((Object)mky.email, (Matcher)CoreMatchers.equalTo((Object)"jira-monkey-test@example.com"));
        this.assertMonkeyProjectParts(true);
    }

    @Test
    public void testUpdateProjectDoNotOverwriteDetails() throws Exception {
        this.temporaryFileRule.add(this.doProjectImportUpdateProject("TestProjectImportStandardSimpleData.xml", "TestProjectImportStandardSimpleDataNoProject.xml", false));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: existing monk thing"));
        ProjectClient pc = new ProjectClient((JIRAEnvironmentData)this.environmentData);
        Project project = pc.get("MKY");
        Assert.assertEquals((Object)"King Monkey", (Object)project.name);
        Assert.assertEquals((Object)"existing monk thing", (Object)project.description);
        Assert.assertEquals((Object)"http://www.kingkong.net", (Object)project.url);
        Assert.assertEquals((Object)"John Smith", (Object)project.lead.displayName);
        List components = pc.getComponents("MKY");
        Assert.assertEquals((long)3L, (long)components.size());
        Assert.assertEquals((Object)"First Test Component", (Object)((Component)components.get((int)0)).name);
        Assert.assertEquals((Object)"Second Test Component", (Object)((Component)components.get((int)1)).name);
        Assert.assertEquals((Object)"Third Test Component", (Object)((Component)components.get((int)2)).name);
        List versions = pc.getVersions("MKY");
        Assert.assertEquals((long)3L, (long)versions.size());
        Assert.assertEquals((Object)"Cool Version", (Object)((Version)versions.get((int)0)).name);
        Assert.assertEquals((Object)"Uncool Version", (Object)((Version)versions.get((int)1)).name);
        Assert.assertEquals((Object)"Medium Cool Version", (Object)((Version)versions.get((int)2)).name);
        ProjectRoleClient prc = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData);
        Map mky = prc.get("MKY");
        Assert.assertEquals((long)3L, (long)mky.size());
        ProjectRole projectRole = prc.get("MKY", "Administrators");
        Assert.assertEquals((long)1L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"jira-administrators", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).type);
        projectRole = prc.get("MKY", "Developers");
        Assert.assertEquals((long)1L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"jira-developers", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).type);
        projectRole = prc.get("MKY", "Users");
        Assert.assertEquals((long)1L, (long)projectRole.actors.size());
        Assert.assertEquals((Object)"jira-users", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).name);
        Assert.assertEquals((Object)"atlassian-group-role-actor", (Object)((ProjectRole.Actor)projectRole.actors.get((int)0)).type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testViewIssueIssueSecurityLevel() throws Exception {
        try {
            this.temporaryFileRule.add(this.doProjectImport("TestProjectImportEnterpriseSimpleData.xml", "TestProjectImportEnterpriseSimpleDataEmptyProject.xml"));
            this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
            this.tester.assertSubmitButtonPresent("Import");
            this.tester.submit("Import");
            this.advanceThroughWaitingPage();
            XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
            String projectDetailsResults = xPathLocator.getText();
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
            Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextPresent("MKY-1");
            this.tester.assertTextPresent("MKY-2");
            this.navigation.issue().viewIssue("MKY-1");
            ViewIssueDetails details = this.parse.issue().parseViewIssuePage();
            Assert.assertEquals((Object)"MKY-1", (Object)details.getKey());
            Assert.assertEquals((Object)"Security Level 3", (Object)details.getSecurityLevel());
            this.navigation.issue().viewIssue("MKY-2");
            details = this.parse.issue().parseViewIssuePage();
            Assert.assertEquals((Object)"MKY-2", (Object)details.getKey());
            Assert.assertEquals((Object)"Security Level 2", (Object)details.getSecurityLevel());
            this.navigation.logout();
            this.navigation.login("wilma", "wilma");
            this.navigation.issue().viewIssue("MKY-1");
            this.assertions.getViewIssueAssertions().assertIssueNotFound();
            this.navigation.issue().viewIssue("MKY-2");
            this.assertions.getViewIssueAssertions().assertIssueNotFound();
            this.navigation.issueNavigator().displayAllIssues();
            this.tester.assertTextNotPresent("MKY-1");
            this.tester.assertTextNotPresent("MKY-2");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin", "admin");
        }
    }

    @Test
    public void testIssueWorkflowActionsNonStandardWorkflow() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportEnterpriseCrazyWorkflowData.xml", "TestProjectImportEnterpriseCrazyWorkflowDataEmptyProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.assertTextPresent("This is the test bug with all the field values set.");
        ViewIssueDetails viewIssueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Dangerous"));
        Assert.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Crazy Done"));
        this.workflowUtil.clickAction(TRANSITION_BE_DANGEROUS);
        viewIssueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Dylan"));
        Assert.assertTrue((boolean)viewIssueDetails.getAvailableWorkflowActions().contains("Be Mark"));
        Assert.assertEquals((long)2L, (long)viewIssueDetails.getAvailableWorkflowActions().size());
    }

    @Test
    public void testImportSubtask() throws Exception {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportEnterpriseSimpleData.xml", "TestProjectImportEnterpriseSimpleDataEmptyProject.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Description: This is a description for a monkey project."));
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("MKY-1");
        this.tester.assertTextPresent("MKY-2");
        this.tester.assertTextPresent("MKY-3");
        this.navigation.issue().viewIssue("MKY-3");
        ViewIssueDetails issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertEquals((Object)"MKY-3", (Object)issueDetails.getKey());
        Assert.assertEquals((Object)"Sub-task 2", (Object)issueDetails.getIssueType());
        Assert.assertEquals((Object)"Gotta do some small stuff to get teh parent done.", (Object)issueDetails.getDescription());
        this.tester.assertLinkPresentWithText("MKY-1");
        this.tester.clickLink("subtask-to-issue");
        this.tester.assertTextPresent("Convert Sub-task to Issue: MKY-3");
    }

    @Test
    public void testCustomFieldOptionsImportWithConfigSchemesMismatch() {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportSummaryCustomFieldOptions3_source.xml", "TestProjectImportSummaryCustomFieldOptions3_target.xml"));
        this.tester.assertTextPresent("The results of automatic mapping are displayed below. You will not be able to continue if any validation errors were raised");
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: MKY"));
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Project Type: Business"));
        this.navigation.issue().viewIssue("MKY-1");
        ViewIssueDetails issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertThat((Object)issueDetails.customFieldValueContains("target_milestone", "X"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Multi  select cf", "option 2"), (Matcher)CoreMatchers.is((Object)true));
        this.navigation.issue().viewIssue("MKY-2");
        issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertThat((Object)issueDetails.customFieldValueContains("target_milestone", "Y"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Multi  select cf", "option 1"), (Matcher)CoreMatchers.is((Object)true));
        this.navigation.issue().viewIssue("MKY-5");
        issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertThat((Object)issueDetails.customFieldValueContains("target_milestone", "X"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Multi  select cf", "option 1"), (Matcher)CoreMatchers.is((Object)true));
        this.navigation.issue().viewIssue("MKY-6");
        issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertThat((Object)issueDetails.customFieldValueContains("target_milestone", "Y"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Multi  select cf", "option 2"), (Matcher)CoreMatchers.is((Object)true));
        this.navigation.issue().viewIssue("MKY-7");
        issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Multi  select cf", "option 1"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Multi  select cf", "option 2"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=76001)
    public void testCustomFieldOptionsImportWhenFieldconfigschemeAndFieldconfigurationIdsMismatch() {
        this.temporaryFileRule.add(this.doProjectImport("TestProjectImportSummaryCustomFieldOptions4_source.xml", "TestProjectImportSummaryCustomFieldOptions4_target.xml", "TEST"));
        this.tester.assertSubmitButtonPresent("Import");
        this.tester.submit("Import");
        this.advanceThroughWaitingPage();
        XPathLocator xPathLocator = new XPathLocator(this.tester, "//div[@id='systemfields']/table");
        String projectDetailsResults = xPathLocator.getText();
        Assert.assertThat((Object)projectDetailsResults, (Matcher)JUnitMatchers.containsString((String)"Key: TEST"));
        this.navigation.issue().viewIssue("TEST-1");
        ViewIssueDetails issueDetails = this.parse.issue().parseViewIssuePage();
        Assert.assertThat((Object)issueDetails.customFieldValueContains("Car", "Peugeot"), (Matcher)CoreMatchers.is((Object)true));
    }

    File doProjectImportUpdateProject(String backupFileName, String currentSystemXML, boolean overwrite) {
        File tempFile = this.importAndExportBackupAndSetupCurrentInstance(backupFileName, currentSystemXML);
        long projectId = this.administration.project().addProject("King Monkey", "MKY", "john");
        this.administration.project().editProject(projectId, null, "existing monk thing", "http://www.kingkong.net");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", tempFile.getAbsolutePath());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        if (overwrite) {
            this.tester.checkCheckbox("overwrite", "true");
        } else {
            this.tester.uncheckCheckbox("overwrite");
        }
        this.tester.submit("Next");
        this.advanceThroughWaitingPage();
        return tempFile;
    }

    public void navigateToUser(String username) {
        this.logger.log((Object)("Navigating in UserBrowser to User " + username));
        this.tester.gotoPage(PAGE_USER_BROWSER);
        this.tester.clickLink(username);
    }

    private class OnboardingEnabler
    implements AutoCloseable {
        private final boolean enabled;

        public OnboardingEnabler() {
            this.enabled = TestProjectImportResults.this.backdoor.darkFeatures().isGlobalEnabled("jira.onboarding.feature.disabled");
            if (this.enabled) {
                TestProjectImportResults.this.backdoor.darkFeatures().disableForSite("jira.onboarding.feature.disabled");
            }
        }

        @Override
        public void close() {
            if (this.enabled) {
                TestProjectImportResults.this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
            }
        }
    }
}

