/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.imports.project;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.imports.project.BaseJiraProjectImportFuncTest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PROJECT_IMPORT})
@LoginAs(user="admin")
@Restore(value="TestProjectImportSelectProject.xml")
public class TestProjectImportSelectProject
extends BaseJiraProjectImportFuncTest {
    private File tempFile;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        String fileName = "TestProjectImportSelectProject_out.xml";
        this.logger.log((Object)String.format("Using temporary file '%s'.", "TestProjectImportSelectProject_out.xml"));
        File zipFile = this.administration.exportDataToFile("TestProjectImportSelectProject_out.xml");
        this.tempFile = this.copyFileToJiraImportDirectory(zipFile);
    }

    @After
    public void tearDownTest() {
        if (!this.tempFile.delete()) {
            this.logger.log((Object)String.format("Unable to delete file '%s'.", this.tempFile.getAbsoluteFile().getPath()));
        }
    }

    @Test
    public void testJumpToSelectProjectScreen() {
        this.tester.gotoPage("/secure/admin/ProjectImportSelectProject!default.jspa");
        this.tester.assertTextPresent("There are no projects to display. Perhaps your session has timed out, please restart the project import wizard.");
    }

    @Test
    public void testValidationErrors() {
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.tester.gotoPage("/secure/project/EditProjectLeadAndDefaultAssignee!default.jspa?pid=" + projectId);
        this.tester.selectOption("assigneeType", "Project Lead");
        this.tester.submit("Update");
        this.administration.generalConfiguration().setAllowUnassignedIssues(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getName());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "homosapien");
        this.tester.submit("Next");
        this.textAssertions.assertTextPresentHtmlEncoded("The existing project with key 'HSP' contains '26' issues. You can not import a backup project into a project that contains existing issues.");
        this.textAssertions.assertTextPresentHtmlEncoded("The existing project with key 'HSP' contains '3' versions. You can not import a backup project into a project that contains existing versions.");
        this.textAssertions.assertTextPresentHtmlEncoded("The existing project with key 'HSP' contains '3' components. You can not import a backup project into a project that contains existing components.");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' has 'unassigned' default assignee, but this Jira instance does not allow unassigned issues.");
    }

    @Test
    public void testCustomFieldsWrongVersion() throws IOException {
        this.modifyCustomFieldPluginVersion();
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getName());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'text cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textarea'. In the current instance of Jira the plugin is at version '1.0', but in the backup it is at version '10.0'.");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'target_milestone' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:select'. In the current instance of Jira the plugin is at version '1.0', but in the backup it is at version '10.0'.");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'fgsdfgsd' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textfield'. In the current instance of Jira the plugin is at version '1.0', but in the backup it is at version '10.0'.");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'number cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:float'. In the current instance of Jira the plugin is at version '1.0', but in the backup it is at version '10.0'.");
    }

    @Test
    public void testCustomFieldsPluginDoesNotExist() throws IOException {
        this.deleteCustomFieldPluginVersion();
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
        this.tester.setWorkingForm("project-import");
        this.tester.assertTextPresent("Project Import: Select Backup File");
        this.tester.setFormElement("backupPath", this.tempFile.getName());
        this.tester.submit();
        this.advanceThroughWaitingPage();
        this.tester.assertTextPresent("Project Import: Select Project to Import");
        this.tester.selectOption("projectKey", "monkey");
        this.tester.submit("Next");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'fgsdfgsd' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textfield'. In the current instance of Jira the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'number cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:float'. In the current instance of Jira the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'target_milestone' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:select'. In the current instance of Jira the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
        this.textAssertions.assertTextPresentHtmlEncoded("The backup project 'monkey' requires custom field named 'text cf' with full key 'com.atlassian.jira.plugin.system.customfieldtypes:textarea'. In the current instance of Jira the plugin is at version '1.0', but this custom field was not installed in the backup data. You may want to create an XML backup with this version of the plugin installed.");
    }

    @Test
    public void testParseExceptionInJIRAData() throws Exception {
        File file = this.importAndExportBackupAndSetupCurrentInstance("TestProjectImportParseExceptionScreen2.xml", "TestProjectImportSummaryNoCustomFields2.xml");
        try {
            this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_IMPORT);
            this.tester.setWorkingForm("project-import");
            this.tester.assertTextPresent("Project Import: Select Backup File");
            this.tester.setFormElement("backupPath", file.getAbsolutePath());
            this.tester.submit();
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.selectOption("projectKey", "monkey");
            this.tester.submit("Next");
            this.advanceThroughWaitingPage();
            this.tester.assertTextPresent("Project Import: Select Project to Import");
            this.tester.assertTextPresent("There was a problem parsing the backup XML file at");
            this.tester.assertTextPresent("A worklog must have an issue id specified.");
        }
        finally {
            file.delete();
        }
    }

    private void modifyCustomFieldPluginVersion() throws IOException {
        ZipFile zip = new ZipFile(this.tempFile);
        String ofbizData = this.getZipEntryAsString(zip, "entities.xml");
        ofbizData = StringUtils.replace((String)ofbizData, (String)"<PluginVersion id=\"10002\" name=\"Custom Field Types &amp; Searchers\" key=\"com.atlassian.jira.plugin.system.customfieldtypes\" version=\"1.0\"/>", (String)"<PluginVersion id=\"10002\" name=\"Custom Field Types &amp; Searchers\" key=\"com.atlassian.jira.plugin.system.customfieldtypes\" version=\"10.0\"/>");
        String aoData = this.getZipEntryAsString(zip, "activeobjects.xml");
        this.rebuildZipFile(ofbizData, aoData);
    }

    private void deleteCustomFieldPluginVersion() throws IOException {
        ZipFile zip = new ZipFile(this.tempFile);
        String ofbizData = this.getZipEntryAsString(zip, "entities.xml");
        ofbizData = StringUtils.replace((String)ofbizData, (String)"<PluginVersion id=\"10002\" name=\"Custom Field Types &amp; Searchers\" key=\"com.atlassian.jira.plugin.system.customfieldtypes\" version=\"1.0\"/>", (String)"");
        String aoData = this.getZipEntryAsString(zip, "activeobjects.xml");
        this.rebuildZipFile(ofbizData, aoData);
    }

    private void rebuildZipFile(String ofbizData, String aoData) throws IOException {
        ZipOutputStream os = new ZipOutputStream(new FileOutputStream(this.tempFile));
        OutputStreamWriter fw = new OutputStreamWriter(os);
        os.putNextEntry(new ZipEntry("entities.xml"));
        fw.write(ofbizData);
        ((Writer)fw).flush();
        os.closeEntry();
        os.putNextEntry(new ZipEntry("activeobjects.xml"));
        fw.write(aoData);
        ((Writer)fw).flush();
        os.closeEntry();
        os.close();
    }

    private String getZipEntryAsString(ZipFile zip, String entryName) throws IOException {
        ZipEntry entry = zip.getEntry(entryName);
        StringWriter stringWriter = new StringWriter();
        InputStreamReader in = new InputStreamReader(zip.getInputStream(entry));
        this.copy(in, stringWriter, 4096);
        in.close();
        String s = stringWriter.toString();
        stringWriter.close();
        return s;
    }

    private void copy(Reader input, Writer output, int bufferSize) throws IOException {
        char[] buffer = new char[bufferSize];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }
}

