/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.backdoor.EntityVersioningControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.OptionalMatchers;
import com.atlassian.jira.webtests.ztests.indexing.EntityVersion;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING})
@RestoreBlankInstance
public class TestEntityVersioning
extends BaseJiraFuncTest {
    private static final long DEFAULT_PARENT_ID = 999L;
    private EntityVersioningControl entityVersioningControl;

    @Before
    public void setUp() throws Exception {
        this.entityVersioningControl = this.backdoor.entityVersioningControl();
    }

    @Test
    public void incrementIssueVersionShouldCreateAndUpdateRowsIndependentlyForEntities() {
        this.incrementEntityVersionShouldCreateAndUpdateRowsIndependentlyForEntities(this.entityVersioningControl::getAllIssueVersions, this.issueVersionIncrementer(), "issue");
    }

    @Test
    public void incrementCommentVersionShouldCreateAndUpdateRowsIndependentlyForEntities() {
        this.incrementEntityVersionShouldCreateAndUpdateRowsIndependentlyForEntities(this.entityVersioningControl::getAllCommentVersions, this.entityVersioningControl::incrementCommentVersion, "comment");
    }

    @Test
    public void incrementWorklogVersionShouldCreateAndUpdateRowsIndependentlyForEntities() {
        this.incrementEntityVersionShouldCreateAndUpdateRowsIndependentlyForEntities(this.entityVersioningControl::getAllWorklogVersions, this.entityVersioningControl::incrementWorklogVersion, "worklog");
    }

    private void incrementEntityVersionShouldCreateAndUpdateRowsIndependentlyForEntities(Supplier<List<EntityVersioningControl.EntityVersionBean>> versionsFetcher, BiConsumer<Long, Long> versionIncrementer, String entityType) {
        LocalDateTime now = this.getDbTime();
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        versionIncrementer.accept(42L, 999L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.contains((Matcher)new EntityVersion(42L, 999L, entityType, now, 1L, false)));
        versionIncrementer.accept(42L, 999L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.contains((Matcher)new EntityVersion(42L, 999L, entityType, now, 2L, false)));
        versionIncrementer.accept(89L, 999L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new EntityVersion(42L, 999L, entityType, now, 2L, false), new EntityVersion(89L, 999L, entityType, now, 1L, false)}));
        versionIncrementer.accept(42L, 999L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new EntityVersion(42L, 999L, entityType, now, 3L, false), new EntityVersion(89L, 999L, entityType, now, 1L, false)}));
    }

    @Test
    public void updateIssueVersionEntityDeletedShouldMarkOnlyTheDeletedIssueAsDeleted() {
        this.updateEntityVersionEntityDeletedShouldMarkOnlyTheDeletedEntityAsDeleted(this.entityVersioningControl::getAllIssueVersions, this.issueVersionIncrementer(), this.entityVersioningControl::markIssueDeletedAndUpdateVersion, "issue");
    }

    @Test
    public void updateCommentVersionEntityDeletedShouldMarkOnlyTheDeletedCommentAsDeleted() {
        this.updateEntityVersionEntityDeletedShouldMarkOnlyTheDeletedEntityAsDeleted(this.entityVersioningControl::getAllCommentVersions, this.entityVersioningControl::incrementCommentVersion, this.entityVersioningControl::markCommentDeletedAndUpdateVersion, "comment");
    }

    @Test
    public void updateWorklogVersionEntityDeletedShouldMarkOnlyTheDeletedWorklogAsDeleted() {
        this.updateEntityVersionEntityDeletedShouldMarkOnlyTheDeletedEntityAsDeleted(this.entityVersioningControl::getAllWorklogVersions, this.entityVersioningControl::incrementWorklogVersion, this.entityVersioningControl::markWorklogDeletedAndUpdateVersion, "worklog");
    }

    private void updateEntityVersionEntityDeletedShouldMarkOnlyTheDeletedEntityAsDeleted(Supplier<List<EntityVersioningControl.EntityVersionBean>> versionsFetcher, BiConsumer<Long, Long> versionIncrementer, Consumer<Long> deletesMarker, String entityType) {
        LocalDateTime now = this.getDbTime();
        versionIncrementer.accept(42L, 999L);
        versionIncrementer.accept(89L, 999L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new EntityVersion(42L, 999L, entityType, now, 1L, false), new EntityVersion(89L, 999L, entityType, now, 1L, false)}));
        deletesMarker.accept(42L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new EntityVersion(42L, 999L, entityType, now, 2L, true), new EntityVersion(89L, 999L, entityType, now, 1L, false)}));
    }

    @Test
    public void getIssueVersionShouldReturnValueForSelectedIssue() {
        this.getEntityVersionShouldReturnValueForSelectedEntity(this.issueVersionIncrementer(), this.entityVersioningControl::getIssueVersion);
    }

    @Test
    public void getCommentVersionShouldReturnValueForSelectedComment() {
        this.getEntityVersionShouldReturnValueForSelectedEntity(this.entityVersioningControl::incrementCommentVersion, this.entityVersioningControl::getCommentVersion);
    }

    @Test
    public void getWorklogVersionShouldReturnValueForSelectedWorklog() {
        this.getEntityVersionShouldReturnValueForSelectedEntity(this.entityVersioningControl::incrementWorklogVersion, this.entityVersioningControl::getWorklogVersion);
    }

    private void getEntityVersionShouldReturnValueForSelectedEntity(BiConsumer<Long, Long> versionIncrementer, Function<Long, Optional<Long>> versionFetcher) {
        long entityOneId = 42L;
        long entityOneNumIncrements = 4L;
        int i = 0;
        while ((long)i <= 4L) {
            versionIncrementer.accept(42L, 999L);
            ++i;
        }
        long entityTwoId = 89L;
        long entityTwoNumIncrements = 6L;
        int i2 = 0;
        while ((long)i2 <= 6L) {
            versionIncrementer.accept(89L, 999L);
            ++i2;
        }
        MatcherAssert.assertThat(versionFetcher.apply(42L), (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)5L)));
        MatcherAssert.assertThat(versionFetcher.apply(89L), (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)7L)));
    }

    @Test
    public void getRelatedCommentVersionsShouldReturnValuesOnlyForSelectedParentEntity() {
        this.getRelatedEntityVersions(this::makeCommentVersionRow, this.entityVersioningControl::getRelatedCommentVersions, "comment");
    }

    @Test
    public void getRelatedWorklogVersionsShouldReturnValuesOnlyForSelectedParentEntity() {
        this.getRelatedEntityVersions(this::makeWorklogVersionRow, this.entityVersioningControl::getRelatedWorklogVersions, "worklog");
    }

    private void getRelatedEntityVersions(Consumer<EntityVersion> rowMaker, Function<Long, Map<Long, Long>> versionsFetcher, String entityType) {
        LocalDateTime now = this.getDbTime();
        long parentIssueId1 = 10001L;
        long parentIssueId2 = 10002L;
        EntityVersion issue1Entity42 = new EntityVersion(42L, 10001L, entityType, now, 4L, false);
        EntityVersion issue1Entity51 = new EntityVersion(51L, 10001L, entityType, now, 23L, false);
        EntityVersion issue2Entity89 = new EntityVersion(89L, 10002L, entityType, now, 9L, false);
        EntityVersion issue2Entity91 = new EntityVersion(91L, 10002L, entityType, now, 5L, true);
        rowMaker.accept(issue1Entity42);
        rowMaker.accept(issue1Entity51);
        rowMaker.accept(issue2Entity89);
        rowMaker.accept(issue2Entity91);
        MatcherAssert.assertThat(versionsFetcher.apply(10001L), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)42L, (Object)4L, (Object)51L, (Object)23L)));
        MatcherAssert.assertThat(versionsFetcher.apply(10002L), (Matcher)Matchers.is((Object)ImmutableMap.of((Object)89L, (Object)9L)));
    }

    @Test
    public void cleanDeletedIssueVersionsShouldOnlyDeleteVersionsOlderThanThreshold() {
        this.cleanDeletedEntityVersionsAndCheckThatThresholdWasObeyed(this::makeIssueVersionRow, this.entityVersioningControl::getAllIssueVersions, "issue");
    }

    @Test
    public void cleanDeletedCommentVersionsShouldOnlyDeleteVersionsOlderThanThreshold() {
        this.cleanDeletedEntityVersionsAndCheckThatThresholdWasObeyed(this::makeCommentVersionRow, this.entityVersioningControl::getAllCommentVersions, "comment");
    }

    @Test
    public void cleanDeletedWorklogVersionsShouldOnlyDeleteVersionsOlderThanThreshold() {
        this.cleanDeletedEntityVersionsAndCheckThatThresholdWasObeyed(this::makeWorklogVersionRow, this.entityVersioningControl::getAllWorklogVersions, "worklog");
    }

    private void cleanDeletedEntityVersionsAndCheckThatThresholdWasObeyed(Consumer<EntityVersion> rowMaker, Supplier<List<EntityVersioningControl.EntityVersionBean>> versionsFetcher, String entityType) {
        LocalDateTime now = this.getDbTime();
        EntityVersion threeHoursNotDeleted = new EntityVersion(42L, 999L, entityType, now.minusHours(3L), 4L, false);
        EntityVersion twoHoursYesDeleted = new EntityVersion(51L, 999L, entityType, now.minusHours(2L), 23L, true);
        EntityVersion twelveMinutesNotDeleted = new EntityVersion(89L, 999L, entityType, now.minusMinutes(12L), 9L, false);
        EntityVersion elevenMinutesYesDeleted = new EntityVersion(91L, 999L, entityType, now.minusMinutes(11L), 5L, true);
        EntityVersion zeroMinutesYesDeleted = new EntityVersion(116L, 999L, entityType, now, 11L, true);
        rowMaker.accept(threeHoursNotDeleted);
        rowMaker.accept(twoHoursYesDeleted);
        rowMaker.accept(twelveMinutesNotDeleted);
        rowMaker.accept(elevenMinutesYesDeleted);
        rowMaker.accept(zeroMinutesYesDeleted);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{threeHoursNotDeleted, twoHoursYesDeleted, twelveMinutesNotDeleted, elevenMinutesYesDeleted, zeroMinutesYesDeleted}));
        this.entityVersioningControl.cleanAllDeletedEntityVersionsOlderThan(Duration.ofHours(1L));
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{threeHoursNotDeleted, twelveMinutesNotDeleted, elevenMinutesYesDeleted, zeroMinutesYesDeleted}));
        this.entityVersioningControl.cleanAllDeletedEntityVersionsOlderThan(Duration.ofMinutes(10L));
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{threeHoursNotDeleted, twelveMinutesNotDeleted, zeroMinutesYesDeleted}));
    }

    @Test
    public void updateRelatedCommentsShouldOnlyBumpVersionsWithTargetIssueAsParent() {
        this.updateRelatedShouldOnlyBumpVersionsWithTargetIssueAsParent(this::makeCommentVersionRow, this.entityVersioningControl::incrementCommentVersionsRelatedToIssue, this.entityVersioningControl::getAllCommentVersions, "comment");
    }

    @Test
    public void updateRelatedWorklogsShouldOnlyBumpVersionsWithTargetIssueAsParent() {
        this.updateRelatedShouldOnlyBumpVersionsWithTargetIssueAsParent(this::makeWorklogVersionRow, this.entityVersioningControl::incrementWorklogVersionsRelatedToIssue, this.entityVersioningControl::getAllWorklogVersions, "worklog");
    }

    private void updateRelatedShouldOnlyBumpVersionsWithTargetIssueAsParent(Consumer<EntityVersion> rowMaker, Consumer<Long> relatedEntityUpdater, Supplier<List<EntityVersioningControl.EntityVersionBean>> versionsFetcher, String entityType) {
        LocalDateTime now = this.getDbTime();
        long otherParentIssueId = 99L;
        EntityVersion ev1 = new EntityVersion(1L, 99L, entityType, now.minusHours(1L), 1L, false);
        EntityVersion ev2 = new EntityVersion(2L, 99L, entityType, now.minusHours(2L), 2L, false);
        EntityVersion ev3 = new EntityVersion(3L, 99L, entityType, now.minusHours(3L), 3L, false);
        EntityVersion ev4 = new EntityVersion(4L, 999L, entityType, now.minusHours(4L), 4L, false);
        Lists.newArrayList((Object[])new EntityVersion[]{ev1, ev2, ev3, ev4}).forEach(rowMaker);
        relatedEntityUpdater.accept(99L);
        MatcherAssert.assertThat(versionsFetcher.get(), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{new EntityVersion(1L, 99L, entityType, now, 2L, false), new EntityVersion(2L, 99L, entityType, now, 3L, false), new EntityVersion(3L, 99L, entityType, now, 4L, false), ev4}));
    }

    private BiConsumer<Long, Long> issueVersionIncrementer() {
        return (a, b) -> this.entityVersioningControl.incrementIssueVersion((Long)a);
    }

    private void makeIssueVersionRow(EntityVersion ev) {
        this.entityVersioningControl.createNewIssueVersionRow(ev.entity, ev.dateTime, ev.version, ev.deleted);
    }

    private void makeCommentVersionRow(EntityVersion ev) {
        this.entityVersioningControl.createNewCommentVersionRow(ev.entity, ev.parentIssueId, ev.dateTime, ev.version, ev.deleted);
    }

    private void makeWorklogVersionRow(EntityVersion ev) {
        this.entityVersioningControl.createNewWorklogVersionRow(ev.entity, ev.parentIssueId, ev.dateTime, ev.version, ev.deleted);
    }

    private LocalDateTime getDbTime() {
        return new Timestamp(this.backdoor.databaseTimeControl().readDatabaseTime()).toLocalDateTime();
    }
}

