/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.indexing;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.EntityVersioningControl;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.matchers.OptionalMatchers;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.atlassian.jira.testkit.client.IssuesControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.ParsedResponse;
import com.atlassian.jira.testkit.client.restclient.Worklog;
import com.atlassian.jira.testkit.client.restclient.WorklogClient;
import com.atlassian.jira.webtests.ztests.indexing.EntityVersion;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.INDEXING})
public class TestEntityVersioningUsingRealIssue
extends BaseJiraFuncTest {
    private EntityVersioningControl entityVersioningControl;
    private IssuesControl issuesControl;
    private LocalDateTime now;
    private WorklogClient worklogClient;

    @Before
    public void setUp() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.entityVersioningControl = this.backdoor.entityVersioningControl();
        this.issuesControl = this.backdoor.issues();
        this.worklogClient = new WorklogClient((JIRAEnvironmentData)this.environmentData);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_COMMENTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_COMMENTS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_WORKLOGS);
        this.backdoor.permissionSchemes().addEveryonePermission(Long.valueOf(0L), ProjectPermissions.DELETE_ALL_WORKLOGS);
        this.backdoor.applicationProperties().setOption("jira.option.timetracking", true);
        this.now = this.getDbTime();
    }

    @Test
    public void issueAddShouldCreateVersion() {
        List<EntityVersioningControl.EntityVersionBean> issueVersionsBeforeCreate = this.entityVersioningControl.getAllIssueVersions();
        MatcherAssert.assertThat(issueVersionsBeforeCreate, (Matcher)Matchers.is((Matcher)Matchers.empty()));
        IssueCreated issue = this.createIssue();
        Optional<Long> issueVersionAfterCreate = this.entityVersioningControl.getIssueVersion(issue.id);
        Optional<Long> localIssueVersionAfterCreate = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        List<EntityVersioningControl.EntityVersionBean> issueVersionsAfterCreate = this.entityVersioningControl.getAllIssueVersions();
        MatcherAssert.assertThat(issueVersionAfterCreate, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)2L)));
        MatcherAssert.assertThat(localIssueVersionAfterCreate, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)2L)));
        MatcherAssert.assertThat(issueVersionsAfterCreate, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 2L, false)));
    }

    @Test
    public void issueEditsShouldIncreaseVersion() {
        IssueCreated issue = this.createIssue();
        this.issuesControl.setDescription(issue.key, "description");
        List<EntityVersioningControl.EntityVersionBean> issueVersionsAfterFirstEdit = this.entityVersioningControl.getAllIssueVersions();
        Optional<Long> localIssueVersionAfterFirstEdit = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        Optional<Long> localChangeHistoryVersionAfterFirstEdit = this.entityVersioningControl.getLocalChangeHistoryVersion(issue.id);
        MatcherAssert.assertThat(issueVersionsAfterFirstEdit, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 3L, false)));
        MatcherAssert.assertThat(localIssueVersionAfterFirstEdit, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)3L)));
        MatcherAssert.assertThat(localChangeHistoryVersionAfterFirstEdit, (Matcher)Matchers.is((Matcher)Matchers.equalTo(localIssueVersionAfterFirstEdit)));
        this.issuesControl.setIssueFields(issue.key, new IssueFields().labels((List)ImmutableList.of((Object)"label1")));
        List<EntityVersioningControl.EntityVersionBean> issueVersionsAfterSecondEdit = this.entityVersioningControl.getAllIssueVersions();
        Optional<Long> localIssueVersionAfterSecondEdit = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        Optional<Long> localChangeHistoryVersionAfterSecondEdit = this.entityVersioningControl.getLocalChangeHistoryVersion(issue.id);
        MatcherAssert.assertThat(issueVersionsAfterSecondEdit, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 4L, false)));
        MatcherAssert.assertThat(localIssueVersionAfterSecondEdit, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)4L)));
        MatcherAssert.assertThat(localChangeHistoryVersionAfterSecondEdit, (Matcher)Matchers.is((Matcher)Matchers.equalTo(localIssueVersionAfterSecondEdit)));
    }

    @Test
    public void issueDeleteShouldIncreaseVersion() {
        IssueCreated issue = this.createIssue();
        this.issuesControl.deleteIssue(issue.key, false);
        List<EntityVersioningControl.EntityVersionBean> issueVersionsAfterDelete = this.entityVersioningControl.getAllIssueVersions();
        Optional<Long> localIssueVersionAfterDelete = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        MatcherAssert.assertThat(issueVersionsAfterDelete, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 3L, true)));
        MatcherAssert.assertThat(localIssueVersionAfterDelete, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
    }

    @Test
    public void issueArchiveShouldIncreaseVersionAndUnarchiveIncreaseVersion() {
        IssueCreated issue = this.createIssue();
        this.issuesControl.archiveIssue(issue.key);
        List<EntityVersioningControl.EntityVersionBean> issueVersionsAfterArchive = this.entityVersioningControl.getAllIssueVersions();
        Optional<Long> localIssueVersionAfterArchive = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        MatcherAssert.assertThat(issueVersionsAfterArchive, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 3L, false)));
        MatcherAssert.assertThat(localIssueVersionAfterArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
        this.issuesControl.restoreIssue(issue.key);
        List<EntityVersioningControl.EntityVersionBean> issueVersionsAfterUnarchive = this.entityVersioningControl.getAllIssueVersions();
        Optional<Long> localIssueVersionAfterUnarchive = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        MatcherAssert.assertThat(issueVersionsAfterUnarchive, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 4L, false)));
        MatcherAssert.assertThat(localIssueVersionAfterUnarchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)4L)));
    }

    @Test
    public void testIssueArchiveAndUnarchive() {
        IssueCreated issue = this.createIssue();
        ParsedResponse commentResponse = this.issuesControl.commentIssue(issue.key, "comment 1");
        Long commentId = Long.valueOf(((Comment)commentResponse.body).id);
        Long worklogId = Long.valueOf(((Worklog)this.createWorklog((String)((IssueCreated)issue).key).body).id);
        EntityVersions entityVersionsBeforeArchive = this.getEntityVersions();
        Optional<Long> localIssueVersionBeforeArchive = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        Optional<Long> localCommentVersionBeforeArchive = this.entityVersioningControl.getLocalCommentVersion(commentId);
        Optional<Long> localWorklogVersionBeforeArchive = this.entityVersioningControl.getLocalWorklogVersion(worklogId);
        MatcherAssert.assertThat(entityVersionsBeforeArchive.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 5L, false)));
        MatcherAssert.assertThat(entityVersionsBeforeArchive.forComments, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, issue.id, "comment", this.now, 1L, false)));
        MatcherAssert.assertThat(entityVersionsBeforeArchive.forWorklogs, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, issue.id, "worklog", this.now, 1L, false)));
        MatcherAssert.assertThat(localIssueVersionBeforeArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)5L)));
        MatcherAssert.assertThat(localCommentVersionBeforeArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)1L)));
        MatcherAssert.assertThat(localWorklogVersionBeforeArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)1L)));
        this.issuesControl.archiveIssue(issue.key);
        EntityVersions entityVersionsAfterArchive = this.getEntityVersions();
        Optional<Long> localIssueVersionAfterArchive = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        Optional<Long> localCommentVersionAfterArchive = this.entityVersioningControl.getLocalCommentVersion(commentId);
        Optional<Long> localWorklogVersionAfterArchive = this.entityVersioningControl.getLocalWorklogVersion(worklogId);
        MatcherAssert.assertThat(entityVersionsAfterArchive.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 6L, false)));
        MatcherAssert.assertThat(entityVersionsAfterArchive.forComments, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, issue.id, "comment", this.now, 2L, false)));
        MatcherAssert.assertThat(entityVersionsAfterArchive.forWorklogs, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, issue.id, "worklog", this.now, 2L, false)));
        MatcherAssert.assertThat(localIssueVersionAfterArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
        MatcherAssert.assertThat(localCommentVersionAfterArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
        MatcherAssert.assertThat(localWorklogVersionAfterArchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
        this.issuesControl.restoreIssue(issue.key);
        EntityVersions entityVersionsAfterUnarchive = this.getEntityVersions();
        Optional<Long> localIssueVersionAfterUnarchive = this.entityVersioningControl.getLocalIssueVersion(issue.id);
        Optional<Long> localCommentVersionAfterUnarchive = this.entityVersioningControl.getLocalCommentVersion(commentId);
        Optional<Long> localWorklogVersionAfterUnarchive = this.entityVersioningControl.getLocalWorklogVersion(worklogId);
        MatcherAssert.assertThat(entityVersionsAfterUnarchive.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 7L, false)));
        MatcherAssert.assertThat(entityVersionsAfterUnarchive.forComments, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, issue.id, "comment", this.now, 3L, false)));
        MatcherAssert.assertThat(entityVersionsAfterUnarchive.forWorklogs, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, issue.id, "worklog", this.now, 3L, false)));
        MatcherAssert.assertThat(localIssueVersionAfterUnarchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)7L)));
        MatcherAssert.assertThat(localCommentVersionAfterUnarchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)3L)));
        MatcherAssert.assertThat(localWorklogVersionAfterUnarchive, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)3L)));
    }

    @Test
    public void commentAddShouldIncreaseIssueVersionAndCreateCommentVersion() {
        IssueCreated issue = this.createIssue();
        ParsedResponse commentResponse = this.issuesControl.commentIssue(issue.key, "comment 1");
        Long commentId = Long.valueOf(((Comment)commentResponse.body).id);
        EntityVersions entityVersionsAfterCommentAdded = this.getEntityVersions();
        MatcherAssert.assertThat(entityVersionsAfterCommentAdded.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 4L, false)));
        Optional<Long> commentVersionAfterCommentAdded = this.entityVersioningControl.getCommentVersion(commentId);
        Optional<Long> localCommentVersionAfterCommentAdded = this.entityVersioningControl.getLocalCommentVersion(commentId);
        MatcherAssert.assertThat(commentVersionAfterCommentAdded, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)1L)));
        MatcherAssert.assertThat(localCommentVersionAfterCommentAdded, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)1L)));
        MatcherAssert.assertThat(entityVersionsAfterCommentAdded.forComments, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, issue.id, "comment", this.now, 1L, false)));
    }

    @Test
    public void commentEditShouldIncreaseIssueAndCommentVersion() {
        IssueCreated issue = this.createIssue();
        Long commentId = Long.valueOf(((Comment)this.issuesControl.commentIssue((String)((IssueCreated)issue).key, (String)"comment 1").body).id);
        this.issuesControl.updateComment(issue.key, commentId.toString(), "comment 1b", null, null);
        EntityVersions entityVersionsAfterCommentEdited = this.getEntityVersions();
        Optional<Long> localCommentVersionAfterCommentEdited = this.entityVersioningControl.getLocalCommentVersion(commentId);
        MatcherAssert.assertThat(entityVersionsAfterCommentEdited.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, null, "issue", this.now, 6L, false)));
        MatcherAssert.assertThat(entityVersionsAfterCommentEdited.forComments, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, issue.id, "comment", this.now, 2L, false)));
        MatcherAssert.assertThat(localCommentVersionAfterCommentEdited, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)2L)));
    }

    @Test
    public void commentDeleteShouldIncreaseIssueAndCommentVersion() {
        IssueCreated issue = this.createIssue();
        Long commentId = Long.valueOf(((Comment)this.issuesControl.commentIssue((String)((IssueCreated)issue).key, (String)"comment 1").body).id);
        this.issuesControl.deleteComment(issue.key, commentId.toString());
        EntityVersions entityVersionsAfterCommentDeleted = this.getEntityVersions();
        Optional<Long> localCommentVersionAfterCommentDeleted = this.entityVersioningControl.getLocalCommentVersion(commentId);
        MatcherAssert.assertThat(entityVersionsAfterCommentDeleted.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, null, "issue", this.now, 5L, false)));
        MatcherAssert.assertThat(entityVersionsAfterCommentDeleted.forComments, (Matcher)Matchers.contains((Matcher)new EntityVersion(commentId, issue.id, "comment", this.now, 2L, true)));
        MatcherAssert.assertThat(localCommentVersionAfterCommentDeleted, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
    }

    @Test
    public void worklogAddShouldIncreaseIssueVersionAndCreateWorklogVersion() {
        IssueCreated issue = this.createIssue();
        Long worklogId = Long.valueOf(((Worklog)this.createWorklog((String)((IssueCreated)issue).key).body).id);
        EntityVersions entityVersionsAfterWorklogAdded = this.getEntityVersions();
        MatcherAssert.assertThat(entityVersionsAfterWorklogAdded.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(issue.id, null, "issue", this.now, 3L, false)));
        Optional<Long> worklogVersionAfterWorklogAdded = this.entityVersioningControl.getWorklogVersion(worklogId);
        Optional<Long> localWorklogVersionAfterWorklogAdded = this.entityVersioningControl.getLocalWorklogVersion(worklogId);
        MatcherAssert.assertThat(worklogVersionAfterWorklogAdded, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)1L)));
        MatcherAssert.assertThat(localWorklogVersionAfterWorklogAdded, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)1L)));
        MatcherAssert.assertThat(entityVersionsAfterWorklogAdded.forWorklogs, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, issue.id, "worklog", this.now, 1L, false)));
    }

    @Test
    public void worklogEditShouldIncreaseIssueAndWorklogVersion() {
        IssueCreated issue = this.createIssue();
        Long worklogId = Long.valueOf(((Worklog)this.createWorklog((String)((IssueCreated)issue).key).body).id);
        this.editWorklog(issue.key, worklogId);
        EntityVersions entityVersionsAfterWorklogEdited = this.getEntityVersions();
        Optional<Long> localWorklogVersionAfterWorklogEdited = this.entityVersioningControl.getLocalWorklogVersion(worklogId);
        MatcherAssert.assertThat(entityVersionsAfterWorklogEdited.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, null, "issue", this.now, 4L, false)));
        MatcherAssert.assertThat(entityVersionsAfterWorklogEdited.forWorklogs, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, issue.id, "worklog", this.now, 2L, false)));
        MatcherAssert.assertThat(localWorklogVersionAfterWorklogEdited, (Matcher)Matchers.is((Matcher)OptionalMatchers.some((Object)2L)));
    }

    @Test
    public void worklogDeleteShouldIncreaseIssueAndWorklogVersion() {
        IssueCreated issue = this.createIssue();
        Long worklogId = Long.valueOf(((Worklog)this.createWorklog((String)((IssueCreated)issue).key).body).id);
        this.deleteWorklog(issue.key, worklogId);
        EntityVersions entityVersionsAfterWorklogDeleted = this.getEntityVersions();
        Optional<Long> localWorklogVersionAfterWorklogDeleted = this.entityVersioningControl.getLocalWorklogVersion(worklogId);
        MatcherAssert.assertThat(entityVersionsAfterWorklogDeleted.forIssues, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, null, "issue", this.now, 4L, false)));
        MatcherAssert.assertThat(entityVersionsAfterWorklogDeleted.forWorklogs, (Matcher)Matchers.contains((Matcher)new EntityVersion(worklogId, issue.id, "worklog", this.now, 2L, true)));
        MatcherAssert.assertThat(localWorklogVersionAfterWorklogDeleted, (Matcher)Matchers.is((Matcher)OptionalMatchers.none()));
    }

    private ParsedResponse<Worklog> createWorklog(String issueKey) {
        Worklog worklog = new Worklog();
        worklog.timeSpent = "1h";
        return this.worklogClient.post(issueKey, worklog);
    }

    private ParsedResponse<Worklog> editWorklog(String issueKey, Long worklogId) {
        Worklog worklog = new Worklog();
        worklog.id = worklogId.toString();
        worklog.comment = "Updated at " + new Date();
        return this.worklogClient.put(issueKey, worklog);
    }

    private ParsedResponse<Worklog> deleteWorklog(String issueKey, Long worklogId) {
        Worklog worklog = new Worklog();
        worklog.id = worklogId.toString();
        return this.worklogClient.delete(issueKey, worklog);
    }

    private LocalDateTime getDbTime() {
        return new Timestamp(this.backdoor.databaseTimeControl().readDatabaseTime()).toLocalDateTime();
    }

    private EntityVersions getEntityVersions() {
        return new EntityVersions(this.entityVersioningControl.getAllIssueVersions(), this.entityVersioningControl.getAllCommentVersions(), this.entityVersioningControl.getAllWorklogVersions());
    }

    private IssueCreated createIssue() {
        IssueCreateResponse issueCreateResponse = this.issuesControl.createIssue("HSP", "issue 1");
        return new IssueCreated(Long.valueOf(issueCreateResponse.id()), issueCreateResponse.key());
    }

    private static class IssueCreated {
        private final Long id;
        private final String key;

        public IssueCreated(Long id, String key) {
            this.id = id;
            this.key = key;
        }
    }

    private static class EntityVersions {
        final List<EntityVersioningControl.EntityVersionBean> forIssues;
        final List<EntityVersioningControl.EntityVersionBean> forComments;
        final List<EntityVersioningControl.EntityVersionBean> forWorklogs;

        private EntityVersions(List<EntityVersioningControl.EntityVersionBean> forIssues, List<EntityVersioningControl.EntityVersionBean> forComments, List<EntityVersioningControl.EntityVersionBean> forWorklogs) {
            this.forIssues = forIssues;
            this.forComments = forComments;
            this.forWorklogs = forWorklogs;
        }
    }
}

