/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.initialwatchers;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.testkit.client.model.FeatureFlag;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestInitialWatchersSetup
extends BaseJiraFuncTest {
    @Inject
    public Administration administration;
    private Gson gson;
    public static final String INITIAL_WATCHERS_FIELD = "customfield_10000";
    public static final String GET_CREATE_URI = "/secure/QuickCreateIssue!default.jspa?pid=%d&issuetype=%d&decorator=none";
    public static final FeatureFlag FEATURE_FLAG = FeatureFlag.featureFlag((String)"com.atlassian.jira.initialwatchers");

    @Before
    public void setUpTest() {
        this.gson = new Gson();
        this.backdoor.restoreBlankInstance();
    }

    @Test
    public void initialWatchersFieldShouldNotBePresentOnStartup() throws IOException {
        try (CloseableHttpClient client = this.createClientForUser("admin");){
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.getEnvironmentData().getBaseUrl() + this.getQuickCreateUri(10000L, 1L)));
            FieldsResponse fields = (FieldsResponse)this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), FieldsResponse.class);
            Assert.assertTrue((boolean)fields.fields.stream().noneMatch(f -> f.getId().equals(INITIAL_WATCHERS_FIELD)));
        }
    }

    @Test
    public void initialWatchersFieldCanBeAddedViaFlagEnabling() throws IOException {
        try (CloseableHttpClient client = this.createClientForUser("admin");){
            this.administration.backdoor().darkFeatures().enableForSite(FEATURE_FLAG);
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.getEnvironmentData().getBaseUrl() + this.getQuickCreateUri(10000L, 1L)));
            FieldsResponse fields = (FieldsResponse)this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), FieldsResponse.class);
            Assert.assertTrue((boolean)fields.fields.stream().anyMatch(f -> f.getId().equals(INITIAL_WATCHERS_FIELD)));
        }
    }

    @Test
    public void initialWatchersFieldCanBeRemovedViaFlagDisabling() throws IOException {
        try (CloseableHttpClient client = this.createClientForUser("admin");){
            this.administration.backdoor().darkFeatures().disableForSite(FEATURE_FLAG);
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.getEnvironmentData().getBaseUrl() + this.getQuickCreateUri(10000L, 1L)));
            FieldsResponse fields = (FieldsResponse)this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), FieldsResponse.class);
            Assert.assertTrue((boolean)fields.fields.stream().noneMatch(f -> f.getId().equals(INITIAL_WATCHERS_FIELD)));
        }
    }

    @Test
    public void initialWatchersFieldCanBeAddedViaProjectCreationWhenFlagEnabled() throws IOException {
        try (CloseableHttpClient client = this.createClientForUser("admin");){
            this.administration.backdoor().darkFeatures().enableForSite(FEATURE_FLAG);
            long projectId = this.administration.project().addProject("Testing", "TT", "admin");
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.getEnvironmentData().getBaseUrl() + this.getQuickCreateUri(projectId, 1L)));
            FieldsResponse fields = (FieldsResponse)this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), FieldsResponse.class);
            Assert.assertTrue((boolean)fields.fields.stream().anyMatch(f -> f.getId().equals(INITIAL_WATCHERS_FIELD)));
        }
    }

    @Test
    public void initialWatchersFieldCannotBeAddedViaProjectCreationWhenFlagDisabled() throws IOException {
        try (CloseableHttpClient client = this.createClientForUser("admin");){
            this.administration.backdoor().darkFeatures().disableForSite(FEATURE_FLAG);
            long projectId = this.administration.project().addProject("Testing", "TT", "admin");
            CloseableHttpResponse response = client.execute((HttpUriRequest)new HttpGet(this.getEnvironmentData().getBaseUrl() + this.getQuickCreateUri(projectId, 1L)));
            FieldsResponse fields = (FieldsResponse)this.gson.fromJson(IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), FieldsResponse.class);
            Assert.assertTrue((boolean)fields.fields.stream().noneMatch(f -> f.getId().equals(INITIAL_WATCHERS_FIELD)));
        }
    }

    private CloseableHttpClient createClientForUser(@Nullable String user) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        if (user != null) {
            HttpPost method = new HttpPost(this.getEnvironmentData().getBaseUrl() + "/login.jsp");
            ArrayList<BasicNameValuePair> formparams = new ArrayList<BasicNameValuePair>();
            formparams.add(new BasicNameValuePair("os_username", user));
            formparams.add(new BasicNameValuePair("os_password", user));
            formparams.add(new BasicNameValuePair("os_cookie", String.valueOf(true)));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(formparams, "UTF-8");
            method.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)method);
            Assert.assertEquals((Object)"OK", (Object)response.getHeaders("X-Seraph-LoginReason")[0].getValue());
            IOUtils.closeQuietly((InputStream)response.getEntity().getContent());
        }
        return client;
    }

    private String getQuickCreateUri(long pid, long issueTypeId) {
        return String.format(GET_CREATE_URI, pid, issueTypeId);
    }

    private static class FieldsResponse {
        public List<FieldHtmlBean> fields = new ArrayList<FieldHtmlBean>();

        private FieldsResponse() {
        }
    }
}

