/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.testkit.client.log.FuncTestOut;
import java.io.IOException;
import org.junit.Assert;

public abstract class AbstractCloneIssueTest
extends BaseJiraFuncTest {
    protected void gotoIssueAndClickClone(String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("clone-issue");
    }

    protected String cloneIssue(String projectKey, String summary, boolean cloneLinkPresent) {
        summary = "CLONE - " + summary;
        this.tester.assertFormElementEquals("summary", summary);
        if (cloneLinkPresent) {
            this.tester.assertTextNotPresent("The clone link type \"Cloners\" does not exist. A link to the original issue will not be created.");
        } else {
            this.tester.assertTextPresent("The clone link type \"Cloners\" does not exist. A link to the original issue will not be created.");
        }
        this.tester.submit();
        this.waitForProgress();
        Assert.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().getPath().contains("/browse"));
        this.tester.assertTextPresent(summary);
        try {
            return this.extractIssueKey(projectKey);
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to retrieve issue key" + e.getMessage()));
            return "fail";
        }
    }

    protected void waitForProgress() {
        int maxWaitTimeMs = 120000;
        int snoozeMs = 100;
        int timeWaitedMs = 0;
        while (this.tester.getDialog().hasSubmitButton("Refresh")) {
            if (timeWaitedMs > 120000) {
                throw new RuntimeException("Waiting timed out.");
            }
            try {
                Thread.sleep(100L);
                timeWaitedMs += 100;
                this.tester.submit("Refresh");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String extractIssueKey(String projectKey) throws IOException {
        int endOfIssueKey;
        int projectIdLocation;
        String text = this.tester.getDialog().getResponse().getText();
        String issueKey = text.substring(projectIdLocation = text.indexOf("[" + projectKey) + 1, endOfIssueKey = text.indexOf("]", projectIdLocation));
        if (!issueKey.matches(projectKey + "-\\d+")) {
            Assert.fail((String)("Invalid issue key: " + issueKey));
        }
        FuncTestOut.log((Object)("issueKey = " + issueKey));
        return issueKey;
    }
}

