/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.backdoor.PermissionControlExt;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.internal.v2.archiving.bean.ArchivedIssuesBean;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestBrowseArchivedIssue
extends BaseJiraFuncTest {
    private PermissionControlExt permissionsControl;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance();
        this.backdoor.usersAndGroups().addGroup("admin-group");
        this.backdoor.permissions().addGlobalPermission(0, "admin-group");
        this.backdoor.usersAndGroups().addUser("ordinary_admin");
        this.backdoor.usersAndGroups().addUserToGroup("ordinary_admin", "admin-group");
        this.permissionsControl = new PermissionControlExt(this.environmentData);
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=960000)
    public void testBrowseArchivedIssue() {
        String archivedIssueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Test").key;
        this.backdoor.issues().archiveIssue(archivedIssueKey);
        String archivedProjectIssueKey = this.backdoor.issues().createIssue((String)"MKY", (String)"Test2").key;
        this.backdoor.project().archiveProject("MKY");
        ArchivedIssuesBean archivedIssues = this.backdoor.archive().list(new String[0]);
        List keys = archivedIssues.getArchivedIssues().stream().map(IssueBean::getKey).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)archivedIssues.getArchivedIssues().size(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)archivedIssues.getTotal(), (Matcher)CoreMatchers.equalTo((Object)2));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{archivedIssueKey, archivedProjectIssueKey}));
    }

    @Test
    public void testFilters_project() {
        String archivedIssueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Test").key;
        this.backdoor.issues().archiveIssue(archivedIssueKey);
        String archivedProjectIssueKey = this.backdoor.issues().createIssue((String)"MKY", (String)"Test2").key;
        this.backdoor.project().archiveProject("MKY");
        ArchivedIssuesBean archivedIssues = this.backdoor.archive().list("projectKey", "MKY");
        List keys = archivedIssues.getArchivedIssues().stream().map(IssueBean::getKey).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)archivedIssues.getArchivedIssues().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)archivedIssues.getTotal(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat(keys, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{archivedProjectIssueKey}));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testFilters_filterCount() {
        for (int i = 0; i < 100; ++i) {
            String archivedIssueKey = this.backdoor.issues().createIssue((String)"HSP", (String)"Test").key;
            this.backdoor.issues().archiveIssue(archivedIssueKey);
        }
        ArchivedIssuesBean archivedIssues = this.backdoor.archive().list("projectKey", "HSP", "maxResults", "10");
        MatcherAssert.assertThat((Object)archivedIssues.getArchivedIssues().size(), (Matcher)CoreMatchers.equalTo((Object)10));
        MatcherAssert.assertThat((Object)archivedIssues.getTotal(), (Matcher)CoreMatchers.equalTo((Object)100));
    }

    @Test
    public void testIfSysAdminCanBrowseArchivedIssues() {
        this.navigation.login("admin");
        String archivedIssues = this.getArchivedItems();
        MatcherAssert.assertThat((Object)archivedIssues, (Matcher)CoreMatchers.equalTo((Object)"{\"archivedIssues\":[],\"total\":0}"));
    }

    @Test
    public void testIfAdminCannotBrowseArchivedIssues() {
        this.navigation.login("ordinary_admin");
        try {
            this.getArchivedItems();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Server returned HTTP response code: 403 for URL:"));
        }
    }

    @Test
    public void testIfFredCanBrowseWhenGlobalPermissionGranted() {
        this.navigation.login("ordinary_admin");
        this.permissionsControl.addGlobalPermissionByKey("GLOBAL_BROWSE_ARCHIVE", "admin-group");
        String archivedIssues = this.getArchivedItems();
        MatcherAssert.assertThat((Object)archivedIssues, (Matcher)CoreMatchers.equalTo((Object)"{\"archivedIssues\":[],\"total\":0}"));
    }

    @Test
    public void testIfFredCanBrowseWhenProjectPermissionGranted() {
        this.navigation.login("ordinary_admin");
        this.backdoor.permissionSchemes().addUserPermission(0L, ProjectPermissions.BROWSE_ARCHIVE, "ordinary_admin");
        String archivedIssues = this.getArchivedItems();
        MatcherAssert.assertThat((Object)archivedIssues, (Matcher)CoreMatchers.equalTo((Object)"{\"archivedIssues\":[],\"total\":0}"));
    }

    @Test
    @SinceBuildRule.SinceBuild(buildNumber=804000)
    public void testSearchResultsAreLimited() throws JSONException {
        this.prepareProjects();
        this.verifyTotal("ordinary_admin", 2, "projectKey=HBA&projectKey=HBC");
        this.verifyTotal("admin", 3, "projectKey=HBA&projectKey=HBC&projectKey=HBB");
        this.backdoor.project().archiveProject("HBA");
        this.verifyTotal("ordinary_admin", 2, "projectKey=HBA&projectKey=HBC");
        this.verifyTotal("admin", 3, "projectKey=HBA&projectKey=HBC&projectKey=HBB");
        this.permissionsControl.addGlobalPermissionByKey("GLOBAL_BROWSE_ARCHIVE", "admin-group");
        this.verifyTotal("ordinary_admin", 3, "projectKey=HBA&projectKey=HBC&projectKey=HBB");
        this.verifyTotal("admin", 3, "projectKey=HBA&projectKey=HBC&projectKey=HBB");
    }

    @Test
    public void testPermissionCheck() throws JSONException {
        this.prepareProjects();
        try {
            this.verifyTotal("ordinary_admin", -1, "projectKey=HBA&projectKey=HBB");
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("HTTP Status 400"));
            Assert.assertTrue((boolean)ex.getMessage().contains("Bad Request"));
        }
    }

    private void prepareProjects() {
        Long schemeID = this.backdoor.permissionSchemes().createScheme("Browsable scheme", "Scheme where you can browse archived issues");
        this.backdoor.permissionSchemes().addUserPermission(schemeID.longValue(), ProjectPermissions.BROWSE_ARCHIVE, "ordinary_admin");
        long idHba = this.backdoor.project().addProject("HBA", "HBA", "ordinary_admin");
        long idHbb = this.backdoor.project().addProject("HBB", "HBB", "ordinary_admin");
        long idHbc = this.backdoor.project().addProject("HBC", "HBC", "ordinary_admin");
        this.backdoor.issues().archiveIssue(this.backdoor.issues().createIssue((String)"HBA", (String)"Archived in HBA", (String)"admin").key);
        this.backdoor.issues().archiveIssue(this.backdoor.issues().createIssue((String)"HBB", (String)"Archived in HBB", (String)"admin").key);
        this.backdoor.issues().archiveIssue(this.backdoor.issues().createIssue((String)"HBC", (String)"Archived in HBC", (String)"admin").key);
        this.backdoor.project().setPermissionScheme(idHba, schemeID);
        this.backdoor.project().setPermissionScheme(idHbc, schemeID);
    }

    private void verifyTotal(String user, int expectedTotal, String queryString) throws JSONException {
        this.navigation.login(user);
        JSONObject archivedIssues = new JSONObject(this.getArchivedItems(queryString));
        MatcherAssert.assertThat((Object)archivedIssues.getInt("total"), (Matcher)CoreMatchers.equalTo((Object)expectedTotal));
    }

    @Test
    public void testAnonymousEnter() {
        this.navigation.logout();
        String archivedItems = this.getArchivedItems();
        Assert.assertTrue((boolean)archivedItems.contains("<status-code>401</status-code>"));
    }

    private String getArchivedItems() {
        return this.getArchivedItems("");
    }

    private String getArchivedItems(String queryString) {
        this.tester.gotoPage("/rest/internal/2/archiving/browse?" + queryString);
        return this.tester.getDialog().getResponseText();
    }
}

