/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.Indexing;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.issue.AbstractCloneIssueTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.CLONE_ISSUE, Category.ISSUES, Category.SUB_TASKS})
@LoginAs(user="admin")
public class TestCloneIssueWithSubTasks
extends AbstractCloneIssueTest {
    protected static final String CLONE_LINKS_CHECKBOX_LABEL = "Clone links";
    protected static final String CLONE_SUBTASKS_CHECKBOX_LABEL = "Clone sub-tasks";
    protected static final String CLONE_SUMMARY_PREFIX = "CLONE - ";
    protected static final String SUMMARY_FIELD_NAME = "summary";
    protected static final String SUBTASKS_TEXT = "Sub-Tasks";
    protected static final String LINKS_TEXT = "Issue Links";
    protected static final String CLONE_LINKS_CHECKBOX_NAME = "cloneLinks";
    private static final String CLONE_SUBTASKS_CHECKBOX_NAME = "cloneSubTasks";
    @Inject
    private Indexing indexing;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Before
    public void setUp() {
        this.administration.restoreData("TestCloneIssueWithSubTasks.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testCloneNoLinks() {
        this.gotoIssueAndClickClone("HSP-1");
        this.tester.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextNotPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        String cloneKey = this.cloneIssue("HSP", "Test Issue", false);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Type", "Task");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Open", new String[0]);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Priority", "Minor");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Assignee", "Administrator");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Reporter", "Administrator");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Vote", "0");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Watch", "0");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Component/s", "New Component 1", "New Component 2"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Affects Version/s", "New Version 1", "New Version 4"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Fix Version/s", "New Version 4", "New Version 5"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Original Estimate", "4 days", "Remaining Estimate", "4 days", "Time Spent", "Not Specified"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Environment", "Test Environment"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Description", "Test Description");
        this.tester.assertTextNotPresent(SUBTASKS_TEXT);
        this.tester.assertTextNotPresent(LINKS_TEXT);
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)"type", (Object)"Task", (Object)"status", (Object)"Open", (Object)"priority", (Object)"Minor", (Object)"votes", (Object)"0", (Object)"description", (Object)"Test Description"), null, cloneKey);
    }

    @Test
    public void testClonePermission() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertLinkPresent("clone-issue");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ISSUES, "jira-users");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.assertLinkNotPresent("clone-issue");
    }

    @Test
    public void testCloneWithLinks() {
        this.gotoIssueAndClickClone("HSP-2");
        this.tester.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextNotPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.tester.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        String clonedKey = this.cloneIssue("HSP", "Test Issue with link", false);
        this.tester.assertTextNotPresent(SUBTASKS_TEXT);
        this.tester.assertTextPresent(LINKS_TEXT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"out", "HSP-3"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"in", "HSP-4"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"outward", "HSP-5"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"inward", "HSP-6"});
        this.indexing.assertIndexedFieldCorrect("//item", EasyMap.build((Object)SUMMARY_FIELD_NAME, (Object)"CLONE - Test Issue with link", (Object)"resolution", (Object)"Unresolved"), null, clonedKey);
        this.indexing.assertIndexedFieldCorrect("//item/issuelinks/issuelinktype", EasyMap.build((Object)"name", (Object)"Test Link 1"), null, clonedKey);
    }

    @Test
    public void testCloneIssueLinksDisabled() {
        this.administration.issueLinking().disable();
        this.gotoIssueAndClickClone("HSP-2");
        this.tester.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.cloneIssue("HSP", "Test Issue with link", false);
        this.tester.assertTextNotPresent(LINKS_TEXT);
    }

    @Test
    public void testCloneWithClonersLink() {
        this.createClonersLinkType();
        String originalIssueKey = "HSP-1";
        this.gotoIssueAndClickClone(originalIssueKey);
        this.tester.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextNotPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        String cloneIssueKey = this.cloneIssue("HSP", "Test Issue", true);
        this.tester.assertTextNotPresent(SUBTASKS_TEXT);
        this.tester.assertTextPresent(LINKS_TEXT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"clones", originalIssueKey});
        this.navigation.issue().gotoIssue(originalIssueKey);
        this.tester.assertTextPresent(LINKS_TEXT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"is cloned by", cloneIssueKey});
    }

    @Test
    public void testCloneNoLinksWithSubTask() {
        this.gotoIssueAndClickClone("HSP-7");
        this.tester.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.tester.assertFormElementEquals(CLONE_SUBTASKS_CHECKBOX_NAME, "true");
        this.cloneIssue("HSP", "Test Issue with sub task", false);
        this.tester.assertTextNotPresent(LINKS_TEXT);
        this.tester.assertTextPresent(SUBTASKS_TEXT);
        this.tester.assertTextPresent("Test Sub task");
        this.tester.assertTextPresent("Another Sub Task");
    }

    @Test
    public void testCloneWithLinksAndSubTasks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.tester.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.tester.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.tester.assertTextPresent(LINKS_TEXT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"out", "HSP-3"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"inward", "HSP-6"});
        this.tester.assertTextPresent(SUBTASKS_TEXT);
        this.tester.assertTextPresent("Another test subtask");
        this.tester.assertTextPresent("Second sub-task");
    }

    @Test
    public void testCloneIssueWithLinksAndSubTasksNoLinks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.tester.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.tester.assertTextNotPresent(LINKS_TEXT);
        this.tester.assertTextPresent(SUBTASKS_TEXT);
        this.tester.assertTextPresent("Another test subtask");
        this.tester.assertTextPresent("Second sub-task");
    }

    @Test
    public void testCloneIssueWithLinksAndSubTasksNoSubTasks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.tester.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.tester.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECKBOX_NAME);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.tester.assertTextPresent(LINKS_TEXT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"out", "HSP-3"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"inward", "HSP-6"});
        this.tester.assertTextNotPresent(SUBTASKS_TEXT);
    }

    @Test
    public void testCloneIssueWithLinksAndSubTasksNoSubTasksNoLinks() {
        this.gotoIssueAndClickClone("HSP-10");
        this.tester.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.tester.uncheckCheckbox(CLONE_SUBTASKS_CHECKBOX_NAME);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.tester.assertTextNotPresent(LINKS_TEXT);
        this.tester.assertTextNotPresent(SUBTASKS_TEXT);
    }

    @Test
    public void testCloneIssueWithSubTaskWithLink() {
        this.gotoIssueAndClickClone("HSP-13");
        this.tester.assertTextPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.tester.checkCheckbox(CLONE_LINKS_CHECKBOX_NAME, "true");
        this.cloneIssue("HSP", "Test issue with subtask which has a link", false);
        this.tester.assertTextNotPresent(LINKS_TEXT);
        this.tester.assertTextPresent(SUBTASKS_TEXT);
        String subTaskWithLinkSummary = "Sub task with link";
        this.tester.assertTextPresent(subTaskWithLinkSummary);
        this.tester.assertTextPresent("One more subtask");
        this.tester.clickLinkWithText(subTaskWithLinkSummary);
        this.tester.assertTextPresent(LINKS_TEXT);
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"in", "HSP-4"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"outward", "HSP-5"});
    }

    @Test
    public void testCloneIssueLinksDisabledWithSubTasks() {
        this.administration.issueLinking().disable();
        this.gotoIssueAndClickClone("HSP-10");
        this.tester.assertTextNotPresent(CLONE_LINKS_CHECKBOX_LABEL);
        this.tester.assertTextPresent(CLONE_SUBTASKS_CHECKBOX_LABEL);
        this.cloneIssue("HSP", "Issue with link and sub-task", false);
        this.tester.assertTextNotPresent(LINKS_TEXT);
        this.tester.assertTextPresent(SUBTASKS_TEXT);
        this.tester.assertTextPresent("Another test subtask");
        this.tester.assertTextPresent("Second sub-task");
    }

    @Test
    public void testCloneResolvedIssueClearsResolutionDate() {
        this.navigation.issue().gotoIssue("HSP-1");
        this.workflowUtil.clickAction("action_id_5");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.setFormElement("comment", "This issue is now done!");
        this.tester.submit("Transition");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Test Issue", "Due", "Created", "Updated", "Resolved"});
        this.tester.clickLink("clone-issue");
        this.tester.setFormElement(SUMMARY_FIELD_NAME, "CLONE - Test Issue");
        this.tester.submit("Create");
        this.tester.assertTextPresent("HSP-17");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"CLONE - Test Issue", "Due", "Created", "Updated"});
        Assert.assertThat((Object)this.tester.getDialog().getElement("opsbar-transitions_more").getTextContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Resolved")));
    }

    private void createClonersLinkType() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.LINKING);
        this.textAssertions.assertTextPresent("Issue Linking");
        this.textAssertions.assertTextPresent("ON");
        this.tester.setFormElement("name", "Cloners");
        this.tester.setFormElement("outward", "clones");
        this.tester.setFormElement("inward", "is cloned by");
        this.tester.submit("Add");
    }
}

