/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.INDEXING})
@LoginAs(user="admin")
public class TestEditIssueOnIndexing
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    @Test
    public void testUpdatedTimeInDBInSyncWithIndex() throws Exception {
        this.backdoor.issues().createIssue("MKY", "Test issue");
        this.waitForSecondSinceUpdatedFieldIsStoredInIndexWithPerSecondResolution();
        this.backdoor.issues().setDescription("MKY-1", "Test description!");
        Assert.assertThat((Object)this.backdoor.indexing().isIndexUpdatedFieldConsistent(), (Matcher)Matchers.equalTo((Object)true));
        this.waitForSecondSinceUpdatedFieldIsStoredInIndexWithPerSecondResolution();
        this.backdoor.issues().setDescription("MKY-1", "Test description!");
        Assert.assertThat((Object)this.backdoor.indexing().isIndexUpdatedFieldConsistent(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void waitForSecondSinceUpdatedFieldIsStoredInIndexWithPerSecondResolution() throws InterruptedException {
        Thread.sleep(1100L);
    }
}

