/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.Assertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.EntityPropertyControl;
import com.atlassian.jira.testkit.client.IssueTypeControl;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.client.UserPropertyClient;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ENTITY_PROPERTIES, Category.REFERENCE_PLUGIN})
@RestoreBlankInstance
public class TestEntityPropertyEqualToCondition
extends BaseJiraFuncTest {
    public static final String CONDITIONAL_WEBPANEL_ID_PREFIX = "conditional-webpanel-";
    @Inject
    private Assertions assertions;
    private EntityPropertyControl entityPropertyControl;
    private IssueCreateResponse issue;

    @Before
    public void setUp() throws Exception {
        this.backdoor.restoreBlankInstance();
        this.navigation.login("admin");
        this.entityPropertyControl = this.backdoor.getTestkit().getEntityPropertyControl();
        this.issue = this.backdoor.issues().createIssue("HSP", "sum");
    }

    @Test
    public void testPanelInIssueViewIsDisplayedWhenIssuePropertyConditionEvalTrue() {
        this.testWebPanelInIssueViewRespectsIssueProperty("0", this.assertions::assertNodeByIdExists);
    }

    @Test
    public void testPanelInIssueViewIsNotDisplayedWhenIssuePropertyConditionEvalFalse() {
        this.testWebPanelInIssueViewRespectsIssueProperty("1", this.assertions::assertNodeByIdDoesNotExist);
    }

    @Test
    public void testPanelInIssueViewIsDisplayedWhenNestedIssuePropertyConditionEvalTrue() throws IOException {
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ObjectNode one = root.putObject("one");
        one.put("unimportant", "data");
        ObjectNode two = one.putObject("two");
        two.put("three", true);
        this.testWebPanelInIssueViewRespectsNestedIssueProperty((JsonNode)root, this.assertions::assertNodeByIdExists);
    }

    @Test
    public void testPanelInIssueViewIsNotDisplayedWhenNestedIssuePropertyConditionEvalFalse() throws IOException {
        ObjectNode root = JsonNodeFactory.instance.objectNode();
        ObjectNode one = root.putObject("one");
        one.put("unimportant", "test data");
        ObjectNode two = one.putObject("two");
        two.put("three", false);
        this.testWebPanelInIssueViewRespectsNestedIssueProperty((JsonNode)root, this.assertions::assertNodeByIdDoesNotExist);
    }

    @Test
    public void testPanelInIssueViewIsDisplayedWhenIssueTypePropertyConditionEvalTrue() {
        this.testWebPanelInIssueViewRespectsIssueTypeProperty("true", this.assertions::assertNodeByIdExists);
    }

    @Test
    public void testPanelInIssueViewIsNotDisplayedWhenIssueTypePropertyConditionEvalFalse() {
        this.testWebPanelInIssueViewRespectsIssueTypeProperty("false", this.assertions::assertNodeByIdDoesNotExist);
    }

    @Test
    public void testPanelInIsueViewIsDisplayedWhenProjectPropertyConditionEvalTrue() {
        this.testWebPanelInIssueViewRespectsProjectProperty("\"big-product-type\"", this.assertions::assertNodeByIdExists);
    }

    @Test
    public void testPanelInIssueViewIsNotDisplayedWhenProjetPropertyConditionEvalFalse() {
        this.testWebPanelInIssueViewRespectsProjectProperty("\"big-product-type-2\"", this.assertions::assertNodeByIdDoesNotExist);
    }

    @Test
    public void testPanelInIssueViewIsDisplayedWhenUserPropertyConditionEvalTrue() throws JSONException {
        this.testWebPanelInIssueViewRespectsUserProperty("\"admin\"", this.assertions::assertNodeByIdExists);
    }

    @Test
    public void testPanelInIssueViewIsNotDisplayedWhenUserPropertyConditionEvalFalse() throws JSONException {
        this.testWebPanelInIssueViewRespectsUserProperty("\"notAdmin\"", this.assertions::assertNodeByIdDoesNotExist);
    }

    @Test
    public void testWebItemInProjectViewIsNotDisplayedWhenUserPropertyConditionEvalFalse() throws JSONException {
        this.testWebItemInProjectViewRespectsUserProperty("\"notAdmin\"", this.assertions::assertNodeDoesNotExist);
    }

    private void testWebItemInProjectViewRespectsUserProperty(String propertyValue, Consumer<Locator> assertion) throws JSONException {
        UserPropertyClient userPropertyClient = new UserPropertyClient(this.environmentData);
        userPropertyClient.put("admin", "type", propertyValue);
        this.navigation.browseProject("HSP");
        assertion.accept(new CssLocator(this.tester, "a[data-link-id=\"com.atlassian.jira.dev.reference-plugin:referenceUserConditionProjectSidebarWebItem\"]"));
    }

    private void testWebPanelInIssueViewRespectsUserProperty(String propertyValue, Consumer<String> assertion) throws JSONException {
        UserPropertyClient userPropertyClient = new UserPropertyClient(this.environmentData);
        userPropertyClient.put("admin", "type", propertyValue);
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "Some summary");
        this.navigation.issue().viewIssue(issue.key);
        assertion.accept("conditional-webpanel-user");
    }

    private void testWebPanelInIssueViewRespectsProjectProperty(String propertyValue, Consumer<String> assertion) {
        String projectId = String.valueOf(this.backdoor.project().addProject("Project with property", "PWP", "admin"));
        this.entityPropertyControl.putProperty(EntityPropertyType.PROJECT_PROPERTY, projectId, "type", propertyValue);
        Assert.assertEquals((Object)propertyValue, (Object)this.entityPropertyControl.getProperty(EntityPropertyType.PROJECT_PROPERTY, projectId, "type"));
        IssueCreateResponse issue = this.backdoor.issues().createIssue("PWP", "Issue in project with properties");
        this.navigation.issue().viewIssue(issue.key);
        assertion.accept("conditional-webpanel-project");
    }

    private void testWebPanelInIssueViewRespectsIssueTypeProperty(String propertyValue, Consumer<String> assertion) {
        IssueTypeControl.IssueType issueType = this.backdoor.issueType().createIssueType("new-issue-type-with-properties");
        this.entityPropertyControl.putProperty(EntityPropertyType.ISSUE_TYPE_PROPERTY, issueType.getId(), "com.some.addon.vendor", propertyValue);
        Assert.assertEquals((Object)propertyValue, (Object)this.entityPropertyControl.getProperty(EntityPropertyType.ISSUE_TYPE_PROPERTY, issueType.getId(), "com.some.addon.vendor"));
        IssueCreateResponse issue = this.backdoor.issues().createIssue("HSP", "summary", null, "1", issueType.getId());
        this.navigation.issue().viewIssue(issue.key);
        assertion.accept("conditional-webpanel-issueType");
    }

    private void testWebPanelInIssueViewRespectsIssueProperty(String propertyValue, Consumer<String> assertion) {
        this.entityPropertyControl.putProperty(EntityPropertyType.ISSUE_PROPERTY, this.issue.id, "likes", propertyValue);
        String property = this.entityPropertyControl.getProperty(EntityPropertyType.ISSUE_PROPERTY, this.issue.id, "likes");
        Assert.assertEquals((Object)property, (Object)propertyValue);
        this.navigation.issue().viewIssue(this.issue.key);
        assertion.accept("conditional-webpanel-issue");
    }

    private void testWebPanelInIssueViewRespectsNestedIssueProperty(JsonNode providedPropertyValue, Consumer<String> assertion) throws IOException {
        String propertyKey = "nested-values";
        this.entityPropertyControl.putProperty(EntityPropertyType.ISSUE_PROPERTY, this.issue.id, "nested-values", providedPropertyValue.toString());
        ObjectMapper objectMapper = new ObjectMapper();
        String readProperty = this.entityPropertyControl.getProperty(EntityPropertyType.ISSUE_PROPERTY, this.issue.id, "nested-values");
        JsonNode readJsonProperty = objectMapper.readTree(readProperty);
        Assert.assertEquals((Object)readJsonProperty, (Object)providedPropertyValue);
        this.navigation.issue().viewIssue(this.issue.key);
        assertion.accept("conditional-webpanel-issue");
    }
}

