/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.util.issue.IssueInlineEdit;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestInlineEditIssueFieldsExceedingLimit
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestInlineEditIssueFieldsExceedingLimit.xml");
        this.navigation.login("admin", "admin");
    }

    @Test
    public void testInlineEditTextArea() throws Exception {
        this.testInlineEditField("customfield_10000", "customfield_10000-val");
    }

    @Test
    public void testInlineEditTextField() throws Exception {
        this.testInlineEditField("customfield_10001", "customfield_10001-val");
    }

    @Test
    public void testInlineEditUrlField() throws Exception {
        this.testInlineEditField("customfield_10002", "environment-val");
    }

    @Test
    public void testInlineEditEnvironment() throws Exception {
        this.testInlineEditField("environment", "environment-val");
    }

    @Test
    public void testInlineEditDescription() throws Exception {
        this.testInlineEditField("description", "description-val");
    }

    @Test
    public void testInlineEditSummary() throws Exception {
        this.testInlineEditField("summary", "summary-val", false);
    }

    private void testInlineEditField(String fieldName, String fieldId) throws Exception {
        this.testInlineEditField(fieldName, fieldId, true);
    }

    private void testInlineEditField(String fieldName, String fieldId, boolean shouldFail) throws Exception {
        this.navigation.issue().gotoIssue("HSP-2");
        String oldValue = this.locator.id(fieldId).getText();
        String newValue = oldValue + "s";
        this.backdoor.advancedSettings().setTextFieldCharacterLengthLimit((long)oldValue.length());
        IssueInlineEdit inlineEdit = new IssueInlineEdit(this.locator, this.tester, this.environmentData);
        inlineEdit.inlineEditField("10100", fieldName, newValue);
        this.navigation.issue().gotoIssue("HSP-2");
        if (shouldFail) {
            this.assertions.assertNodeByIdEquals(fieldId, oldValue);
        } else {
            this.assertions.assertNodeByIdEquals(fieldId, newValue);
        }
    }
}

