/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueBrowseBadProjectRegex
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private ViewIssueAssertions viewIssueAssertions;

    @Test
    public void testViewIssuePageWithInvalidAssigneeAndReporters() {
        this.administration.restoreData("TestIssueBrowseBadProjectRegex.xml");
        this.tester.gotoPage("/browse/M02-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Monkey bug 1");
        this.tester.gotoPage("/browse/H01-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "adgvadgvad");
        this.tester.gotoPage("/browse/H01-1-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Awful regex bug");
        this.tester.gotoPage("/browse/HSP-1");
        this.viewIssueAssertions.assertIssueNotFound();
        this.tester.gotoPage("/browse/!@#$%^&*-1");
        this.textAssertions.assertTextNotPresent(this.locator.page(), "Issue does not exist");
        this.assertions.assertHttpStatusCode(HttpStatus.NOT_FOUND);
    }
}

