/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueHeader
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testIssueHeaderTablePresent() {
        this.administration.restoreData("TestIssueHeader.xml");
        this.navigation.issue().viewIssue("HSP-1");
        this.tester.assertLinkPresentWithText("New Component 1");
        this.tester.assertLinkNotPresentWithText("New Version 1");
        this.tester.assertLinkPresentWithText("New Version 5");
    }

    @Test
    public void testSubTaskBreadcrumbs() throws Exception {
        this.administration.restoreData("TestIssueHeaderSubTaskBreadcrumbs.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issue().viewIssue("HSP-1");
        this.textAssertions.assertTextPresent("Test &lt;em&gt;Bug One&lt;/em&gt; which has a long long summary longer than the abbreviation limit");
        this.textAssertions.assertTextNotPresent("Test <em>Bug One</em> which has a long long summary longer than the abbreviation limit");
        this.navigation.issue().viewIssue("HSP-3");
        this.textAssertions.assertTextPresent("HSP-1 Test &lt;em&gt;Bug One&lt;/em&gt; which has a long long summary longer than the abbreviation limit");
        this.textAssertions.assertTextNotPresent("Test <em>Bug One</em> which has a long long summary longer than the abbreviation limit");
        this.assertions.assertNodeExists("//a[@id='parent_issue_summary'][@title='Test <em>Bug One</em> which has a long long summary longer than the abbreviation limit']");
    }
}

