/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.util.SlowTest;
import com.atlassian.jira.webtests.ztests.workflow.WorkflowUtil;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueOperations
extends BaseJiraFuncTest {
    private static final String ISSUE_KEY_1 = "HSP-1";
    private static final String ISSUE_KEY_2 = "HSP-2";
    private static final String TEST_USER_1 = "testuser";
    private static final String TEST_USER_2 = "testuser2";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;
    @Inject
    private WorkflowUtil workflowUtil;

    @Test
    public void testIssueOperations() {
        this.administration.restoreData("TestIssueOperations.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.attachments().enable();
        this.issueOperationsWithWorkOnPermission(ISSUE_KEY_1);
        this.issueOperationWithUnassignableCurrentAssignee(ISSUE_KEY_1);
        this.issueOperationWithAssignPermission(ISSUE_KEY_1);
        this.issueOperationWithCreateAttachmentsPermission(ISSUE_KEY_1);
        this.issueOperationCacheControl(ISSUE_KEY_1);
    }

    @Test
    @SlowTest
    public void testIssueLinksForOperations() {
        this.administration.restoreData("TestIssueIconOperations.xml");
        this.navigation.login("fred");
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.assertLinkPresent("aszip");
        this.tester.assertLinkPresent("manage-attachment-link");
        this.tester.assertLinkPresent("add-attachments-link");
        this.tester.assertLinkPresent("add-links-link");
        this.tester.assertLinkPresent("log-work-link");
        this.tester.clickLink("manage-attachment-link");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Manage Attachments", "This page allows you to manage the attachments", "foobar.json"});
        this.tester.assertLinkPresent("aszipbutton");
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.clickLink("add-attachments-link");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Attach Files"});
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.clickLink("add-links-link");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Link"});
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.clickLink("log-work-link");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Log work"});
        this.navigation.login("user", "user");
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.assertLinkPresent("aszip");
        this.tester.assertLinkNotPresent("manage-attachment-link");
        this.tester.assertLinkNotPresent("add-attachments-link");
        this.tester.assertLinkPresent("add-links-link");
        this.tester.assertLinkNotPresent("log-work-link");
        this.navigation.login("admin");
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.assertLinkPresent("aszip");
        this.tester.assertLinkPresent("manage-attachment-link");
        this.tester.assertLinkNotPresent("add-attachments-link");
        this.tester.assertLinkPresent("add-links-link");
        this.tester.assertLinkNotPresent("log-work-link");
        this.administration.attachments().disableZipSupport();
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.assertLinkNotPresent("aszip");
        this.tester.clickLink("manage-attachment-link");
        this.tester.assertLinkNotPresent("aszipbutton");
    }

    public void issueOperationsWithWorkOnPermission(String issueKey) {
        this.logger.log((Object)"Issue Operation: Test availability of Log Work Link with 'Work On Issues' permission.");
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.WORK_ON_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("log-work");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.WORK_ON_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("log-work");
        this.administration.timeTracking().disable();
    }

    @Test
    public void testLogWorkOperationTimeTrackingDisabled() {
        this.administration.restoreData("TestIssueOperations.xml");
        this.administration.timeTracking().disable();
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.assertLinkNotPresent("log-work");
    }

    @Test
    public void testLogWorkOperationAnonymous() {
        this.administration.restoreData("TestIssueOperations.xml");
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.BROWSE_PROJECTS, "group");
        this.navigation.logout();
        this.tester.gotoPage("/browse/HSP-1");
        this.tester.assertLinkNotPresent("log-work");
    }

    @Test
    public void testLogWorkOperationIssueInNonEditableState() {
        this.administration.restoreData("TestIssueOperations.xml");
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.workflowUtil.clickAction("action_id_2");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
        this.tester.assertLinkNotPresent("log-work");
    }

    @Test
    public void testLogWorkOperationHappyPath() {
        this.administration.restoreData("TestIssueOperations.xml");
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.navigation.issue().gotoIssue(ISSUE_KEY_1);
        this.tester.assertLinkPresent("log-work");
    }

    public void issueOperationWithUnassignableCurrentAssignee(String issueKey) {
        this.logger.log((Object)"Issue Operation: Attempt to set the assignee to be an unassignable user ...");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("assign-issue");
        this.tester.setWorkingForm("assign-issue");
        this.tester.submit();
        this.tester.assertTextNotPresent("The default assignee does NOT have ASSIGNABLE permission OR Unassigned issues are turned off.");
        this.tester.assertTextPresent("Issue already assigned to Administrator (admin)");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGNABLE_USER, "jira-developers");
    }

    public void issueOperationWithAssignPermission(String issueKey) {
        this.logger.log((Object)"Issue Operation: Test the availability of the 'Assign Link' with 'Assign Issues' Permission.");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("assign-issue");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("assign-issue");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.ASSIGN_ISSUES, "jira-developers");
    }

    public void issueOperationWithCreateAttachmentsPermission(String issueKey) {
        this.logger.log((Object)"Issue Operation: Test the availability of the 'Attach Link' with 'Create Attachments' Permission.");
        this.backdoor.permissionSchemes().removeGroupPermission(0L, ProjectPermissions.CREATE_ATTACHMENTS, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkNotPresent("attach-file");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.CREATE_ATTACHMENTS, "jira-users");
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.assertLinkPresent("attach-file");
    }

    public void issueOperationCacheControl(String issueKey) {
        this.logger.log((Object)"Issue Operation: Test cache control for Issue Navigator pages.");
        this.navigation.issueNavigator().displayAllIssues();
        String cache = this.tester.getDialog().getResponse().getHeaderField("Cache-Control");
        MatcherAssert.assertThat((Object)cache, (Matcher)Is.is((Object)"no-cache, no-store, must-revalidate"));
        this.navigation.issue().gotoIssue(issueKey);
        cache = this.tester.getDialog().getResponse().getHeaderField("Cache-Control");
        MatcherAssert.assertThat((Object)cache, (Matcher)Is.is((Object)"no-store, no-cache, must-revalidate"));
    }

    @Test
    public void testIssueOperationManageWatcherList() {
        this.administration.restoreData("TestIssueOperationsWithReporter.xml");
        this.administration.attachments().enable();
        this.navigation.logout();
        this.navigation.login(TEST_USER_1, TEST_USER_1);
        this.navigation.issue().gotoIssue(ISSUE_KEY_2);
        this.tester.assertLinkPresent("manage-watchers");
        this.navigation.logout();
        this.navigation.login(TEST_USER_2, TEST_USER_2);
        this.tester.assertLinkNotPresent("manage-watchers");
        this.navigation.logout();
    }
}

