/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.assertions.ViewIssueAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@LoginAs(user="admin")
@Restore(value="TestIssueOperationsOnDeletedIssueProEnt.xml")
public class TestIssueOperationsOnDeletedIssue
extends BaseJiraFuncTest {
    public static final String DELETED_ISSUE_ID = "10000";
    public static final String DELETED_ISSUE_KEY = "HSP-1";
    public static final String EXISTING_ISSUE_ID = "10001";
    public static final String EXISTING_ISSUE_KEY = "HSP-2";
    public static final String DELETED_ISSUE_ERROR = "The issue no longer exists.";
    public static final String DELETED_VIEW_ISSUE_ERROR = "The issue you are trying to view does not exist.";
    private static final String MANAGE_WATCHERS = "Watchers";
    @Inject
    private HtmlPage page;
    @Inject
    private ViewIssueAssertions viewIssueAssertions;

    @Test
    public void testIssueOperationsOnDeletedIssue() {
        this._testIssueOperationsOnDeletedIssueStandard();
        this._testIssueOperationsOnDeletedIssueProfessionalAndEnterprise();
    }

    public void _testIssueOperationsOnDeletedIssueStandard() {
        this.assertDeletedIssueErrorKickass("Details");
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?vote=vote&", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?vote=unvote&", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?watch=watch&", "Details", true);
        this.assertDeletedIssueError("VoteOrWatchIssue.jspa?watch=unwatch&", "Details", true);
        this.assertDeletedIssueError("WorkflowUIDispatcher.jspa?action=5&", "Resolve Issue");
        this.tester.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10001&action=5&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent("Resolve Issue");
        this.tester.gotoPage("/secure/WorkflowUIDispatcher.jspa?id=10000&action=5&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent(DELETED_ISSUE_ERROR);
        this.assertDeletedIssueError("CommentAssignIssue!default.jspa?action=5&", "Resolve Issue");
        this.assertDeletedIssueError("AssignIssue!default.jspa?", "Assign");
        this.assertDeletedIssueError("EditIssue!default.jspa?", "Edit Issue");
        this.assertDeletedIssueError("CloneIssueDetails!default.jspa?", "Summary");
        this.assertDeletedIssueError("MoveIssue!default.jspa?", "homosapien");
        this.assertDeletedIssueError("ViewVoters!default.jspa?", "Voters");
        this.assertDeletedIssueError("ViewVoters!addVote.jspa?", "Voters");
        this.assertDeletedIssueError("ViewVoters!removeVote.jspa?", "Voters");
        this.assertDeletedIssueError("ManageWatchers!default.jspa?", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!startWatching.jspa?", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!stopWatching.jspa?", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!startWatchers.jspa?userNames=admin&", MANAGE_WATCHERS);
        this.assertDeletedIssueError("ManageWatchers!stopWatchers.jspa?userNames=admin&", MANAGE_WATCHERS);
        this.assertDeletedIssueError("CreateWorklog!default.jspa?", "Log work");
        this.assertDeletedIssueError("UpdateWorklog!default.jspa?worklogId=10000&", "Edit Work Log");
        this.assertDeletedIssueError("DeleteWorklog!default.jspa?worklogId=10000&", "Delete Worklog");
        this.assertDeletedIssueError("EditComment!default.jspa?commentId=10000&", "Edit Comment", "first comment", false);
    }

    private void _testIssueOperationsOnDeletedIssueProfessionalAndEnterprise() {
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10001");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.gotoPage("/secure/CreateSubTaskIssue!default.jspa?parentIssueId=10000");
        this.tester.assertTextPresent(DELETED_ISSUE_ERROR);
        this.tester.gotoPage("/secure/CreateSubTaskIssue.jspa?parentIssueId=10001");
        this.tester.assertTextPresent("Create Sub-Task");
        this.tester.gotoPage("/secure/CreateSubTaskIssue.jspa?parentIssueId=10000");
        this.tester.assertTextPresent(DELETED_ISSUE_ERROR);
        this.gotoFieldConfigurationDefault();
        this.tester.clickLink("hide_15");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=createdSubtask&assignee=admin&reporter=admin&parentIssueId=10001"));
        this.tester.assertTextPresent("createdSubtask");
        this.tester.assertTextNotPresent("Create Sub-Task");
        this.tester.assertTextNotPresent("Enter the details of the issue");
        this.tester.assertTextPresent("Sub-task");
        this.tester.gotoPage(this.page.addXsrfToken("/secure/CreateSubTaskIssueDetails.jspa?issuetype=5&pid=10000&summary=createdSubtask&assignee=admin&reporter=admin&parentIssueId=10000"));
        this.tester.assertTextPresent(DELETED_ISSUE_ERROR);
    }

    private void gotoFieldConfigurationDefault() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.FIELD_CONFIGURATION);
        this.tester.clickLink("configure-Default Field Configuration");
        this.tester.assertTextPresent("View Field Configuration");
    }

    private void assertDeletedIssueError(String actionUrl, String textNotPresent, boolean isViewIssue) {
        this.assertDeletedIssueError(actionUrl, textNotPresent, textNotPresent, isViewIssue);
    }

    private void assertDeletedIssueError(String actionUrl, String textNotPresent) {
        this.assertDeletedIssueError(actionUrl, textNotPresent, textNotPresent, false);
    }

    private void assertDeletedIssueErrorKickass(String textNotPresent) {
        this.tester.gotoPage("/browse/HSP-2?atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent(textNotPresent);
        this.tester.gotoPage("/browse/HSP-1?atl_token=" + this.page.getXsrfToken());
        this.viewIssueAssertions.assertIssueNotFound();
    }

    private void assertDeletedIssueError(String actionUrl, String textPresent, String textNotPresent, boolean isViewIssue) {
        this.tester.gotoPage("/secure/" + actionUrl + "id=" + EXISTING_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        this.tester.assertTextPresent(textPresent);
        this.tester.gotoPage("/secure/" + actionUrl + "id=" + DELETED_ISSUE_ID + "&atl_token=" + this.page.getXsrfToken());
        if (isViewIssue) {
            this.tester.assertTextPresent(DELETED_VIEW_ISSUE_ERROR);
        } else {
            this.tester.assertTextPresent(DELETED_ISSUE_ERROR);
        }
    }
}

