/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
@Restore(value="TestTimeTrackingAggregates.xml")
@LoginAs(user="admin")
public class TestIssuePrintableView
extends BaseJiraFuncTest {
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUp() {
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
    }

    @Test
    public void testPrintableView() {
        this.navigation.issue().gotoIssue("HSP-10");
        this.tester.clickLinkWithText("Printable");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"parent 2", "HSP-9", "HSP-10", "sub 3"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Status:", "Open");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Project:", "homosapien");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Component/s:", "None");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Affects Version/s:", "None");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Fix Version/s:", "None");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Type:", "Sub-task", "Priority:", "Major"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Reporter:", "Administrator", "Assignee:", "Administrator"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Resolution:", "Unresolved", "Votes:", "0"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Remaining Estimate:", "1 day", "Time Spent:", "1 day", "Original Estimate:", "1 day"});
        this.tester.assertTableNotPresent(" Remaining Estimate:");
        this.tester.assertTableNotPresent(" Time Spent:");
        this.tester.assertTableNotPresent(" Original Estimate:");
        this.tester.assertTableNotPresent("Sub-Tasks:");
        this.tester.gotoPage("/browse/HSP-9");
        this.tester.clickLinkWithText("Printable");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "HSP-9", "parent 2");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Status:", "Open");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Project:", "homosapien");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Component/s:", "None");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Affects Version/s:", "None");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), "Fix Version/s:", "None");
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Type:", "Bug", "Priority:", "Major"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Reporter:", "Administrator", "Assignee:", "Administrator"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Resolution:", "Unresolved", "Votes:", "0"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{" Remaining Estimate:", "3 days", "Remaining Estimate:", "Not Specified", " Time Spent:", "1 day", "Time Spent:", "Not Specified", " Original Estimate:", "3 days", "Original Estimate:", "Not Specified"});
        this.textAssertions.assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"Sub-Tasks:", "HSP-10", "sub 3", "HSP-11", "sub 4"});
    }

    @Test
    public void testProperHtmlEscaping() {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.clickLink("edit_profile_lnk");
        this.tester.setFormElement("fullName", "Administrator &trade;");
        this.tester.submit();
        this.putTradeMarkIntoIssue("HSP-10");
        this.putTradeMarkIntoIssue("HSP-9");
        this.backdoor.issueLinking().createIssueLinkType("related", "is related to", "relates to");
        this.navigation.issue().linkIssueWithComment("HSP-9", "relates to", "HSP-10", null, null);
        this.tester.clickLinkWithText("Printable");
        this.assertTradeMarkIsEscaped();
        this.tester.gotoPage("/");
        this.navigation.issueNavigator().displayPrintableAllIssues();
        this.assertTradeMarkIsEscaped();
        this.tester.gotoPage("/");
        this.navigation.issueNavigator().displayFullContentAllIssues();
        this.assertTradeMarkIsEscaped();
        this.tester.gotoPage("/");
    }

    private void putTradeMarkIntoIssue(String issueKey) {
        this.navigation.issue().gotoIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("summary", "Issue " + issueKey + " &trade;");
        this.tester.setFormElement("environment", "&trade;");
        this.tester.setFormElement("description", "&trade;");
        this.tester.setFormElement("comment", "&trade;");
        this.tester.submit("Update");
    }

    private void assertTradeMarkIsEscaped() {
        this.tester.assertTextNotPresent("&trade;");
        this.tester.assertTextPresent("&amp;trade;");
    }
}

