/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.Arrays;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES, Category.ROLES, Category.SECURITY})
@LoginAs(user="admin")
public class TestIssueSecurityWithRoles
extends BaseJiraFuncTest {
    private static final String HSP_ISSUE_NO_SECURITY = "HSP-1";
    private static final String HSP_ISSUE_DEV_ROLE_SECURITY = "HSP-2";
    private static final String HSP_ISSUE_ADMIN_ROLE_SECURITY = "HSP-3";
    private static final String MKY_ISSUE_NO_SECURITY = "MKY-1";
    private static final String MKY_ISSUE_DEV_ROLE_SECURITY = "MKY-2";
    private static final String ELE_ISSUE_NO_SECURITY = "ELE-1";
    private static final String ELE_ISSUE_DEV_ROLE_SECURITY = "ELE-2";
    @Inject
    private Administration administration;

    @Before
    public void setUp() {
        this.administration.restoreData("TestIssueSecurityWithRoles.xml");
    }

    @Test
    public void testIssueSecurityWithRolesIssueNavigator() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.tester.assertLinkPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.navigation.issue().gotoIssue(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertTextNotPresent("Permission violation");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.tester.assertLinkNotPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.navigation.issue().gotoIssue(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testIssueSecurityWithRolesMultiProject() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.tester.assertLinkPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertLinkPresentWithText(MKY_ISSUE_NO_SECURITY);
        this.tester.assertLinkPresentWithText(MKY_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertLinkPresentWithText(ELE_ISSUE_NO_SECURITY);
        this.tester.assertLinkPresentWithText(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.navigation.issue().gotoIssue(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.tester.assertLinkNotPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertLinkPresentWithText(MKY_ISSUE_NO_SECURITY);
        this.tester.assertLinkNotPresentWithText(MKY_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertLinkPresentWithText(ELE_ISSUE_NO_SECURITY);
        this.tester.assertLinkNotPresentWithText(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.navigation.issue().gotoIssue(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.assertions.getViewIssueAssertions().assertIssueNotFound();
    }

    @Test
    public void testIssueSecurityWithRolesEditIssueFields() {
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertLinkPresentWithText(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.navigation.issue().gotoIssue(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        Assert.assertThat(Arrays.asList(this.tester.getDialog().getOptionLabelsFromSelectList("security")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"None", "My Security Level", "Administrators Security Level"}));
        this.backdoor.projectRole().deleteUser("HSP", "Developers", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertLinkNotPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.tester.assertLinkPresentWithText(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.navigation.issue().gotoIssue(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        Assert.assertThat(Arrays.asList(this.tester.getDialog().getOptionLabelsFromSelectList("security")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"None", "Administrators Security Level"}));
    }

    @Test
    public void testIssueSecurityWithRolesEditIssueFieldsDirectly() {
        this.tester.gotoPage("/secure/EditIssue!default.jspa?id=10020");
        this.tester.setWorkingForm("issue-edit");
        Assert.assertThat(Arrays.asList(this.tester.getDialog().getOptionLabelsFromSelectList("security")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"None", "My Security Level", "Administrators Security Level"}));
        this.backdoor.projectRole().deleteUser("HSP", "Developers", "admin");
        this.tester.gotoPage("/secure/EditIssue!default.jspa?id=10020");
        this.tester.setWorkingForm("issue-edit");
        Assert.assertThat(Arrays.asList(this.tester.getDialog().getOptionLabelsFromSelectList("security")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"None", "Administrators Security Level"}));
    }
}

