/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.webtests.ztests.issue.TestXmlCustomIssueView;
import electric.xml.Document;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestSearchXmlCustomIssueView
extends TestXmlCustomIssueView {
    @Inject
    private FuncTestLogger logger;

    @Override
    protected String getHSP1ViewPage(String fieldParam) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?pid=10000&resolution=1&sorter/field=issuekey&sorter/order=ASC&tempMax=1000&" + fieldParam;
    }

    @Override
    protected String getHSP2ViewPage(String fieldParam) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?type=1&pid=10000&resolution=-1&sorter/field=issuekey&sorter/order=ASC&tempMax=1000&" + fieldParam;
    }

    @Override
    protected String getHSP3ViewPage(String fieldParam) {
        return "/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?type=5&pid=10000&sorter/field=issuekey&sorter/order=ASC&tempMax=1000&" + fieldParam;
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testXMLCommentsOfResultsNoParam() throws Exception {
        this.testXMLCommentOfResults(this.getHSP1ViewPage(""));
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testXMLCommentsOfResultsIrrelevantParam() throws Exception {
        this.testXMLCommentOfResults(this.getHSP1ViewPage("blah=value"));
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testXMLCommentsOfResultsSearchRequest() throws Exception {
        this.testXMLCommentOfResults("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml");
    }

    public void testXMLCommentOfResults(String url) throws Exception {
        this.navigation.gotoPage(url);
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        Document doc = this.getDocument();
        this.logger.log((Object)"Checking the contents of the XML comment of the XML resulsts");
        Node commentNode = doc.getFirstChild();
        Assert.assertNotNull((Object)commentNode);
        Assert.assertEquals((long)8L, (long)commentNode.getNodeType());
        String commentText = commentNode.getNodeValue();
        Assert.assertNotNull((Object)commentText);
        Assert.assertTrue((boolean)commentText.contains("RSS generated by JIRA"));
        Assert.assertTrue((boolean)commentText.contains("It is possible to restrict the fields that are returned in this document by specifying the 'field' parameter in your request.\nFor example, to request only the issue key and summary append 'field=key&field=summary' to the URL of your request."));
    }
}

