/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebLink;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS, Category.FIELDS})
@LoginAs(user="admin")
public class TestWikiRendererXSS
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;

    @Test
    public void testCodeMacro() {
        this.administration.restoreData("TestWikiRendererXSSInLink.xml");
        this.navigation.issue().addComment("HSP-1", "{code:lang=x\"</pre><script>alert(1)</script>}xxx{code}", null);
        this.navigation.issue().viewIssue("HSP-1");
        String xpath = "//div[@id='comment-10020']/div[1]//pre";
        this.assertions.assertNodeDoesNotHaveText("//div[@id='comment-10020']/div[1]//pre", "alert(1)\">xxx");
        this.assertions.assertNodeHasText("//div[@id='comment-10020']/div[1]//pre", "xxx");
    }

    @Test
    public void testXSSLinks() {
        this.administration.restoreData("TestWikiRendererXSSInLink.xml");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertLinkPresent("test email link", "mailto:whatever@broken.com\" onclick=\"alert('hi. I am a fun onclick event')");
        this.assertLinkPresent("test file link", "file:anything\" onclick=\"alert('hi. I am a fun onclick event')");
        this.assertLinkPresent("test http link", "http://www.atlassian.com\" onclick=\"alert('hi. I am a fun onclick event')");
        this.assertLinkPresent("bad user", "secure/ViewProfile.jspa?name=bad%22+onclick%3Dalert%28%27bad%27%29");
        this.assertLinkPresent("attachment xss", "secure/attachment/10000/10000_%23b+onclick%3Dalert%28%27b%27%29.png");
        this.assertLinkPresent("escaped", "<escaped>");
        WebLink anchorLink = this.getLinkWithName("anchor");
        Assert.assertEquals((Object)"brenden\" onclick=\"alert('XSS')", (Object)anchorLink.getFragmentIdentifier());
    }

    private void assertLinkPresent(String linkName, String urlSuffix) {
        WebLink webLink = this.getLinkWithName(linkName);
        Assert.assertTrue((String)("Link should have ended with '" + urlSuffix + "' but actually was '" + webLink.getURLString() + "'"), (boolean)webLink.getURLString().endsWith(urlSuffix));
    }

    private WebLink getLinkWithName(String linkName) {
        try {
            return this.tester.getDialog().getResponse().getLinkWith(linkName);
        }
        catch (SAXException e) {
            AssertionError error = new AssertionError((Object)("Unable to read in document to find link with text'" + linkName + "'."));
            ((Throwable)((Object)error)).initCause(e);
            throw error;
        }
    }
}

