/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.FileUtils;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.EditIssueFieldVisibility;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.IXPath;
import electric.xml.ParseException;
import electric.xml.XPath;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.ISSUES})
public class TestXmlCustomIssueView
extends BaseJiraFuncTest {
    @Inject
    private TimeTracking timeTracking;
    @Inject
    private EditIssueFieldVisibility editIssueFieldVisibility;
    @Inject
    private FuncTestLogger logger;

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testNodeFilter() throws IOException, ParseException {
        this.checkNodeFilter("field=title", "title");
        this.checkNodeFilter("field=link", "link");
        this.checkNodeFilter("field=project", "project");
        this.checkNodeFilter("field=summary", "summary");
        this.checkNodeFilter("field=description", "description");
        this.checkNodeFilter("field=environment", "environment");
        this.checkNodeFilter("field=issuetype", "type");
        this.checkNodeFilter("field=priority", "priority");
        this.checkNodeFilter("field=status", "status");
        this.checkNodeFilter("field=resolution", "resolution");
        this.checkNodeFilter("field=security", "security");
        this.checkNodeFilter("field=assignee", "assignee");
        this.checkNodeFilter("field=reporter", "reporter");
        this.checkNodeFilter("field=created", "created");
        this.checkNodeFilter("field=updated", "updated");
        this.checkNodeFilter("field=resolutiondate", "resolved");
        this.checkNodeFilter("field=version", "version");
        this.checkNodeFilter("field=fixVersions", "fixVersion");
        this.checkNodeFilter("field=component", "component");
        this.checkNodeFilter("field=due", "due");
        this.checkNodeFilter("field=votes", "votes");
        this.checkNodeFilter("field=comments", "comments");
        this.checkNodeFilter("field=attachment", "attachments");
        this.checkNodeFilter("field=subtasks", "subtasks");
        this.checkNodeFilter("field=issuelinks", "issuelinks");
        this.checkNodeFilter("field=timespent", "timespent");
        this.checkNodeFilter("field=timeestimate", "timeestimate");
        this.checkNodeFilter("field=timeoriginalestimate", "timeoriginalestimate");
        this.checkNodeFilter("field=aggregatetimeoriginalestimate", "aggregatetimeoriginalestimate");
        this.checkNodeFilter("field=aggregatetimeestimate", "aggregatetimereaminingestimate");
        this.checkNodeFilter("field=aggregatetimespent", "aggregatetimespent");
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testProjectFieldFilter() throws IOException, ParseException {
        String fieldParam = "field=project";
        String issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage("field=project"));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", "HSP-1", null);
        this.assertElementExists(doc, "//item/project");
        this.assertElementExists(doc, "//item/project[@id='10000']");
        this.assertElementExists(doc, "//item/project[@key='HSP']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testCustomFieldFilter() throws IOException, ParseException {
        String fieldParam = "field=allcustom";
        String issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage(fieldParam));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementExists(doc, "//item/customfields/customfield");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10000']");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10001']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=allcustom";
        issueKey = "HSP-2";
        this.navigation.gotoPage(this.getHSP2ViewPage(fieldParam));
        this.assertXmlContentType();
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementNotExists(doc, "//item/customfields/customfield");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10000";
        issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage(fieldParam));
        this.assertXmlContentType();
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementExists(doc, "//item/customfields/customfield");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10000']");
        this.assertElementNotExists(doc, "//item/customfields/customfield[@id='customfield_10001']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10001";
        issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage(fieldParam));
        this.assertXmlContentType();
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertElementExists(doc, "//item/customfields/customfield");
        this.assertElementExists(doc, "//item/customfields/customfield[@id='customfield_10001']");
        this.assertElementNotExists(doc, "//item/customfields/customfield[@id='customfield_10000']");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10000";
        issueKey = "HSP-2";
        this.navigation.gotoPage(this.getHSP2ViewPage(fieldParam));
        this.assertXmlContentType();
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertXpathElementNotPresent(doc, "//item/customfields/customfield");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        fieldParam = "field=customfield_10001";
        issueKey = "HSP-2";
        this.tester.gotoPage(this.getHSP2ViewPage(fieldParam));
        this.assertXmlContentType();
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementExists(doc, "//item/customfields");
        this.assertXpathElementNotPresent(doc, "//item/customfields/customfield");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testMultipleNodeFilter() throws IOException, ParseException {
        String fieldParam = "field=title&field=link&field=project&field=summary&field=description&field=environment&field=issuetype&field=priority&field=status&field=resolution&field=security&field=assignee&field=reporter&field=created&field=updated&field=resolutiondate&field=version&field=fixVersions&field=component&field=due&field=votes&field=comments&field=attachments&field=subtasks&field=issuelinks&field=timespent&field=timeestimate&field=timeoriginalestimate&field=aggregatetimeoriginalestimate&field=aggregatetimeestimate&field=aggregatetimespent";
        String issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage("field=title&field=link&field=project&field=summary&field=description&field=environment&field=issuetype&field=priority&field=status&field=resolution&field=security&field=assignee&field=reporter&field=created&field=updated&field=resolutiondate&field=version&field=fixVersions&field=component&field=due&field=votes&field=comments&field=attachments&field=subtasks&field=issuelinks&field=timespent&field=timeestimate&field=timeoriginalestimate&field=aggregatetimeoriginalestimate&field=aggregatetimeestimate&field=aggregatetimespent"));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", "HSP-1", null);
        this.assertElementExists(doc, "//item/title");
        this.assertElementExists(doc, "//item/link");
        this.assertElementExists(doc, "//item/project");
        this.assertElementExists(doc, "//item/project[@key]");
        this.assertElementExists(doc, "//item/summary");
        this.assertElementExists(doc, "//item/description");
        this.assertElementExists(doc, "//item/environment");
        this.assertElementExists(doc, "//item/summary");
        this.assertElementExists(doc, "//item/type");
        this.assertElementExists(doc, "//item/priority");
        this.assertElementExists(doc, "//item/status");
        this.assertElementExists(doc, "//item/resolution");
        this.assertElementExists(doc, "//item/security");
        this.assertElementExists(doc, "//item/assignee");
        this.assertElementExists(doc, "//item/reporter");
        this.assertElementExists(doc, "//item/created");
        this.assertElementExists(doc, "//item/updated");
        this.assertElementExists(doc, "//item/resolved");
        this.assertElementExists(doc, "//item/version");
        this.assertElementExists(doc, "//item/fixVersion");
        this.assertElementExists(doc, "//item/component");
        this.assertElementExists(doc, "//item/due");
        this.assertElementExists(doc, "//item/votes");
        this.assertElementExists(doc, "//item/comments");
        this.assertElementExists(doc, "//item/attachments");
        this.assertElementExists(doc, "//item/subtasks");
        this.assertElementExists(doc, "//item/issuelinks");
        this.assertElementExists(doc, "//item/timespent");
        this.assertElementExists(doc, "//item/timeoriginalestimate");
        this.assertElementExists(doc, "//item/timeestimate");
        this.assertElementExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testParentNodeFilter() throws IOException, ParseException {
        String fieldParam = "field=parent";
        String issueKey = "HSP-3";
        this.navigation.gotoPage(this.getHSP3ViewPage("field=parent"));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", "HSP-3", null);
        this.assertElementExists(doc, "//item/parent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testNodeFilterMapping() throws IOException, ParseException {
        this.checkNodeFilter("field=pid", "project");
        this.checkNodeFilter("field=comment", "comments");
        this.checkNodeFilter("field=components", "component");
        this.checkNodeFilter("field=duedate", "due");
        this.checkNodeFilter("field=type", "type");
        this.checkNodeFilter("field=versions", "version");
        this.checkNodeFilter("field=fixfor", "fixVersion");
        this.checkNodeFilter("field=attachments", "attachments");
        this.checkNodeFilter("field=resolved", "resolved");
        this.checkNodeFilter("field=aggregatetimeremainingestimate", "aggregatetimeremainingestimate");
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testInvalidFieldDefined() throws Exception {
        this.checkFieldDefinitionError("field");
        this.checkFieldDefinitionError("field=");
        this.checkFieldDefinitionError("field=nonExisting");
        this.checkFieldDefinitionError("field=nonExistin1&field=nonExisting2");
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testValidAndInvalidFieldDefined() throws IOException, ParseException {
        this.checkNodeFilter("field=project&field=nonExisting2", "project");
    }

    @Test
    @Restore(value="TestXMLIssueCustomView.xml")
    @LoginAs(user="admin")
    public void testTimetrackingField() throws IOException, ParseException {
        String fieldParam = "field=timetracking";
        String issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage("field=timetracking"));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", "HSP-1", null);
        this.assertElementExists(doc, "//item/timespent");
        this.assertElementExists(doc, "//item/timeoriginalestimate");
        this.assertElementExists(doc, "//item/timeestimate");
        this.assertElementExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        this.editIssueFieldVisibility.setHiddenFields("Time Tracking");
        this.navigation.gotoPage(this.getHSP1ViewPage("field=timetracking"));
        this.assertXmlContentType();
        doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", "HSP-1", null);
        this.assertElementNotExists(doc, "//item/timespent");
        this.assertElementNotExists(doc, "//item/timeoriginalestimate");
        this.assertElementNotExists(doc, "//item/timeestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
        this.timeTracking.disable();
        this.checkDisabledTimetracking("HSP-1", "field=timetracking");
        this.checkDisabledTimetracking("HSP-1", "field=timespent");
        this.checkDisabledTimetracking("HSP-1", "field=timeoriginalestimate");
        this.checkDisabledTimetracking("HSP-1", "field=timeestimate");
        this.checkDisabledTimetracking("HSP-1", "field=aggregatetimeoriginalestimate");
        this.checkDisabledTimetracking("HSP-1", "field=aggregatetimeremainingestimate");
        this.checkDisabledTimetracking("HSP-1", "field=aggregatetimespent");
    }

    protected void checkDisabledTimetracking(String issueKey, String fieldParam) throws IOException, ParseException {
        this.navigation.gotoPage(this.getHSP1ViewPage(fieldParam));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", issueKey, null);
        this.assertElementNotExists(doc, "//item/timespent");
        this.assertElementNotExists(doc, "//item/timeoriginalestimate");
        this.assertElementNotExists(doc, "//item/timeestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeoriginalestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimeremainingestimate");
        this.assertElementNotExists(doc, "//item/aggregatetimespent");
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    protected void checkFieldDefinitionError(String fieldParam) throws Exception {
        String issueKey = "HSP-1";
        String issueUrl = this.getEnvironmentData().getBaseUrl().toString() + "/si/jira.issueviews:issue-xml/" + "HSP-1" + "/" + "HSP-1" + ".xml?" + fieldParam;
        GetMethodWebRequest request = new GetMethodWebRequest(issueUrl);
        WebResponse webResponse = this.getTester().getTestContext().getWebClient().sendRequest((WebRequest)request);
        Assert.assertThat((Object)webResponse.getResponseCode(), (Matcher)Is.is((Object)HttpStatus.BAD_REQUEST.code));
    }

    protected String getHSP1ViewPage(String fieldParam) {
        return "/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml?" + fieldParam;
    }

    protected String getHSP2ViewPage(String fieldParam) {
        return "/si/jira.issueviews:issue-xml/HSP-2/HSP-2.xml?" + fieldParam;
    }

    protected String getHSP3ViewPage(String fieldParam) {
        return "/si/jira.issueviews:issue-xml/HSP-3/HSP-3.xml?" + fieldParam;
    }

    private void assertCommentDoesNotHaveDetailsOnRestrictingFields(Document doc) {
        this.logger.log((Object)"Checking the contents of the XML comment of the XML resulsts");
        Node commentNode = doc.getFirstChild();
        Assert.assertNotNull((Object)commentNode);
        Assert.assertEquals((long)8L, (long)commentNode.getNodeType());
        String commentText = commentNode.getNodeValue();
        Assert.assertNotNull((Object)commentText);
        Assert.assertTrue((commentText.indexOf("RSS generated by JIRA") > -1 ? 1 : 0) != 0);
        Assert.assertEquals((long)-1L, (long)commentText.indexOf("It is possible to restrict the fields"));
    }

    protected void checkNodeFilter(String fieldParam, String expectedField) throws IOException, ParseException {
        String issueKey = "HSP-1";
        this.navigation.gotoPage(this.getHSP1ViewPage(fieldParam));
        this.assertXmlContentType();
        Document doc = this.getDocument();
        this.assertExpectedXpathValue(doc, "//item/key", "HSP-1", null);
        this.assertElementForCustomView(doc, "//item/project", expectedField);
        this.assertElementForCustomView(doc, "//item/title", expectedField);
        this.assertElementForCustomView(doc, "//item/description", expectedField);
        this.assertElementForCustomView(doc, "//item/environment", expectedField);
        this.assertElementForCustomView(doc, "//item/summary", expectedField);
        this.assertElementForCustomView(doc, "//item/type", expectedField);
        this.assertElementForCustomView(doc, "//item/priority", expectedField);
        this.assertElementForCustomView(doc, "//item/status", expectedField);
        this.assertElementForCustomView(doc, "//item/resolution", expectedField);
        this.assertElementForCustomView(doc, "//item/security", expectedField);
        this.assertElementForCustomView(doc, "//item/assignee", expectedField);
        this.assertElementForCustomView(doc, "//item/reporter", expectedField);
        this.assertElementForCustomView(doc, "//item/created", expectedField);
        this.assertElementForCustomView(doc, "//item/updated", expectedField);
        this.assertElementForCustomView(doc, "//item/version", expectedField);
        this.assertElementForCustomView(doc, "//item/fixVersion", expectedField);
        this.assertElementForCustomView(doc, "//item/component", expectedField);
        this.assertElementForCustomView(doc, "//item/due", expectedField);
        this.assertElementForCustomView(doc, "//item/votes", expectedField);
        this.assertElementForCustomView(doc, "//item/comments", expectedField);
        this.assertElementForCustomView(doc, "//item/attachments", expectedField);
        this.assertElementForCustomView(doc, "//item/subtasks", expectedField);
        this.assertElementForCustomView(doc, "//item/issuelinks", expectedField);
        this.assertElementForCustomView(doc, "//item/timespent", expectedField);
        this.assertElementForCustomView(doc, "//item/timeoriginalestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/timeestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/aggregatetimeoriginalestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/aggregatetimeestimate", expectedField);
        this.assertElementForCustomView(doc, "//item/aggregatetimespent", expectedField);
        this.assertCommentDoesNotHaveDetailsOnRestrictingFields(doc);
    }

    protected void assertElementForCustomView(Document doc, String xPathExpression, String expectedField) {
        String field = "/" + expectedField;
        if (xPathExpression.endsWith(field)) {
            this.assertElementExists(doc, xPathExpression);
        } else {
            this.assertElementNotExists(doc, xPathExpression);
        }
    }

    protected void assertElementExists(Document doc, String xPathExpression) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        Assert.assertNotNull((String)("Element at xpath '" + xPathExpression + "' should not be null"), (Object)element);
    }

    protected void assertElementNotExists(Document doc, String xPathExpression) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        Assert.assertNull((String)("Element at xpath '" + xPathExpression + "' should not be present"), (Object)element);
    }

    private void assertXpathElementNotPresent(Document doc, String xpathExpression) {
        XPath xPath = new XPath(xpathExpression);
        Element element = doc.getElement((IXPath)xPath);
        if (element != null) {
            Assert.fail((String)("XML document contains element on path: " + xpathExpression));
        }
    }

    public void assertExpectedXpathValue(Document doc, String xPathExpression, String expectedValue, String attribute) {
        XPath xPath = new XPath(xPathExpression);
        Element element = doc.getElement((IXPath)xPath);
        String actualValue = attribute == null ? element.getText().toString() : element.getAttribute(attribute);
        Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        this.navigation.gotoPage("/secure/project/ViewProjects.jspa");
    }

    protected Document getDocument() throws IOException, ParseException {
        InputStream inputStream = this.tester.getDialog().getResponse().getInputStream();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        FileUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        return new Document(outputStream.toByteArray());
    }

    private void assertXmlContentType() {
        Assert.assertThat((Object)this.tester.getDialog().getResponse().getContentType(), (Matcher)Matchers.equalTo((Object)"text/xml"));
    }
}

