/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.comments;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Comment;
import com.atlassian.jira.testkit.client.restclient.EntityPropertyClient;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.EmailBaseFuncTestCase;
import com.atlassian.jira.webtests.ztests.bundledplugins2.rest.util.PropertyAssertions;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.COMMENTS})
@LoginAs(user="admin")
public class TestCommentOperations
extends EmailBaseFuncTestCase {
    private EntityPropertyClient client;

    @Before
    public void setUpTest() {
        this.client = new EntityPropertyClient((JIRAEnvironmentData)this.environmentData, "comment");
    }

    @Test
    @RestoreBlankInstance
    public void shouldDeleteCommentsForGivenIssue() {
        IssueCreateResponse issue = this.createIssueWithDependencies();
        int commentsCount = 201;
        ArrayList<String> commentIds = new ArrayList<String>();
        for (int i = 0; i < commentsCount; ++i) {
            String commentId = ((Comment)this.backdoor.issues().commentIssue((String)issue.key(), (String)"sample comment").body).id;
            this.client.put(commentId, "comment.meta", new JSONObject());
            commentIds.add(commentId);
        }
        this.backdoor.issues().deleteIssue(issue.key(), true);
        commentIds.forEach(id -> PropertyAssertions.assertWebApplicationException(() -> {
            this.client.get(id, "comment.meta");
            return null;
        }, Response.Status.NOT_FOUND));
    }

    private IssueCreateResponse createIssueWithDependencies() {
        Long permSchemeId = this.backdoor.permissionSchemes().copyDefaultScheme("comment perm scheme");
        Long projectId = this.backdoor.project().getProjectId("MKY");
        this.backdoor.permissionSchemes().addGroupPermission(permSchemeId, ProjectPermissions.EDIT_ALL_COMMENTS, "jira-administrators");
        this.backdoor.project().setPermissionScheme(projectId, permSchemeId);
        return this.backdoor.issues().createIssue("MKY", "Sample summary");
    }
}

