/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.ViewUserPage;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.Expando;
import com.atlassian.jira.testkit.client.restclient.Group;
import com.atlassian.jira.testkit.client.restclient.User;
import com.atlassian.jira.testkit.client.restclient.UserClient;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsEmptyCollection;
import org.junit.Assert;
import org.w3c.dom.Node;

public abstract class TestCreateUserHelper
extends BaseJiraFuncTest {
    private static final String WARNING_DIALOG_XPATH = "//aui-inline-dialog[contains(@id,'inline-dialog2-%s')]";
    @Inject
    protected LocatorFactory locator;
    @Inject
    protected TextAssertions textAssertions;

    protected void populateCreateUserForm(String userName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", userName);
        this.tester.setFormElement("password", userName);
        this.tester.setFormElement("fullname", userName);
        this.tester.setFormElement("email", userName + "@example.com");
    }

    protected void createUser(String userName) {
        this.populateCreateUserForm(userName);
        this.tester.submit("Create");
    }

    protected void gotoViewUserPage(String username) {
        this.navigation.gotoPageWithParams(ViewUserPage.class, ViewUserPage.generateViewUserQueryParameters(username));
    }

    protected void assertUserInGroups(String username, String ... groupNames) {
        this.gotoViewUserPage(username);
        UserClient userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        CssLocator locator = new CssLocator(this.tester, "#groups.view-user-module .group-name");
        List actualGroups = (List)Arrays.stream(locator.getNodes()).map(locator::getText).collect(CollectorsUtil.toImmutableList());
        this.assertions.assertEquals("User member of groups", (List)ImmutableList.copyOf((Object[])groupNames), actualGroups);
        Expando groups = userClient.get((String)username, (User.Expand[])new User.Expand[]{User.Expand.groups}).groups;
        ImmutableList collect = (ImmutableList)groups.items.stream().map(Group::getName).collect(CollectorsUtil.toImmutableList());
        this.assertions.assertEquals("Verify groups using backdoor", (List)collect, (List)ImmutableList.copyOf((Object[])groupNames));
    }

    protected void assertUserNotInAnyGroups(String username) {
        this.gotoViewUserPage(username);
        this.textAssertions.assertTextSequence(new WebPageLocator(this.tester), new String[]{"This user does not belong to any group."});
        UserClient userClient = new UserClient((JIRAEnvironmentData)this.environmentData);
        List groups = userClient.get((String)username, (User.Expand[])new User.Expand[]{User.Expand.groups}).groups.items;
        MatcherAssert.assertThat((Object)groups, (Matcher)IsEmptyCollection.empty());
    }

    protected void assertHasCheckbox(String checkBoxValue) {
        Assert.assertTrue((String)(checkBoxValue + " checkbox does not exist"), (boolean)this.locator.xpath("//input[@value='" + checkBoxValue + "']").exists());
    }

    protected void assertHasDisabledCheckbox(String checkBoxValue) {
        Assert.assertTrue((String)("Disabled " + checkBoxValue + " checkbox does not exist"), (boolean)this.locator.xpath("//input[@value='" + checkBoxValue + "'][@disabled]").exists());
    }

    protected Node getWarningDialog(String applicationKey) {
        return this.locator.xpath(String.format(WARNING_DIALOG_XPATH, applicationKey)).getNode();
    }

    protected void assertNoCheckboxButWarningButton(String applicationKey) {
        Node hook = this.locator.xpath("//a[contains(@aria-controls,'inline-dialog2-" + applicationKey + "')]").getNode();
        Assert.assertFalse((String)(applicationKey + " checkbox exists while it shouldn't"), (boolean)this.locator.xpath("//input[@value='" + applicationKey + "'][@disabled]").exists());
        Assert.assertNotNull((Object)hook);
        Assert.assertNotNull((Object)this.getWarningDialog(applicationKey));
    }

    protected boolean hasNoDefaultGroupWarningForApplication(String applicationKey) {
        this.assertNoCheckboxButWarningButton(applicationKey);
        return this.locator.xpath(String.format(WARNING_DIALOG_XPATH, applicationKey)).getNode().getTextContent().contains("no default group");
    }

    protected boolean hasUserLimitReachedWarningForApplication(String applicationKey) {
        this.assertNoCheckboxButWarningButton(applicationKey);
        return this.locator.xpath(String.format(WARNING_DIALOG_XPATH, applicationKey)).getNode().getTextContent().contains("licenses remaining");
    }
}

