/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.license.TestCreateUserHelper;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@LoginAs(user="admin")
public class TestCreateUserInMultipleApplicationRoles
extends TestCreateUserHelper {
    private static final String ADMIN_GROUP = "jira-administrators";
    @Inject
    private LocatorFactory locator;

    @Before
    public void setUp() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_AND_TEST_ROLES_DC);
        this.backdoor.applicationRoles().putRole("jira-func-test", new String[0]);
        this.backdoor.applicationRoles().putRole("jira-core", new String[0]);
    }

    @Test
    public void testCreateUserWhenOneRoleHasDefaultGroups() {
        this.backdoor.usersAndGroups().addGroup("platform-users");
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{"platform-users", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"platform-users"}));
        this.openCreateUserPage();
        Assert.assertTrue((boolean)this.hasNoDefaultGroupWarningForApplication("jira-func-test"));
        this.assertHasCheckbox("jira-core");
        this.tester.setFormElement("username", "nobody");
        this.tester.setFormElement("password", "nobody");
        this.tester.setFormElement("fullname", "nobody");
        this.tester.setFormElement("email", "nobody@example.com");
        this.tester.submit("Create");
        this.assertUserNotInAnyGroups("nobody");
        Assert.assertTrue((boolean)this.parseApplicationKeys(ParseApplicationKeysSelection.SELECTED_KEYS).isEmpty());
    }

    @Test
    public void testCreateUserWhenAllRolesHaveDefaultGroups() {
        this.backdoor.usersAndGroups().addGroup("platform-users");
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{"platform-users", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"platform-users"}));
        this.backdoor.usersAndGroups().addGroup("test-users");
        this.backdoor.usersAndGroups().addGroup("test-users2");
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-func-test", Sets.newHashSet((Object[])new String[]{"test-users", "test-users2"}), Sets.newHashSet((Object[])new String[]{"test-users", "test-users2"}));
        this.openCreateUserPage();
        Assert.assertFalse((String)"Create User has no Warning License without Default Group Banner", (boolean)this.locator.css(".warning-default-group-missing-multi-role").exists());
        Assert.assertFalse((String)"Create User has no warning for license over limit", (boolean)this.locator.css(".warning-users-over-limit-multi-role").exists());
        Assert.assertFalse((String)"Create User has no Warning License without Default Group Banner", (boolean)this.locator.css(".warning-default-group-missing").exists());
        Assert.assertFalse((String)"Create User has no warning for license over limit", (boolean)this.locator.css(".warning-users-over-limit").exists());
        Assert.assertFalse((String)"Create User has no warning for undefined application roles", (boolean)this.locator.css(".warning-undefined-role").exists());
        MatcherAssert.assertThat(this.parseApplicationKeys(ParseApplicationKeysSelection.ALL_KEYS), (Matcher)Matchers.contains((Object[])new String[]{"jira-func-test", "jira-core"}));
    }

    @Test
    public void testCreateUserOverSeatLimitInOneRole() {
        this.backdoor.usersAndGroups().addGroup("platform-users");
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{"platform-users", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"platform-users"}));
        this.backdoor.usersAndGroups().addGroup("test-users");
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", "test-users");
        this.backdoor.usersAndGroups().addUser("one");
        this.backdoor.usersAndGroups().addUser("two");
        this.backdoor.usersAndGroups().addUser("three");
        this.backdoor.usersAndGroups().addUserToGroup("one", "platform-users");
        this.backdoor.usersAndGroups().addUserToGroup("two", "platform-users");
        this.backdoor.usersAndGroups().addUserToGroup("three", "platform-users");
        this.openCreateUserPage();
        Assert.assertTrue((boolean)this.hasUserLimitReachedWarningForApplication("jira-core"));
        this.assertHasCheckbox("jira-func-test");
        MatcherAssert.assertThat(this.parseApplicationKeys(ParseApplicationKeysSelection.ALL_KEYS), (Matcher)Matchers.contains((Object[])new String[]{"jira-func-test", "jira-core"}));
    }

    @Test
    public void testCreateUserOverSeatLimitInOneRoleDoesntDrainCore() {
        this.backdoor.usersAndGroups().addGroup("platform-users");
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{"platform-users", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"platform-users"}));
        this.backdoor.usersAndGroups().addGroup("test-users");
        this.backdoor.applicationRoles().putRoleAndSetDefault("jira-func-test", "test-users");
        this.backdoor.usersAndGroups().addUser("one");
        this.backdoor.usersAndGroups().addUser("two");
        this.backdoor.usersAndGroups().addUser("three");
        this.backdoor.usersAndGroups().addUserToGroup("one", "platform-users");
        this.backdoor.usersAndGroups().addUserToGroup("two", "platform-users");
        this.backdoor.usersAndGroups().addUserToGroup("three", "platform-users");
        this.backdoor.usersAndGroups().addUserToGroup("one", "test-users");
        this.backdoor.usersAndGroups().addUserToGroup("two", "test-users");
        this.backdoor.usersAndGroups().addUserToGroup("three", "test-users");
        this.openCreateUserPage();
        Assert.assertTrue((boolean)this.hasUserLimitReachedWarningForApplication("jira-func-test"));
        this.assertHasCheckbox("jira-core");
        MatcherAssert.assertThat(this.parseApplicationKeys(ParseApplicationKeysSelection.ALL_KEYS), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"jira-func-test", "jira-core"}));
    }

    private List<String> parseApplicationKeys(ParseApplicationKeysSelection applicationKeysSelection) {
        CssLocator css = this.locator.css(".application-picker .application, .application-picker .application-warning");
        Node[] nodes = css.getNodes();
        return (List)Arrays.asList(nodes).stream().filter(node -> {
            Node checkedAttribute = node.getAttributes().getNamedItem("checked");
            return applicationKeysSelection == ParseApplicationKeysSelection.ALL_KEYS || checkedAttribute != null && StringUtils.equals((CharSequence)"checked", (CharSequence)checkedAttribute.getTextContent());
        }).map(node -> node.getAttributes().getNamedItem("data-key").getTextContent()).collect(CollectorsUtil.toImmutableList());
    }

    private void openCreateUserPage() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
    }

    static enum ParseApplicationKeysSelection {
        ALL_KEYS,
        SELECTED_KEYS;

    }
}

