/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.license.TestCreateUserHelper;
import com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@LoginAs(user="admin")
public class TestCreateUserSingleApplicationInstance
extends TestCreateUserHelper {
    private static final String PLATFORM_GROUP = "platform-users";
    private static final String SOFTWARE_GROUP = "software-users";
    private static final String ADMIN_GROUP = "jira-administrators";

    @Test
    public void testShouldCreateUserAndAddToGlobalUsePermissionGroupLegacy() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        this.createUser("one");
        this.assertUserInGroups("one", "jira-users");
    }

    @Test
    public void testShouldCreateUserAndAddToAppDefaultGroup() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        this.backdoor.usersAndGroups().addGroup(PLATFORM_GROUP);
        this.backdoor.usersAndGroups().addGroup(SOFTWARE_GROUP);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP, SOFTWARE_GROUP, ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP, SOFTWARE_GROUP}));
        this.createUser("one");
        this.assertUserInGroups("one", PLATFORM_GROUP, SOFTWARE_GROUP);
    }

    @Test
    public void testShouldWarnAndCreateUserWhenRoleHasNoDefaultGroups() {
        this.backdoor.restoreBlankInstance(LicenseKeys.CORE_ROLE_DC);
        this.backdoor.usersAndGroups().addGroup(PLATFORM_GROUP);
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-core", Sets.newHashSet((Object[])new String[]{PLATFORM_GROUP, ADMIN_GROUP}), Sets.newHashSet());
        this.populateCreateUserForm("user");
        Assert.assertTrue((boolean)this.hasNoDefaultGroupWarningForApplication("jira-core"));
        this.tester.submit("Create");
        this.assertUserNotInAnyGroups("user");
    }

    @Test
    public void testShouldWarnUserThatLicenseLimitHasBeenReachedAndAllowAdminToCreateUser() {
        this.backdoor.restoreBlankInstance(LicenseKeys.TEST_ROLE_3_USERS_DC);
        this.backdoor.usersAndGroups().addGroup("test-users");
        this.backdoor.applicationRoles().putRoleWithDefaults("jira-func-test", Sets.newHashSet((Object[])new String[]{"test-users", ADMIN_GROUP}), Sets.newHashSet((Object[])new String[]{"test-users"}));
        for (int i = 1; i < 3; ++i) {
            this.createUser("user" + i);
            this.assertUserInGroups("user" + i, "test-users");
        }
        this.populateCreateUserForm("limitReached");
        Assert.assertTrue((boolean)this.hasUserLimitReachedWarningForApplication("jira-func-test"));
        this.tester.submit("Create");
        this.assertUserNotInAnyGroups("limitReached");
    }
}

