/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.test.util.lic.License;
import com.atlassian.jira.webtests.LicenseKeys;
import com.atlassian.jira.webtests.ztests.license.TestCreateUserHelper;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.LICENSING})
@RestoreBlankInstance
@LoginAs(user="admin")
public class TestUserLimitedLicense
extends TestCreateUserHelper {
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void disableContactAdminForm() {
        this.backdoor.generalConfiguration().setContactAdminFormOff();
    }

    @Test
    public void testCreateIssueOverLicenseLimit_Starter() {
        this.testCreateIssueOverLicenseLimit(LicenseKeys.STARTER_DC);
    }

    @Test
    public void testCreateIssueOverLicenseLimit_CommercialLimited() {
        this.testCreateIssueOverLicenseLimit(LicenseKeys.COMMERCIAL_LIMITED_DC);
    }

    private void testCreateIssueOverLicenseLimit(License license) {
        this.administration.switchToLicense(license);
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "A little bug");
        this.tester.submit("Create");
        this.tester.assertTextPresent("A little bug");
        this.tester.assertTextPresent("Details");
        this.backdoor.usersAndGroups().addUser("bob");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "This is a big one!");
        this.tester.submit("Create");
        this.tester.assertTextPresent("This is a big one!");
        this.tester.assertTextPresent("Details");
        this.administration.restoreData("TestStarterLicenseTooManyUsers.xml");
        this.administration.switchToLicense(license);
        if (this.tester.getDialog().isLinkPresent("leave_admin")) {
            this.tester.clickLink("leave_admin");
        }
        this.tester.clickLink("create_link");
        this.textAssertions.assertTextPresent(this.locator.css(".aui-message"), "You are not able to create new issues because your Jira application license's user limit has been exceeded. Please contact your Jira administrators.");
        String atlToken = this.page.getXsrfToken();
        this.tester.gotoPage("/secure/CreateIssueDetails.jspa?atl_token=" + atlToken);
        this.tester.assertTextPresent("You do not have permission to create issues in this project.");
        this.tester.assertElementNotPresent("details-module");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("editgroups_michael");
        this.tester.selectOption("groupsToLeave", "jira-users");
        this.tester.submit("leave");
        TestUserLimitedLicense.goToCreateIssueFormAndRetryIfFailed(this.navigation);
        this.tester.setFormElement("summary", "Let's create another bug!");
        this.tester.submit("Create");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Let's create another bug!");
        this.tester.assertTextPresent("Details");
    }

    @Test
    public void testAddUserOverLimitShowsWarning_Starter() {
        this.testAddUserOverLimitShowsWarning(LicenseKeys.STARTER_DC);
    }

    @Test
    public void testAddUserOverLimitShowsWarning_CommercialLimited() {
        this.testAddUserOverLimitShowsWarning(LicenseKeys.COMMERCIAL_LIMITED_DC);
    }

    private void testAddUserOverLimitShowsWarning(License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("devman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.addUsersWhileUnderTheLimit("fatman");
        this.navigation.gotoAdminSection(Navigation.AdminSection.CREATE_USER);
        this.tester.setFormElement("username", "barney");
        this.tester.setFormElement("password", "barney");
        this.tester.setFormElement("fullname", "Barney");
        this.tester.setFormElement("email", "barney@example.com");
        this.tester.submit("Create");
        this.gotoViewUserPage("barney");
        this.textAssertions.assertTextNotPresent(new WebPageLocator(this.tester), "jira-users");
        this.navigation.logout();
        this.navigation.gotoDashboard();
        this.navigation.loginAttempt("barney", "barney");
        this.tester.assertTextPresent("You do not have a permission to log in");
    }

    private void addUsersWhileUnderTheLimit(String userName) {
        this.createUser(userName);
        this.assertUserInGroups(userName, "jira-users");
    }

    @Test
    public void testSignupOverLicenseLimit_Starter() {
        this.testSignupOverLicenseLimit(LicenseKeys.STARTER_DC);
    }

    @Test
    public void testSignupOverLicenseLimit_CommercialLimited() {
        this.testSignupOverLicenseLimit(LicenseKeys.COMMERCIAL_LIMITED_DC);
    }

    private void testSignupOverLicenseLimit(License license) {
        this.administration.switchToLicense(license);
        this.addUsersWhileUnderTheLimit("dudeman");
        this.addUsersWhileUnderTheLimit("prodman");
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.setFormElement("username", "devman");
        this.tester.setFormElement("password", "devman");
        this.tester.setFormElement("fullname", "Devman");
        this.tester.setFormElement("email", "devman@example.com");
        this.tester.submit();
        this.assertions.assertNodeHasText(this.locator.css("#content .aui-message.aui-message-success"), "You have successfully signed up. If you forget your password, you can request a new one.");
        this.tester.clickLinkWithText("Click here to log in");
        this.navigation.login("devman", "devman");
        Assert.assertEquals((Object)"Devman", (Object)this.navigation.userProfile().userName());
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLink("signup");
        this.tester.assertTextPresent("We can't sign you up right now as there are too many users in the system. You could let the administrator know you can't sign up right now or try again later.");
        this.navigation.sendPostRequest("/secure/Signup.jspa", new ByteArrayInputStream(("atl_token=" + this.page.getXsrfToken()).getBytes(StandardCharsets.US_ASCII)));
        this.tester.assertTextPresent("We can't sign you up right now as there are too many users in the system. You could let the administrator know you can't sign up right now or try again later.");
    }

    public static void goToCreateIssueFormAndRetryIfFailed(Navigation navigation) {
        int maxRetries = 10;
        long sleepBetweenRetriesMillis = 1000L;
        int retries = 0;
        while (true) {
            try {
                navigation.issue().goToCreateIssueForm(null, null);
            }
            catch (AssertionError e) {
                Assert.assertEquals((String)"Trying to handle assertion error", (Object)"Expected text not found in response: [CreateIssueDetails.jspa]", (Object)((Throwable)((Object)e)).getMessage());
                if (retries < 10) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                } else {
                    throw e;
                }
                ++retries;
                continue;
            }
            break;
        }
    }
}

