/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
public class TestAtlassianSalJmxMetrics
extends BaseJmxMetricsTest {
    @Rule
    public final BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);
    private static final MBean[] REST_REQUEST_MBEANS = new MBean[]{MBean.access$000("GET"), MBean.access$000("POST")};
    private static final String SLOW_QUERY_TASK = "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation";
    private static final String TRANSACTIONAL_EXECUTOR_TASK = "com.atlassian.diagnostics.noisyneighbour.operations.database.entity.SALTransactionalExecutorOperation";
    private static final MBean[] TRANSACTIONAL_EXECUTOR_MBEANS = new MBean[]{MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-jira-plugin", "active", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-jira-plugin", "duration", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-jira-plugin", "max", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-jira-plugin", null, null, "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", "active", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.entity.SALTransactionalExecutorOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", "active", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", "duration", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.entity.SALTransactionalExecutorOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", "duration", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", "max", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.entity.SALTransactionalExecutorOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", "max", "current", "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", null, null, "com.atlassian.diagnostics.noisyneighbour.operations.database.entity.SALTransactionalExecutorOperation"), MBean.access$100("com.atlassian.diagnostics.noisy-neighbour-plugin", null, null, "com.atlassian.diagnostics.noisyneighbour.operations.database.slowquery.SlowQueryOperation")};
    private static final String TRANSACTIONAL_EXECUTOR_OPERATION = "SAL_TRANSACTIONAL_EXECUTOR";
    private static final String REST_REQUESTS_OPERATION = "SEND_REST_REQUESTS";

    @Test
    @EnableAnalytics
    public void salRestRequests_shouldEmitAnalyticsEvents() {
        this.startNoisyNeighbourOperation(REST_REQUESTS_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)"http.sal.request"), (Matcher)Matchers.hasEntry((Object)"tags.pluginKeyAtCreation", (Object)"com.atlassian.diagnostics.noisy-neighbour-plugin"), (Matcher)Matchers.hasEntry((Object)"type", (Object)"timer"));
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
    }

    @Test
    @EnableAnalytics
    public void salTransactionalExecutor_shouldEmitAnalyticsEvents() {
        this.startNoisyNeighbourOperation(TRANSACTIONAL_EXECUTOR_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)"db.sal.transactionalExecutor"), (Matcher)Matchers.hasEntry((Object)"tags.invokerPluginKey", (Object)"com.atlassian.diagnostics.noisy-neighbour-plugin"), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"tags.taskName"), (Matcher)Matchers.startsWith((String)TRANSACTIONAL_EXECUTOR_TASK)), (Matcher)Matchers.hasEntry((Object)"type", (Object)"timer"));
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
    }

    @Test
    @EnableAnalytics
    public void assertLongRunningTimerMetric_shouldHaveMaxAttribute() {
        this.startNoisyNeighbourOperation(TRANSACTIONAL_EXECUTOR_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher[])new Matcher[]{Matchers.hasEntry((Matcher)Matchers.is((Object)"name"), (Matcher)Matchers.is((Object)"db.sal.transactionalExecutor"))});
        Map<?, ?> event = this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
        MatcherAssert.assertThat((Object)((Double)event.get("max")), (Matcher)Matchers.any(Double.class));
    }

    @Test
    public void salRestRequests_shouldEmitMetrics() {
        this.assertMetrics(REST_REQUESTS_OPERATION, REST_REQUEST_MBEANS);
    }

    @Test
    public void salTransactionalExecutor_shouldEmitMetrics() {
        this.assertMetrics(TRANSACTIONAL_EXECUTOR_OPERATION, TRANSACTIONAL_EXECUTOR_MBEANS);
    }

    private void assertMetrics(String noisyNeighbourOperation, MBean[] expectedMBeans) {
        this.startNoisyNeighbourOperation(noisyNeighbourOperation);
        this.tryAssertUntil(() -> {
            List<String> jmxBeans = this.getJmxBeans();
            List mBeans = jmxBeans.stream().map(x$0 -> MBean.parse(x$0)).collect(Collectors.toList());
            MatcherAssert.assertThat(mBeans, (Matcher)CoreMatchers.hasItems((Object[])expectedMBeans));
        });
    }

    private static class MBean {
        private final Map<String, String> properties = new TreeMap<String, String>();

        private static MBean restRequestMBean(String httpMethod) {
            return new MBean().setProperty("com.atlassian.jira:category00", "http").setProperty("category01", "rest").setProperty("name", "request").setProperty("tag.action", httpMethod).setProperty("tag.fromPluginKey", "com.atlassian.diagnostics.noisy-neighbour-plugin").setProperty("tag.path", "/rest/noisyneighbour/1.0").setProperty("type", "metrics");
        }

        private static MBean transactionalExecutorMBean(String invokerPluginKey, @Nullable String statistic, @Nullable String subCategory, String taskName) {
            return new MBean().setProperty("com.atlassian.jira:category00", "db").setProperty("category01", "sal").setProperty("name", "transactionalExecutor").setProperty("tag.invokerPluginKey", invokerPluginKey).setProperty("tag.statistic", statistic).setProperty("tag.subCategory", subCategory).setProperty("tag.taskName", taskName).setProperty("type", "metrics");
        }

        private static MBean parse(String commaSeparatedKeyValuePairs) {
            MBean mBean = new MBean();
            for (String pair : StringUtils.split((String)commaSeparatedKeyValuePairs, (String)", ")) {
                String[] keyValuePair = StringUtils.split((String)pair, (char)'=');
                if (keyValuePair.length != 2) continue;
                String key = keyValuePair[0];
                String value = StringUtils.substringBefore((String)keyValuePair[1], (String)"$$");
                mBean.setProperty(key, value);
            }
            return mBean;
        }

        private MBean() {
        }

        private MBean setProperty(String key, String value) {
            if (StringUtils.isNotBlank((CharSequence)value)) {
                this.properties.put(key, value);
            }
            return this;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            MBean mBean = (MBean)other;
            return this.properties.equals(mBean.properties);
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "MBean{properties=" + this.properties + '}';
        }

        static /* synthetic */ MBean access$000(String x0) {
            return MBean.restRequestMBean(x0);
        }

        static /* synthetic */ MBean access$100(String x0, String x1, String x2, String x3) {
            return MBean.transactionalExecutorMBean(x0, x1, x2, x3);
        }
    }
}

