/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.metrics;

import com.atlassian.jira.functest.framework.EnableAnalytics;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.metrics.BaseJmxMetricsTest;
import com.jayway.awaitility.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.REST})
@RestoreBlankInstance
public class TestIssueReIndexJmxMetrics
extends BaseJmxMetricsTest {
    private static final String EXPECTED_JMX_METRIC = "com.atlassian.jira:category00=issue,name=reindexing,tag.invokerPluginKey=com.atlassian.diagnostics.noisy-neighbour-jira-plugin,type=metrics";
    private static final String ISSUE_INDEX_MANAGER_OPERATION = "ISSUE_INDEX_MANAGER";
    private static final String ISSUE_INDEXING_SERVICE_OPERATION = "ISSUE_INDEXING_SERVICE";
    private static final Duration METRICS_TIMEOUT = new Duration(3L, TimeUnit.SECONDS);
    private static final String PROJECT_KEY = "HSP";
    @Rule
    public final BaseJmxMetricsTest.JmxNoisyNeighbourRule jmxNoisyNeighbourRule = new BaseJmxMetricsTest.JmxNoisyNeighbourRule(this);

    @Before
    public void setup() {
        this.backdoor.issues().createIssue(PROJECT_KEY, "foo blah blah blah");
    }

    @Test
    @EnableAnalytics
    public void issueReIndexWithIndexingService_shouldEmitAnalyticsEvents() {
        this.startNoisyNeighbourOperation(ISSUE_INDEXING_SERVICE_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)"issue.reindexing"), (Matcher)Matchers.hasEntry((Object)"tags.invokerPluginKey", (Object)"com.atlassian.diagnostics.noisy-neighbour-jira-plugin"));
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
    }

    @Test
    @EnableAnalytics
    public void issueReIndexWithIndexManager_shouldEmitAnalyticsEvents() {
        this.startNoisyNeighbourOperation(ISSUE_INDEX_MANAGER_OPERATION);
        Matcher eventMatcher = Matchers.allOf((Matcher)Matchers.hasEntry((Object)"name", (Object)"issue.reindexing"), (Matcher)Matchers.hasEntry((Object)"tags.invokerPluginKey", (Object)"com.atlassian.diagnostics.noisy-neighbour-jira-plugin"));
        this.awaitFirstAnalyticsEvent((Matcher<Map<String, String>>)eventMatcher);
    }

    @Test
    public void issueReIndexWithIndexingService_shouldEmitMetrics() {
        this.startNoisyNeighbourOperation(ISSUE_INDEXING_SERVICE_OPERATION);
        this.waitUntil(() -> this.getJmxBeans().contains(EXPECTED_JMX_METRIC), METRICS_TIMEOUT);
    }

    @Test
    public void issueReIndexWithIndexManager_shouldEmitMetrics() {
        this.startNoisyNeighbourOperation(ISSUE_INDEX_MANAGER_OPERATION);
        this.waitUntil(() -> this.getJmxBeans().contains(EXPECTED_JMX_METRIC), METRICS_TIMEOUT);
    }
}

