/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS})
@LoginAs(user="admin")
public class TestAddPermission
extends BaseJiraFuncTest {
    private static final String PROJECT_PERMISSION_KEY = "func.test.project.permission";
    private static final String PROJECT_PERMISSION_KEY_COMPLETE = "com.atlassian.jira.dev.func-test-plugin:func.test.project.permission";
    private static final String PERMISSION_SCHEMES_SINGLE_PAGE_DISABLED = "com.atlassian.jira.permission-schemes.single-page-ui.disabled";
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite(PERMISSION_SCHEMES_SINGLE_PAGE_DISABLED);
    }

    @Test
    public void testValidationOnPermission() {
        this.administration.permissionSchemes().defaultScheme();
        this.tester.clickLinkWithText("Grant permission");
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        this.textAssertions.assertTextPresent("Errors");
        this.textAssertions.assertTextPresent("You must select a permission to add.");
    }

    @Test
    public void testCannotAddEntryToDisabledPermission() {
        this.backdoor.plugins().enablePluginModule(PROJECT_PERMISSION_KEY_COMPLETE);
        this.administration.permissionSchemes().defaultScheme();
        this.tester.clickLink("add_perm_func.test.project.permission");
        this.tester.checkCheckbox("type", "group");
        this.backdoor.plugins().disablePluginModule(PROJECT_PERMISSION_KEY_COMPLETE);
        this.tester.submit(" Add ");
        this.textAssertions.assertTextPresent("Errors");
        this.textAssertions.assertTextPresent("Permission with key &#39;func.test.project.permission&#39; doesn&#39;t exist.");
    }
}

