/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.FuncTestRestClient;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.webtests.LicenseKeys;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.meterware.httpunit.WebResponse;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.DEV_MODE, Category.PLATFORM_COMPATIBILITY})
@LoginAs(user="admin")
public class TestPlatformCompatibility
extends BaseJiraFuncTest {
    public static final String PROJECT_NAME = "tautomerism";
    public static final String ISSUE_SUMMARY = "jira blah blah";
    public static final String ISSUE_DESCRIPTION = "ho ho ho and a bottle of rum";
    private static final ImmutableMap<String, String> CTK_PROPERTIES = ImmutableMap.builder().put((Object)"platform.ctk.test.admin.username", (Object)"admin").put((Object)"platform.ctk.test.admin.password", (Object)"admin").put((Object)"platform.ctk.test.admin.fullname", (Object)"Administrator").put((Object)"platform.ctk.test.validlicense", (Object)LicenseKeys.OPEN_SOURCE_DC.getLicenseString()).put((Object)"platform.ctk.test.search.term", (Object)"jira blah blah").put((Object)"platform.ctk.test.search.matches", (Object)"ho ho ho and a bottle of rum").build();
    private static final String PLATFORM_CTK_PLUGIN_KEY = "com.atlassian.refapp.ctk";
    private static final String WEBSUDO_PROPERTY = "jira.websudo.is.disabled";
    @Inject
    private FuncTestRestClient restClient;
    private boolean shouldRun;
    private Boolean webSudoEnabled = null;
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;

    @Before
    public void setUpTest() {
        this.administration.restoreBlankInstance();
        this.shouldRun = this.isPlatformCtkPluginInstalled();
        if (this.shouldRun) {
            this.administration.project().addProject(PROJECT_NAME, "TTM", "admin");
            this.navigation.issue().createIssue(PROJECT_NAME, "Bug", ISSUE_SUMMARY, (Map<String, String[]>)ImmutableMap.of((Object)"description", (Object)new String[]{ISSUE_DESCRIPTION}));
            this.administration.reIndex();
            this.navigation.logout();
            this.webSudoEnabled = Boolean.valueOf(this.backdoor.systemProperties().getProperty(WEBSUDO_PROPERTY));
            this.backdoor.systemProperties().setProperty(WEBSUDO_PROPERTY, "false");
            for (String property : CTK_PROPERTIES.keySet()) {
                this.backdoor.systemProperties().setProperty(property, (String)CTK_PROPERTIES.get((Object)property));
            }
            this.backdoor.darkFeatures().enableForSite("foo");
        }
    }

    @After
    public void tearDownTest() {
        if (this.shouldRun) {
            for (String property : CTK_PROPERTIES.keySet()) {
                this.backdoor.systemProperties().unsetProperty(property);
            }
            this.backdoor.systemProperties().setProperty(WEBSUDO_PROPERTY, this.webSudoEnabled.toString());
        }
    }

    @Test
    public void testCtk() throws IOException, SAXException, JSONException {
        if (this.shouldRun) {
            this.logger.log((Object)"found platform-ctk plugin. run it now!!");
            List<String> skipClasses = this.getSkippedClasses();
            if (skipClasses.size() == 0) {
                this.logger.log((Object)"No skipped test. Full suite will be executed.");
            } else {
                this.logger.log((Object)("Tests to be skipped: " + StringUtils.join(skipClasses, (String)"\n")));
            }
            String queryParams = this.buildQueryParams(Stream.concat(this.toQueryParam("outdir", this.getTestsOutputDirPath()), this.toQueryParams("excludes", skipClasses)));
            WebResponse response = this.restClient.GET("/rest/functest/1.0/junit/runTests?" + queryParams, (Map<String, String>)ImmutableMap.of((Object)"Accept", (Object)"application/json"));
            Assert.assertEquals((Object)"application/json", (Object)response.getContentType());
            Assert.assertEquals((Object)"UTF-8", (Object)response.getCharacterSet());
            JSONObject contents = new JSONObject(response.getText());
            int failures = Integer.parseInt(contents.getString("result"));
            if (failures > 0) {
                Assert.fail((String)("There were " + failures + " failures. See test output below.\n\n\n" + contents.getString("output")));
            }
        } else {
            this.logger.log((Object)"platform-ctk plugin not found. skipped the test");
        }
    }

    private Stream<String> toQueryParams(String paramName, List<String> skipClasses) {
        return skipClasses.stream().map(paramValues -> paramName + "=" + paramValues);
    }

    private Stream<String> toQueryParam(String paramName, String value) {
        return Stream.of(paramName + "=" + value);
    }

    private String buildQueryParams(Stream<String> params) {
        return params.collect(Collectors.joining("&"));
    }

    private List<String> getSkippedClasses() {
        String skips = System.getProperty("platform.ctk.skips");
        if (skips == null) {
            return Collections.emptyList();
        }
        return ImmutableList.copyOf((Object[])StringUtils.split((String)skips, (String)","));
    }

    private boolean isPlatformCtkPluginInstalled() {
        this.navigation.gotoAdmin();
        return this.administration.plugins().isPluginInstalled(PLATFORM_CTK_PLUGIN_KEY);
    }

    private String getTestsOutputDirPath() {
        File target = new File("target");
        if (target.exists()) {
            File outputDir = new File("target/ctk-test-reports/");
            return outputDir.getAbsolutePath();
        }
        return "ctk-test-reports";
    }
}

