/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.HtmlPage;
import com.atlassian.jira.functest.framework.RestoreBlankInstance;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST})
public class TestReportProblem
extends BaseJiraFuncTest {
    private static final String SUPPORT_TOOLS_PLUGIN_PATH = "/plugins/servlet/troubleshooting/view/";
    private static final String CONTACT_ADMIN_PATH = "/secure/ContactAdministrators!default.jspa";
    private static final String CREATE_ISSUE_PATH = "/secure/CreateIssue!default.jspa";
    private static final String JIRA_SHOW_CONTACT_ADMINISTRATORS_FORM = "jira.show.contact.administrators.form";
    @Inject
    private HtmlPage page;
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testReportProblemDoesNotRedirectToSupportToolsPluginForJiraAdmin() {
        try {
            this.navigation.login("admin", "admin");
            this.textAssertions.assertTextNotPresent(this.getReportProblemHref(), SUPPORT_TOOLS_PLUGIN_PATH);
        }
        finally {
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @Restore(value="TestWithSystemAdmin.xml")
    @SinceBuildRule.SinceBuild(buildNumber=78000)
    public void testReportProblemRedirectsToSupportToolsPluginForSysAdmin() {
        try {
            this.navigation.login("root", "root");
            this.textAssertions.assertTextPresent(this.getReportProblemHref(), SUPPORT_TOOLS_PLUGIN_PATH);
        }
        finally {
            this.navigation.login("root", "root");
            this.administration.restoreBlankInstance();
        }
    }

    @Test
    @RestoreBlankInstance
    public void testReportProblemRedirectsToContactAdminWhenEnabledForLoggedInUsers() {
        try {
            this.setShowContactAdminForm(true);
            this.navigation.login("fred", "fred");
            this.textAssertions.assertTextPresent(this.getReportProblemHref(), CONTACT_ADMIN_PATH);
        }
        finally {
            this.setShowContactAdminForm(false);
        }
    }

    @Test
    @RestoreBlankInstance
    public void testReportProblemRedirectsToContactAdminWhenEnabledForLoggedOutUsers() {
        this.setShowContactAdminForm(true);
        try {
            this.navigation.logout();
            this.textAssertions.assertTextPresent(this.getReportProblemHref(), CONTACT_ADMIN_PATH);
        }
        finally {
            this.setShowContactAdminForm(false);
        }
    }

    @Test
    @RestoreBlankInstance
    public void testReportProblemRedirectsToCreateIssueWhenContactAdminDisabledForLoggedInUsers() {
        this.setShowContactAdminForm(false);
        this.navigation.login("fred", "fred");
        this.textAssertions.assertTextPresent(this.getReportProblemHref(), CREATE_ISSUE_PATH);
    }

    @Test
    @RestoreBlankInstance
    public void testReportProblemRedirectsToCreateIssueWhenContactAdminDisabledForLoggedOutUsers() {
        this.navigation.logout();
        this.textAssertions.assertTextPresent(this.getReportProblemHref(), CREATE_ISSUE_PATH);
    }

    private String getReportProblemHref() {
        return this.page.getFooter().getReportProblemLink().getURLString();
    }

    private void setShowContactAdminForm(boolean show) {
        this.backdoor.applicationProperties().setOption(JIRA_SHOW_CONTACT_ADMINISTRATORS_FORM, show);
    }
}

