/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.dom.SneakyDomExtractor;
import com.google.common.collect.ImmutableList;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@WebTest(value={Category.FUNC_TEST, Category.I18N})
public class TestWebResourceLinks
extends BaseJiraFuncTest {
    private String previousUserLanguage;

    @Before
    public void setUp() throws Exception {
        this.previousUserLanguage = this.backdoor.userProfile().getUserLanguage("admin");
    }

    @After
    public void tearDown() {
        this.backdoor.userProfile().changeUserLanguage("admin", this.previousUserLanguage);
    }

    @Test
    public void shouldBeStableAcrossLanguagesForCss() {
        this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
        this.navigation.gotoDashboard();
        Set<String> cssLinksEnglish = this.getCssLinks();
        this.backdoor.userProfile().changeUserLanguage("admin", "de_DE");
        this.navigation.gotoDashboard();
        Set<String> cssLinksGerman = this.getCssLinks();
        MatcherAssert.assertThat((String)"Loaded different set of css", cssLinksEnglish, (Matcher)Matchers.equalTo(cssLinksGerman));
    }

    @Test
    public void shouldBeStableAcrossLanguagesForJavaScript() {
        this.backdoor.userProfile().changeUserLanguage("admin", "en_UK");
        this.navigation.gotoDashboard();
        Set<String> jsLinksEnglish = this.getJavaScriptLinks();
        this.backdoor.userProfile().changeUserLanguage("admin", "de_DE");
        this.navigation.gotoDashboard();
        Set<String> jsLinksGerman = this.getJavaScriptLinks();
        MatcherAssert.assertThat((String)"Loaded different set of javaScript", jsLinksEnglish, (Matcher)Matchers.equalTo(jsLinksGerman));
    }

    private Set<String> getCssLinks() {
        return this.getUrls("link", "href", attr -> "stylesheet".equals(attr.getNamedItem("rel").getTextContent()));
    }

    private Set<String> getJavaScriptLinks() {
        return this.getUrls("script", "src", ignore -> true);
    }

    private Set<String> getUrls(String tagName, String urlAttribute, Predicate<NamedNodeMap> filter) {
        Document dom = SneakyDomExtractor.getDOM(this.tester);
        Stream<Node> links = this.getElementsByTagNameStream(dom, tagName);
        return (Set)links.map(Node::getAttributes).filter(filter).filter(attr -> attr.getNamedItem(urlAttribute) != null).map(attr -> attr.getNamedItem(urlAttribute).getTextContent()).collect(CollectorsUtil.toImmutableSet());
    }

    private Stream<Node> getElementsByTagNameStream(Document dom, String tagName) {
        NodeList elementsByTagName = dom.getElementsByTagName(tagName);
        int linksLength = elementsByTagName.getLength();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < linksLength; ++i) {
            builder.add((Object)elementsByTagName.item(i));
        }
        return builder.build().stream();
    }
}

