/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING, Category.ISSUES})
@LoginAs(user="admin")
public class TestIssueNavigatorEncoding
extends BaseJiraFuncTest {
    @Inject
    private Administration administration;
    @Inject
    private TextAssertions textAssertions;

    @Test
    public void testCustomFieldValuesThatShouldBeEncoded() {
        this.administration.restoreData("TestXssCustomFields.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.login("admin", "admin");
        this.navigation.issueNavigator().createSearch("");
        WebPageLocator pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.textAssertions.assertTextPresent(pageLocator.getHTML(), "&lt;xxx&gt;delta&lt;/xxx&gt;");
        this.tester.clickLinkWithText("HSP-1");
        pageLocator = new WebPageLocator(this.tester);
        this.textAssertions.assertTextNotPresent(pageLocator.getHTML(), "<xxx>delta</xxx>");
        this.textAssertions.assertTextPresent(pageLocator.getHTML(), "&lt;xxx&gt;delta&lt;/xxx&gt;");
    }

    @Test
    public void testCustomFieldLabelsEncoded() {
        this.administration.restoreData("TestIssueNavigatorCustomFieldLabelXss.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoPage("/issues/?filter=10030");
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
        this.navigation.issueNavigator().displayAllIssues();
        this.assertCustomFieldLabelEncoded(new WebPageLocator(this.tester));
    }

    private void assertCustomFieldLabelEncoded(Locator locator) {
        this.textAssertions.assertTextPresent(locator.getHTML(), "&quot;&gt;&lt;iframe src=&quot;http://www.google.com&quot;&gt;&lt;/iframe&gt;&lt;a href=&quot;#&quot; rel=&quot;");
        this.textAssertions.assertTextNotPresent(locator.getHTML(), "\"><iframe src=\"http://www.google.com\"></iframe><a href=\"#\" rel=\"");
    }
}

