/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.meterware.httpunit.WebLink;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@Restore(value="TestSearchRequestViewsAndIssueViews.xml")
@LoginAs(user="admin")
public class TestIssueNavigatorFullContentView
extends AbstractTestIssueNavigatorView {
    private URL baseUrl;
    @Inject
    private TimeTracking timeTracking;

    @Before
    public void setUpTest() {
        this.baseUrl = this.getEnvironmentData().getBaseUrl();
    }

    @Test
    public void testFullContentViewItem1() {
        this.goToView("status=Open");
        AbstractTestIssueNavigatorView.Item item = this.item1;
        this.verifyCommons(item);
        String responseText = this.tester.getDialog().getResponseText();
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Affects Version/s", "None");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Fix Version/s", "New Version 5");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "duplicates", "HSP-10");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "HSP-10", "Big 01");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Big 01", "Resolved");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "CascadingSelectField", "value 01");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "CascadingSelectField", "value 013");
        this.assertions.getTextAssertions();
        this.tester.assertLinkPresentWithText("New Version 5");
        this.assertLinkPresent(new String[]{this.baseUrl + "/issues/", "jql=project%3D10000%20AND%20%22fixVersion%22%3D10000%20ORDER%20BY%20priority%20ASC"});
        this.assertUserProfileLink(item.getAttribute("assignee"), "dev");
        this.tester.assertLinkPresentWithText("HSP-10");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-10", true);
        this.tester.assertLinkNotPresentWithText("HSP-11");
        this.tester.assertLinkNotPresentWithText("HSP-12");
        this.assertSingleVersionPicker("New Version 5", "New+Version+5");
        this.assertVersionPicker("New Version 2", "New+Version+2");
        this.assertVersionPicker("New Version 4", "New+Version+4");
    }

    @Test
    public void testFullContentViewItem1DaysTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.testFullContentViewItem1();
    }

    @Test
    public void testFullContentViewItem1HoursTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.testFullContentViewItem1();
    }

    protected void goToView(String jql) {
        try {
            this.tester.gotoPage("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?jqlQuery=" + URLEncoder.encode(jql, "UTF-8") + "&tempMax=1000");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    public void testFullContentViewItem2() {
        this.goToView("status=\"In Progress\"");
        AbstractTestIssueNavigatorView.Item item = this.item2;
        this.verifyCommons(item);
        String responseText = this.tester.getDialog().getResponseText();
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Affects Version/s", "New Version 2");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Fix Version/s", "New Version 4");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "duplicates", "HSP-10");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "HSP-10", "Big 01");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Big 01", "Resolved");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "CascadingSelectField", "value 05");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "ProjectPickerField", "homosapien");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/BrowseProject.jspa", "id=10000"});
        this.tester.assertLinkPresentWithText("New Version 4");
        this.assertLinkPresent(new String[]{this.baseUrl + "/issues/", "jql=project%3D10000%20AND%20%22fixVersion%22%3D10001%20ORDER%20BY%20priority%20ASC"});
        this.assertUserProfileLink(item.getAttribute("assignee"), "admin");
        this.tester.assertLinkPresentWithText("HSP-10");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-10", true);
        this.tester.assertLinkNotPresentWithText("HSP-11");
        this.tester.assertLinkNotPresentWithText("HSP-12");
        this.assertSingleVersionPicker("New Version 5", "New+Version+5");
        this.assertVersionPicker("New Version 5", "New+Version+5");
    }

    @Test
    public void testFullContentViewItem2DaysTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.testFullContentViewItem2();
    }

    @Test
    public void testFullContentViewItem2HoursTimeFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.testFullContentViewItem2();
    }

    @Test
    public void testFullContentViewItem3() {
        this.goToView("status=\"Resolved\"");
        AbstractTestIssueNavigatorView.Item item = this.item3;
        this.verifyCommons(item);
        String responseText = this.tester.getDialog().getResponseText();
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Affects Version/s", "New Version 4");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Fix Version/s", "New Version 5");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "duplicates", "HSP-11");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "HSP-11", "Minor Bug 01");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Minor Bug 01", "In Progress");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "is duplicated by", "HSP-11");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "HSP-11", "Minor Bug 01");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Minor Bug 01", "In Progress");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "is duplicated by", "HSP-12");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "HSP-12", "Feature 00");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Feature 00", "Open");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "CascadingSelectField", "value 01");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "value 01", "value 013");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "GroupPickerField", "jira-developers");
        this.tester.assertLinkPresentWithText("New Version 4");
        this.assertLinkPresent(new String[]{this.baseUrl + "/issues/", "jql=project%3D10000%20AND%20%22affectedVersion%22%3D10001%20ORDER%20BY%20priority%20ASC"});
        this.tester.assertLinkPresentWithText("New Version 5");
        this.assertLinkPresent(new String[]{this.baseUrl + "/issues/", "jql=project%3D10000%20AND%20%22fixVersion%22%3D10000%20ORDER%20BY%20priority%20ASC"});
        this.assertUserProfileLink(item.getAttribute("assignee"), "dev");
        this.tester.assertLinkNotPresentWithText("HSP-10");
        this.tester.assertLinkPresentWithText("HSP-11");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-11", true);
        this.tester.assertLinkPresentWithText("HSP-12");
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/HSP-12", true);
        this.assertSingleVersionPicker("New Version 5", "New+Version+5");
        this.assertVersionPicker("New Version 2", "New+Version+2");
        this.assertVersionPicker("New Version 4", "New+Version+4");
    }

    @Test
    public void testFullContentViewItem3DaysFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.testFullContentViewItem3();
    }

    @Test
    public void testFullContentViewItem3HoursFormat() {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.testFullContentViewItem3();
    }

    @Test
    @Restore(value="TestSearchRequestViewsAndIssueViewsWithPriorityNull.xml")
    public void testFullContentViewItem1NullPriority() {
        this.goToView("status=\"Resolved\"");
        this.assertions.getTextAssertions().assertTextNotPresent("Priority");
    }

    private void assertCustomField(AbstractTestIssueNavigatorView.Item item, String title, String cfName) {
        AbstractTestIssueNavigatorView.CustomField customField = item.getCustomFieldByName(cfName);
        if (customField == null) {
            this.assertions.getTextAssertions().assertTextNotPresent(title);
        } else {
            this.assertions.getTextAssertions().assertTextPresent(title);
        }
    }

    private void assertAttribute(AbstractTestIssueNavigatorView.Item item, String title, String attName) {
        String attribute = item.getAttribute(attName);
        if (attribute == null || attribute.length() == 0) {
            this.assertions.getTextAssertions().assertTextNotPresent(title);
        } else {
            this.assertions.getTextAssertions().assertTextPresent(title);
        }
    }

    private void assertProjectPickerField(AbstractTestIssueNavigatorView.Item item) {
        String title = "ProjectPickerField";
        AbstractTestIssueNavigatorView.CustomField customField = item.getCustomFieldByName("ProjectPickerField");
        if (customField == null) {
            this.assertions.getTextAssertions().assertTextNotPresent("ProjectPickerField");
        } else {
            this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), "ProjectPickerField", "homosapien");
            this.assertLinkPresent(new String[]{this.baseUrl + "/secure/BrowseProject.jspa", "id=10000"});
        }
    }

    private void assertCustomFieldValues(AbstractTestIssueNavigatorView.Item item, String title, String cfName) {
        AbstractTestIssueNavigatorView.CustomField customField = item.getCustomFieldByName(cfName);
        if (customField == null) {
            this.assertions.getTextAssertions().assertTextNotPresent(title);
        } else {
            List<AbstractTestIssueNavigatorView.CustomField.Value> values = customField.getValues();
            if (values != null) {
                for (AbstractTestIssueNavigatorView.CustomField.Value value : values) {
                    this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), title, value.getValue());
                }
            }
        }
    }

    private void verifyCommons(AbstractTestIssueNavigatorView.Item item) {
        this.assertions.getTextAssertions().assertTextPresent(item.getAttribute("key"));
        this.tester.assertLinkPresentWithText(item.getAttribute("summary"));
        this.assertLinkPresentWithUrl(this.baseUrl + "/browse/" + item.getAttribute("key"), false);
        String responseText = this.tester.getDialog().getResponseText();
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Created", "Updated");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Status", item.getAttribute("status"));
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Project", "homosapien");
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Type", item.getAttribute("type"));
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Priority", item.getAttribute("priority"));
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Reporter", item.getAttribute("reporter"));
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Assignee", item.getAttribute("assignee"));
        this.assertions.getTextAssertions().assertTextSequence(responseText, "Resolution", item.getAttribute("resolution"));
        this.tester.assertLinkPresentWithText("homosapien");
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/BrowseProject.jspa", "id=10000"});
        this.assertAttribute(item, "Description", "description");
        this.assertUserProfileLink(item.getAttribute("reporter"), "admin");
        if (this.timeFormat == TimeTracking.Format.DAYS) {
            this.assertTimeUnknownIfNotSet("Remaining Estimate", item.getAttribute("timeestimateDays"));
            this.assertTimeUnknownIfNotSet("Time Spent", item.getAttribute("timespentDays"));
            this.assertTimeUnknownIfNotSet("Original Estimate", item.getAttribute("timeoriginalestimateDays"));
        } else if (this.timeFormat == TimeTracking.Format.HOURS) {
            this.assertTimeUnknownIfNotSet("Remaining Estimate", item.getAttribute("timeestimateHours"));
            this.assertTimeUnknownIfNotSet("Time Spent", item.getAttribute("timespentHours"));
            this.assertTimeUnknownIfNotSet("Original Estimate", item.getAttribute("timeoriginalestimateHours"));
        } else {
            this.assertTimeUnknownIfNotSet("Remaining Estimate", item.getAttribute("timeestimate"));
            this.assertTimeUnknownIfNotSet("Time Spent", item.getAttribute("timespent"));
            this.assertTimeUnknownIfNotSet("Original Estimate", item.getAttribute("timeoriginalestimate"));
        }
        this.assertComponents(item);
        this.assertComments(item);
        this.assertAttachments(item);
        this.assertCustomField(item, "DateTimeField", "DateTimeField");
        this.assertCustomFieldValues(item, "MultiCheckboxesField", "MultiCheckboxesField");
        this.assertCustomFieldValues(item, "MultiSelectField", "MultiSelectField");
        this.assertCustomFieldValues(item, "RadioButtonsField", "RadioButtonsField");
        this.assertCustomFieldValues(item, "SelectList", "SelectList");
        this.assertCustomFieldValues(item, "TextField255", "TextField255");
        this.assertCustomField(item, "DatePickerField", "DatePickerField");
        this.assertCustomFieldValues(item, "FreeTextField", "FreeTextField");
        this.assertProjectPickerField(item);
    }

    private void assertAttachments(AbstractTestIssueNavigatorView.Item item) {
        List<String> attachments = item.getAttachments();
        if (attachments.isEmpty()) {
            this.assertions.getTextAssertions().assertTextNotPresent("Attachments");
        } else {
            for (String attachment : attachments) {
                this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), "Attachments", attachment);
            }
        }
    }

    private void assertComments(AbstractTestIssueNavigatorView.Item item) {
        List<AbstractTestIssueNavigatorView.Comment> comments = item.getComments();
        if (comments.isEmpty()) {
            this.assertions.getTextAssertions().assertTextNotPresent("Comments");
        } else {
            for (AbstractTestIssueNavigatorView.Comment comment : comments) {
                this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), "Comments", comment.getValue());
            }
        }
    }

    private void assertComponents(AbstractTestIssueNavigatorView.Item item) {
        List<String> components = item.getComponents();
        if (components.isEmpty()) {
            this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), "Component/s", "None");
        } else {
            for (String component : components) {
                this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), "Component/s", component);
            }
        }
    }

    private void assertTimeUnknownIfNotSet(String title, String attribute) {
        if (attribute == null) {
            this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), title, "Not Specified");
        } else {
            this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), title, attribute);
        }
    }

    private void assertUserProfileLink(String title, String user) {
        this.tester.assertLinkPresentWithText(title);
        this.assertLinkPresent(new String[]{this.baseUrl + "/secure/ViewProfile.jspa", "name=" + user});
    }

    private void assertSingleVersionPicker(String title, String value) {
        this.assertCustomFieldLink(title, value, "SingleVersionPickerField");
    }

    private void assertVersionPicker(String title, String value) {
        this.assertCustomFieldLink(title, value, "VersionPickerField");
    }

    private void assertCustomFieldLink(String title, String value, String customFieldName) {
        this.tester.assertLinkPresentWithText(title);
        this.assertLinkPresent(new String[]{this.baseUrl + "/issues/", "jql=project%3D%22HSP%22", "%22" + customFieldName + "%22%3D%22" + value + "%22", "ORDER%20BY%20priority%20ASC"});
    }

    private void assertLinkPresentWithUrl(String url, boolean exactMatch) {
        if (url != null) {
            try {
                WebLink[] links;
                for (WebLink link : links = this.tester.getDialog().getResponse().getLinks()) {
                    String urlString = link.getURLString();
                    if (!(exactMatch ? url.equals(urlString) : urlString != null && urlString.indexOf(url) >= 0)) continue;
                    return;
                }
                Assert.fail((String)("Link '" + url + "' not found in response"));
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
    }

    private void assertLinkPresent(String[] urlParts) {
        if (urlParts != null) {
            try {
                WebLink[] links = this.tester.getDialog().getResponse().getLinks();
                Assert.assertTrue((String)("Link with '" + Arrays.toString(urlParts) + "' not found in response. Existing: " + Arrays.toString(Arrays.stream(this.tester.getDialog().getResponse().getLinks()).map(i -> i.getURLString()).toArray())), (boolean)this.anyLinkContainsAllParts(links, urlParts));
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    private boolean anyLinkContainsAllParts(WebLink[] links, String[] urlParts) {
        boolean result = false;
        for (WebLink link : links) {
            if (!this.linkContainsAllParts(link.getURLString(), urlParts)) continue;
            return true;
        }
        return false;
    }

    private boolean linkContainsAllParts(String link, String[] urlParts) {
        boolean result = true;
        if (link != null) {
            for (String urlPart : urlParts) {
                if (link.indexOf(urlPart) >= 0) continue;
                result = false;
            }
        }
        return result;
    }

    @Override
    protected void initFieldColumnMap() {
    }

    @Test
    public void testTimeTracking() throws SAXException {
        this.administration.subtasks().enable();
        this.subTaskify("HSP-12", "HSP-10");
        this.subTaskify("HSP-11", "HSP-10");
        this.navigation.issueNavigator().gotoNavigator();
        this.goToView("");
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{" Remaining Estimate:", "1 day, 30 minutes", "Remaining Estimate:", "1 day", " Time Spent:", "3 hours, 20 minutes", "Time Spent:", "Not Specified", " Original Estimate:", "1 day", "Original Estimate:", "1 day"});
    }
}

