/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorXmlView;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.WebResponseUtil;
import java.io.IOException;
import java.net.URL;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.ISSUES})
@Restore(value="TestSearchRequestViewsAndIssueViews.xml")
@LoginAs(user="admin")
public class TestIssueNavigatorRssView
extends AbstractTestIssueNavigatorXmlView {
    protected static final String XML_LINK_COMMENT_AFTER_12APR = "updated+%3E%3D+2006-04-12";
    protected static final String XML_LINK_COMMENT_BEFORE_16APR = "updated+%3C%3D+2006-04-16";
    protected static final String[] XML_LINK_COMMENT_23_25NOV = new String[]{"updated+%3C%3D+2006-11-25", "updated+%3E%3D+2006-11-23"};
    protected static final String[] XML_LINK_COMMENT_12_16APR = new String[]{"updated+%3E%3D+2006-04-12", "updated+%3C%3D+2006-04-16"};

    @Test
    public void testCommentsRssFeedUpdated() throws IOException, SAXException, ParserConfigurationException, TransformerException {
        this.administration.generalConfiguration().setJiraLocale("English (UK)");
        this.backdoor.permissionSchemes().addGroupPermission(Long.valueOf(0L), ProjectPermissions.EDIT_ALL_COMMENTS, "jira-users");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?pid=10000&updated%3Aprevious=-2d&sorter/field=issuekey&sorter/order=DESC&tempMax=1000");
        WebResponseUtil.replaceResponseContentType(this.tester.getDialog().getResponse(), "text/html");
        String xpath = "//item";
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.tester.gotoPage("/secure/Dashboard.jspa");
        this.navigation.issue().gotoIssue("HSP-11");
        this.tester.clickLink("edit_comment_10000");
        this.tester.setWorkingForm("comment-edit");
        String newDescription = "RSS rocks!";
        this.tester.setFormElement("comment", "RSS rocks!");
        this.tester.submit("Save");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?pid=10000&updated%3Aprevious=-2d&sorter/field=issuekey&sorter/order=DESC&tempMax=1000");
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        String NEW_XML_LINK_COMMENT = "/issues/?jql=project+%3D+HSP+AND+updated+%3E%3D+-2d";
        xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/issues/?jql=project+%3D+HSP+AND+updated+%3E%3D+-2d" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        AbstractTestIssueNavigatorView.Item item = this.commentItem3;
        xpath = "//item[title='" + item.getAttribute("title") + "'][contains(link,'" + item.getAttribute("link") + "')][contains(description, '" + "RSS rocks!" + "')][contains(description, '" + item.getAttribute("description_link_profile") + "')][contains(description, 'Edited by')][contains(description, '" + item.getAttribute("description_link_issue") + "')]";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
    }

    @Test
    public void testRssIssuesViewHaveCorrectLinkToTheFilter() throws DocumentException {
        String filterId = this.backdoor.filters().createFilter("issuetype=\"New Feature\"", "rssfeed");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=1000");
        this.assertAndGetLinkToFilterWithId(filterId);
    }

    @Test
    public void testRssCommentsViewHaveCorrectLinkToTheFilter() throws DocumentException {
        String filterId = this.backdoor.filters().createFilter("issuetype=\"New Feature\"", "rssfeed");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=1000");
        this.assertAndGetLinkToFilterWithId(filterId);
    }

    @Test
    public void testRssIssueFeedWithSubtaskTimeTracking() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"HSP-12", "Remaining Estimate:", "Not Specified", "Time Spent:", "Not Specified", "Original Estimate:", "Not Specified"});
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"HSP-11", "Remaining Estimate:", "30 minutes", "Time Spent:", "3 hours, 20 minutes", "Original Estimate:", "Not Specified"});
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"HSP-10", "Remaining Estimate:", "1 day", "Time Spent:", "Not Specified", "Original Estimate:", "1 day"});
        this.tester.assertTextNotPresent(" Remaining Estimate");
        this.tester.assertTextNotPresent(" Time Spent");
        this.tester.assertTextNotPresent(" Original Estimate");
        this.goBackFromRssView();
        this.administration.subtasks().enable();
        this.subTaskify("HSP-12", "HSP-10");
        this.subTaskify("HSP-11", "HSP-10");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"HSP-12", "Remaining Estimate:", "Not Specified", "Time Spent:", "Not Specified", "Original Estimate:", "Not Specified"});
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"HSP-11", "Remaining Estimate:", "30 minutes", "Time Spent:", "3 hours, 20 minutes", "Original Estimate:", "Not Specified"});
        this.assertions.getTextAssertions().assertTextSequence(this.tester.getDialog().getResponseText(), new String[]{"HSP-10", " Remaining Estimate:", "1 day, 30 minutes", "Remaining Estimate:", "1 day", " Time Spent:", "3 hours, 20 minutes", "Time Spent:", "Not Specified", " Original Estimate:", "1 day", "Original Estimate:", "1 day"});
        this.goBackFromRssView();
        this.administration.timeTracking().disable();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        this.tester.assertTextNotPresent("Remaining Estimate");
        this.tester.assertTextNotPresent("Time Spent");
        this.tester.assertTextNotPresent("Original Estimate");
    }

    @Test
    public void testRedirectRegex() {
        Pattern pattern = Pattern.compile(".*\\?&.*");
        ArrayList<String> urls = new ArrayList<String>(){
            {
                this.add("/issues/?decorator=none&view=rss");
                this.add("/issues/?view=rss&decorator=none");
            }
        };
        for (String url : urls) {
            this.tester.gotoPage(url);
            URL responseUrl = this.tester.getDialog().getResponse().getURL();
            Assert.assertFalse((boolean)pattern.matcher(responseUrl.toString()).matches());
        }
    }

    @Test
    public void testRssIssueFeed() throws Exception {
        this.logger.log((Object)"Issue Navigator RSS : Test that the RSS page shows all required items for an issue feed");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        String responseText = this.tester.getDialog().getResponse().getText();
        this.checkRssResponseHeaders(this.tester.getDialog().getResponse());
        this.checkPubDatesRFC822(responseText);
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/issues/?jql=" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//rss[contains(@version,'2.0')]";
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        for (AbstractTestIssueNavigatorView.Item item : this.items) {
            String xPath = "//item[title='" + item.getAttribute("title") + "'][contains(link,'" + item.getAttribute("link") + "')][contains(guid,'" + item.getAttribute("link") + "')][contains(author,'" + item.getAttribute("reporter") + "')]";
            this.logger.log((Object)("Searching for existence of xpath " + xPath));
            XMLAssert.assertXpathExists((String)xPath, (Document)doc);
        }
    }

    @Test
    public void testCommentRssFeedForIssues() throws Exception {
        this.logger.log((Object)"Issue Navigator RSS: Test that the RSS page shows all required items for a comment feed");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=&tempMax=1000");
        String responseText = this.tester.getDialog().getResponse().getText();
        this.checkRssResponseHeaders(this.tester.getDialog().getResponse());
        this.checkPubDatesRFC822(responseText);
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/issues/?jql=" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        for (AbstractTestIssueNavigatorView.Item item : this.commentItems) {
            String xPath = "//item[title='" + item.getAttribute("title") + "'][contains(link,'" + item.getAttribute("link") + "')][contains(pubDate, '" + item.getAttribute("pubDate") + "')][contains(description, '" + item.getAttribute("description") + "')][contains(description, '" + item.getAttribute("description_link_profile") + "')][not(contains(description, 'Edited by'))][contains(description, '" + item.getAttribute("description_link_issue") + "')]";
            this.logger.log((Object)("Searching for existence of xpath " + xPath));
            XMLAssert.assertXpathExists((String)xPath, (Document)doc);
        }
    }

    @Test
    public void testCommentRssFeedForIssuesTempMax() throws Exception {
        this.logger.log((Object)"Issue Navigator RSS: Test that the RSS page shows all required items for a comment feed");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC&tempMax=1");
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/issues/?jql=" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        String xPathItem1 = "//item[contains(description, 'no comment')]";
        String xPathItem2 = "//item[contains(description, 'Developers, developers, developers!')]";
        String xPathItem3 = "//item[contains(description, 'This is my first comment')]";
        this.logger.log((Object)"Searching for existence of xpath //item[contains(description, 'no comment')]");
        XMLAssert.assertXpathExists((String)"//item[contains(description, 'no comment')]", (Document)doc);
        this.logger.log((Object)"Searching for absence of xpath //item[contains(description, 'Developers, developers, developers!')]");
        XMLAssert.assertXpathNotExists((String)"//item[contains(description, 'Developers, developers, developers!')]", (Document)doc);
        this.logger.log((Object)"Searching for absence of xpath //item[contains(description, 'This is my first comment')]");
        XMLAssert.assertXpathNotExists((String)"//item[contains(description, 'This is my first comment')]", (Document)doc);
    }

    @Test
    @Restore(value="TestIssueNavigatorRssCommentsFeed.xml")
    public void testCommentRssFeedForIssuesWithAbsoluteDateRange() throws Exception {
        this.administration.generalConfiguration().setJiraLocale("English (UK)");
        this.logger.log((Object)"Issue Navigator RSS: Test that the RSS page shows all required items for a comment feed");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3E%3D+2006-04-12&tempMax=1000");
        this.checkComments(XML_LINK_COMMENT_AFTER_12APR, false, true, false, true);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3C%3D+2006-04-16&tempMax=1000");
        this.checkComments(XML_LINK_COMMENT_BEFORE_16APR, true, true, true, false);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3E%3D+2006-11-23+AND+updated+%3C%3D+2006-11-25&tempMax=1000");
        this.checkComments(XML_LINK_COMMENT_23_25NOV, false, false, false, false);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3E%3D+2006-04-12+AND+updated+%3C%3D+2006-04-16&tempMax=1000");
        this.checkComments(XML_LINK_COMMENT_12_16APR, false, true, false, false);
    }

    @Test
    @Restore(value="TestIssueNavigatorRssCommentsFeed.xml")
    public void testCommentRssFeedForIssuesWithRelativeDateRange() throws Exception {
        this.administration.generalConfiguration().setJiraLocale("English (UK)");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3E%3D+\"" + this.dateToRelativeString(2006, 4, 17) + "\"&tempMax=1000");
        this.checkCommentsOnlyNoDates(false, false, false, true);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3C%3D+\"" + this.dateToRelativeString(2006, 4, 17) + "\"&tempMax=1000");
        this.checkCommentsOnlyNoDates(true, true, true, false);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3E%3D+\"" + this.dateToRelativeString(2006, 11, 23) + "\"+AND+updated+%3C%3D+\"" + this.dateToRelativeString(2006, 11, 25) + "\"&tempMax=1000");
        this.checkCommentsOnlyNoDates(false, false, false, false);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?jqlQuery=updated+%3E%3D+\"" + this.dateToRelativeString(2006, 4, 10) + "\"+AND+updated+%3C%3D+\"" + this.dateToRelativeString(2006, 4, 17) + "\"&tempMax=1000");
        this.checkCommentsOnlyNoDates(false, true, false, false);
    }

    @Test
    public void testRssIssueFeedForIssueCountTag() throws Exception {
        this.logger.log((Object)"Issue Navigator RSS : Test that the RSS page shows correct values for the <issue> tag");
        int start = 0;
        for (int tempMax = 0; tempMax < this.items.size() + 3; ++tempMax) {
            if (tempMax > this.items.size()) {
                start = this.items.size() / 2;
            }
            this.checkIssueCountTag(start, tempMax);
        }
    }

    @Test
    public void testRssIssueFeedForXssDescription() {
        this.addHTMLtoDescription();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml?tempMax=1000");
        this.tester.assertTextNotPresent("&trade;");
    }

    @Test
    public void testRssCommentFeedForXssDescription() {
        this.addHTMLtoDescription();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml?tempMax=1000");
        this.tester.assertTextNotPresent("&trade;");
    }

    @Test
    public void testXmlIssueFeedForXssDescription() {
        this.addHTMLtoDescription();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml?tempMax=1000");
        this.tester.assertTextNotPresent("&trade;");
    }

    private void addHTMLtoDescription() {
        this.tester.gotoPage("/secure/EditFilter!default.jspa?returnUrl=ManageFilters.jspa&filterId=10000");
        this.tester.setFormElement("filterName", "all issues &trade;");
        this.tester.setFormElement("filterDescription", "&trade;");
        this.tester.submit("Save");
    }

    private String dateToRelativeString(int year, int month, int date) {
        Calendar cal = Calendar.getInstance();
        int h = cal.get(11);
        int m = cal.get(12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(11, 0);
        long today = cal.getTimeInMillis();
        cal.set(year, month - 1, date);
        long days = (today - cal.getTimeInMillis()) / 86400000L;
        if (days > 0L) {
            return "-" + days + "d " + h + "h " + m + "m";
        }
        return -days + "d " + h + "h " + m + "m";
    }

    private void checkComments(String link, boolean hasComment1, boolean hasComment2, boolean hasComment3, boolean hasComment4) throws Exception {
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + link + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.checkCommentsOnlyNoDates(hasComment1, hasComment2, hasComment3, hasComment4);
    }

    private void checkCommentsOnlyNoDates(boolean hasComment1, boolean hasComment2, boolean hasComment3, boolean hasComment4) throws Exception {
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        this.checkXpath(hasComment1, this.commentItem1, doc, false);
        this.checkXpath(hasComment2, this.commentItem2, doc, false);
        this.checkXpath(hasComment3, this.commentItem3, doc, false);
        this.checkXpath(hasComment4, this.commentItem4, doc, false);
    }

    private void checkComments(String[] links, boolean hasComment1, boolean hasComment2, boolean hasComment3, boolean hasComment4) throws Exception {
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        StringBuilder sb = new StringBuilder();
        sb.append("//channel[title='");
        sb.append(this.XML_TITLE);
        sb.append("']");
        for (String link : links) {
            sb.append("[contains(link,'");
            sb.append(link);
            sb.append("')]");
        }
        sb.append("[description='");
        sb.append("An XML representation of a search request");
        sb.append("'][language='");
        sb.append("en-uk");
        sb.append("']");
        String xpath = sb.toString();
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.checkCommentsOnlyNoDates(hasComment1, hasComment2, hasComment3, hasComment4);
    }

    private void checkXpath(boolean expected, AbstractTestIssueNavigatorView.Item comment, Document doc, boolean checkPubDate) throws TransformerException {
        String xPath = "//item[title='" + comment.getAttribute("title") + "'][contains(link,'" + comment.getAttribute("link") + "')]" + (checkPubDate ? "[contains(pubDate, '" + comment.getAttribute("pubDate") + "')]" : "") + "[contains(description, '" + comment.getAttribute("description") + "')][contains(description, '" + comment.getAttribute("description_link_profile") + "')][contains(description, '" + comment.getAttribute("description_link_issue") + "')]";
        if (expected) {
            this.logger.log((Object)("Searching for existence of xpath " + xPath));
            XMLAssert.assertXpathExists((String)xPath, (Document)doc);
        } else {
            this.logger.log((Object)("Searching for non-existence of xpath " + xPath));
            XMLAssert.assertXpathNotExists((String)xPath, (Document)doc);
        }
    }

    private void goBackFromRssView() {
        this.tester.gotoPage("/secure/project/ViewProjects.jspa");
    }

    private void checkRssResponseHeaders(WebResponse response) {
        String contentType = response.getHeaderField("content-type");
        Assert.assertEquals((Object)"", (Object)response.getHeaderField("Pragma"));
        this.assertions.getRequestAssertions().assertResponseCanBeCached();
        String cacheControl = response.getHeaderField("Cache-Control");
        Assert.assertTrue((boolean)cacheControl.contains("private"));
        Assert.assertTrue((boolean)cacheControl.contains("must-revalidate"));
        Assert.assertTrue((boolean)cacheControl.contains("max-age"));
        Assert.assertTrue((String)"RSS response should be Content-Type: application/rss+xml", (boolean)contentType.contains("application/rss+xml"));
    }

    private void checkPubDatesRFC822(String responseText) {
        SimpleDateFormat rcf822Format = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        int si = responseText.indexOf("<pubDate>");
        while (si != -1) {
            int ei = responseText.indexOf("</pubDate>", si);
            Assert.assertTrue((String)"missing pubDate element", (ei != -1 ? 1 : 0) != 0);
            String dateStr = responseText.substring(si + "<pubDate>".length(), ei);
            ParsePosition pp = new ParsePosition(0);
            Date dt = rcf822Format.parse(dateStr, pp);
            Assert.assertEquals((String)"Rfc822 date parse failure", (long)-1L, (long)pp.getErrorIndex());
            Assert.assertNotNull((String)"Rfc822 date parse failure", (Object)dt);
            si = responseText.indexOf("<pubDate>", ei);
        }
    }

    private void checkIssueCountTag(int start, int tempMax) throws Exception {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC&pager/start=" + start + "&tempMax=" + tempMax);
        String responseText = this.tester.getDialog().getResponse().getText();
        int end = Math.min(start + tempMax, this.items.size());
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//issue[@start='" + start + "'][@end='" + end + "'][@total='" + this.items.size() + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
    }
}

