/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.text.TextKit;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorView;
import com.atlassian.jira.webtests.AbstractTestIssueNavigatorXmlView;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang3.StringUtils;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.dom4j.DocumentException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR})
@Restore(value="TestSearchRequestViewsAndIssueViews.xml")
@LoginAs(user="admin")
public class TestIssueNavigatorXmlView
extends AbstractTestIssueNavigatorXmlView {
    @Inject
    private TextAssertions textAssertions;
    private final List<String> DISPLAYABLE_CUSTOM_FIELDS = Arrays.asList("com.atlassian.jira.plugin.system.customfieldtypes:cascadingselect", "com.atlassian.jira.plugin.system.customfieldtypes:version", "com.atlassian.jira.plugin.system.customfieldtypes:multiversion", "com.atlassian.jira.plugin.system.customfieldtypes:project");

    @Override
    public void setUp() {
        super.setUp();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.columnControl().addLoggedInUserColumns((List<String>)ImmutableList.of((Object)"creator"));
    }

    @Test
    @Restore(value="TestIssueXmlViewAbsoluteIcon.xml")
    public void testIssueNavigatorXmlViewAbsoluteIcon() {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml?tempMax=1000");
        this.textAssertions.assertRegexNoMatch(this.tester.getDialog().getResponseText(), "iconUrl=\"http://.*http://.*\"");
        this.textAssertions.assertRegexNoMatch(this.tester.getDialog().getResponseText(), "iconUrl=\".*\\?x=y&z=a");
        this.textAssertions.assertRegexMatch(this.tester.getDialog().getResponseText(), "iconUrl=\".*\\?x=y&amp;z=a");
    }

    @Test
    public void testIssueNavigatorXmlViewLinksToFilter() throws IOException, ParserConfigurationException, SAXException, TransformerException, DocumentException {
        String filterId = this.backdoor.filters().createFilter("issuetype='New Feature'", "xmlview");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=1000");
        this.assertAndGetLinkToFilterWithId(filterId);
    }

    @Test
    public void testIssueXmlView() throws Exception {
        this.reconfigureTimetracking(TimeTracking.Format.PRETTY);
        this.execIssueXmlView();
    }

    @Test
    public void testIssueXmlViewDaysTimeFormat() throws Exception {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.execIssueXmlView();
    }

    @Test
    public void testIssueXmlViewHoursTimeFormat() throws Exception {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.execIssueXmlView();
    }

    private void execIssueXmlView() throws Exception {
        this.logger.log((Object)"Issue Navigator: Test that the IssueView XML page correctly shows the custom field information.");
        for (AbstractTestIssueNavigatorView.Item item : this.items) {
            String key = (String)item.getAttributeMap().get("key");
            this.logger.log((Object)("testing item key = " + key + "..."));
            this.backdoor.issueTableClient().getIssueTable("");
            this.tester.gotoPage("/browse/" + key);
            this.tester.clickLinkWithText("XML");
            String responseText = this.tester.getDialog().getResponse().getText();
            Document doc = XMLUnit.buildControlDocument((String)responseText);
            String xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "')][description='" + "This file is an XML representation of an issue" + "'][language='" + "en-uk" + "']";
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            this.execTestOnAttributes(item, doc);
            this.execTestOnComments(item, doc);
            this.execTestOnLinks(item, doc);
            this.execTestOnComponents(item, doc);
            this.execTestOnCustomFields(item, doc);
            this.execTestOnAttachements(item, doc);
        }
    }

    @Test
    public void testXMLViewAllItems() throws Exception {
        this.reconfigureTimetracking(TimeTracking.Format.PRETTY);
        this.execXMLViewAllItems();
    }

    @Test
    public void testXMLViewAllItemsDaysTimeFormat() throws Exception {
        this.reconfigureTimetracking(TimeTracking.Format.DAYS);
        this.execXMLViewAllItems();
    }

    @Test
    public void testXMLViewAllItemsHoursTimeFormat() throws Exception {
        this.reconfigureTimetracking(TimeTracking.Format.HOURS);
        this.execXMLViewAllItems();
    }

    @Test
    public void testXmlContentSecurityPolicyHeader() throws Exception {
        this.execXMLViewAllItems();
        Assert.assertEquals((Object)"sandbox", (Object)this.tester.getDialog().getResponse().getHeaderField("Content-Security-Policy"));
    }

    public void execXMLViewAllItems() throws Exception {
        this.logger.log((Object)"Issue Navigator: Test that the XML page correctly shows the custom field information.");
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?jqlQuery=project+%3D+HSP&tempMax=1000");
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//channel[title='" + this.XML_TITLE + "'][contains(link,'" + this.getEnvironmentData().getBaseUrl() + "/issues/?jql=project+%3D+HSP" + "')][description='" + "An XML representation of a search request" + "'][language='" + "en-uk" + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        for (AbstractTestIssueNavigatorView.Item item : this.items) {
            this.logger.log((Object)"testing item...");
            this.execTestOnAttributes(item, doc);
            this.execTestOnComments(item, doc);
            this.execTestOnLinks(item, doc);
            this.execTestOnComponents(item, doc);
            this.execTestOnCustomFields(item, doc);
            this.execTestOnAttachements(item, doc);
        }
    }

    @Test
    public void testIssueXMLViewForIssueCountTag() throws Exception {
        this.logger.log((Object)"Issue Navigator: Test that the XML page shows correct values for the <issue> tag");
        int start = 0;
        for (int tempMax = 0; tempMax < this.items.size() + 3; ++tempMax) {
            if (tempMax > this.items.size()) {
                start = this.items.size() / 2;
            }
            this.checkIssueCountTag(start, tempMax);
        }
    }

    private void execTestOnLinks(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        AbstractTestIssueNavigatorView.IssueLinks links = item.getLinks();
        if (links != null) {
            String xxpath;
            AbstractTestIssueNavigatorView.IssueLink link;
            String key = item.getAttribute("key");
            String xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "'][name='" + links.getName() + "']";
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathExists((String)xpath, (Document)doc);
            if (links.getOutLinks() != null && !links.getOutLinks().isEmpty()) {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/outwardlinks[@description='" + links.getOutDesc() + "']";
                for (Object o : links.getOutLinks()) {
                    link = (AbstractTestIssueNavigatorView.IssueLink)o;
                    xxpath = xpath + "/issuelink/issuekey[@id='" + link.getId() + "'][.='" + link.getLink() + "']";
                    this.logger.log((Object)("Searching for existence of xpath " + xxpath));
                    XMLAssert.assertXpathExists((String)xxpath, (Document)doc);
                }
            } else {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/outwardlinks";
                this.logger.log((Object)("Searching for existence of xpath " + xpath));
                XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
            }
            if (links.getInLinks() != null && !links.getInLinks().isEmpty()) {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/inwardlinks[@description='" + links.getInDesc() + "']";
                for (Object o : links.getInLinks()) {
                    link = (AbstractTestIssueNavigatorView.IssueLink)o;
                    xxpath = xpath + "/issuelink/issuekey[@id='" + link.getId() + "'][.='" + link.getLink() + "']";
                    this.logger.log((Object)("Searching for existence of xpath " + xxpath));
                    XMLAssert.assertXpathExists((String)xxpath, (Document)doc);
                }
            } else {
                xpath = "//item[key='" + key + "']/issuelinks/issuelinktype[@id='" + links.getId() + "']/inwardlinks";
                this.logger.log((Object)("Searching for existence of xpath " + xpath));
                XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
            }
        }
    }

    private void execTestOnAttributes(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        Map attributeMap = item.getAttributeMap();
        if (!attributeMap.isEmpty()) {
            StringBuffer xpath = new StringBuffer("//item");
            for (Map.Entry o2 : attributeMap.entrySet()) {
                Map.Entry entry = o2;
                String key = (String)entry.getKey();
                if ("created".equals(key) || "updated".equals(key) || "due".equals(key) || "resolved".equals(key)) {
                    xpath.append("[");
                    xpath.append(key);
                    xpath.append("=*");
                    xpath.append("]");
                    continue;
                }
                if ("timeoriginalestimateDays".equals(key) || "timeoriginalestimateHours".equals(key) || "timeoriginalestimate".equals(key)) {
                    if (!("timeoriginalestimateDays".equals(key) && TimeTracking.Format.DAYS == this.timeFormat || "timeoriginalestimateHours".equals(key) && TimeTracking.Format.HOURS == this.timeFormat) && (!"timeoriginalestimate".equals(key) || TimeTracking.Format.PRETTY != this.timeFormat)) continue;
                    xpath.append("[");
                    xpath.append("timeoriginalestimate");
                    xpath.append("='");
                    xpath.append(entry.getValue());
                    xpath.append("'");
                    xpath.append("]");
                    continue;
                }
                if ("timespentDays".equals(key) || "timespentHours".equals(key) || "timespent".equals(key)) {
                    if (!("timespentDays".equals(key) && TimeTracking.Format.DAYS == this.timeFormat || "timespentHours".equals(key) && TimeTracking.Format.HOURS == this.timeFormat) && (!"timespent".equals(key) || TimeTracking.Format.PRETTY != this.timeFormat)) continue;
                    xpath.append("[");
                    xpath.append("timespent");
                    xpath.append("='");
                    xpath.append(entry.getValue());
                    xpath.append("'");
                    xpath.append("]");
                    continue;
                }
                if ("timeestimateDays".equals(key) || "timeestimateHours".equals(key) || "timeestimate".equals(key)) {
                    if (!("timeestimateDays".equals(key) && TimeTracking.Format.DAYS == this.timeFormat || "timeestimateHours".equals(key) && TimeTracking.Format.HOURS == this.timeFormat) && (!"timeestimate".equals(key) || TimeTracking.Format.PRETTY != this.timeFormat)) continue;
                    xpath.append("[");
                    xpath.append("timeestimate");
                    xpath.append("='");
                    xpath.append(entry.getValue());
                    xpath.append("'");
                    xpath.append("]");
                    continue;
                }
                if ("creator".equals(key)) continue;
                xpath.append("[");
                xpath.append(key);
                xpath.append("='");
                xpath.append(entry.getValue());
                xpath.append("'");
                xpath.append("]");
            }
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            Map allAttributesMap = item.getAllAttributeAttributesMap();
            for (Map.Entry o1 : allAttributesMap.entrySet()) {
                xpath = new StringBuffer("//item/");
                Map.Entry attributeEntry = o1;
                xpath.append(attributeEntry.getKey());
                Map attributeAttributes = (Map)attributeEntry.getValue();
                Iterator iterator = attributeAttributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry o;
                    Map.Entry attEntry = o = iterator.next();
                    xpath.append("[@");
                    xpath.append(attEntry.getKey());
                    xpath.append("='");
                    xpath.append(TextKit.htmlEncode(attEntry.getValue().toString()));
                    xpath.append("']");
                }
                this.logger.log((Object)("Searching for existence of xpath " + xpath));
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        }
    }

    private void execTestOnComments(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List<AbstractTestIssueNavigatorView.Comment> commentList = item.getComments();
        if (commentList != null && !commentList.isEmpty()) {
            Iterator<AbstractTestIssueNavigatorView.Comment> iterator = commentList.iterator();
            while (iterator.hasNext()) {
                AbstractTestIssueNavigatorView.Comment aCommentList;
                AbstractTestIssueNavigatorView.Comment comment = aCommentList = iterator.next();
                StringBuilder xpath = new StringBuilder();
                xpath.append("//item[key='");
                xpath.append(item.getAttribute("key"));
                xpath.append("']/comments/comment");
                xpath.append("[@author='");
                xpath.append(comment.getAuthor());
                xpath.append("'][@created]");
                if (StringUtils.isNotBlank((CharSequence)comment.getLevel())) {
                    xpath.append("[@grouplevel='");
                    xpath.append(comment.getLevel());
                    xpath.append("']");
                }
                xpath.append("[. = '");
                xpath.append(comment.getValue());
                xpath.append("']");
                this.logger.log((Object)("Searching for existence of xpath " + xpath));
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        } else {
            String xpath = "//item[key='" + item.getAttribute("key") + "']/comments";
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
    }

    private void execTestOnAttachements(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List<String> attachmentList = item.getAttachments();
        if (attachmentList != null && !attachmentList.isEmpty()) {
            for (String attachment : attachmentList) {
                StringBuilder xpath = new StringBuilder();
                xpath.append("//item[key='");
                xpath.append(item.getAttribute("key"));
                xpath.append("']/attachments/attachment");
                xpath.append("[@name='");
                xpath.append(attachment);
                xpath.append("']");
                this.logger.log((Object)("Searching for existence of xpath " + xpath));
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        } else {
            String xpath = "//item[key='" + item.getAttribute("key") + "']/attachments/attachment";
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
    }

    private void execTestOnComponents(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List<String> componentList = item.getComponents();
        if (componentList != null && !componentList.isEmpty()) {
            for (String component : componentList) {
                StringBuilder xpath = new StringBuilder();
                xpath.append("//item[key='");
                xpath.append(item.getAttribute("key"));
                xpath.append("'][component='");
                xpath.append(component);
                xpath.append("']");
                this.logger.log((Object)("Searching for existence of xpath " + xpath));
                XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
            }
        } else {
            String xpath = "//item[key='" + item.getAttribute("key") + "']/component";
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        }
    }

    private void execTestOnCustomFields(AbstractTestIssueNavigatorView.Item item, Document doc) throws TransformerException {
        List<AbstractTestIssueNavigatorView.CustomField> customFieldList = item.getCustomFields();
        for (AbstractTestIssueNavigatorView.CustomField customField : customFieldList) {
            StringBuilder xpath = new StringBuilder();
            xpath.append("//item/customfields/customfield[@id='");
            xpath.append(customField.getId());
            xpath.append("'][customfieldname='");
            xpath.append(customField.getName());
            xpath.append("'][customfieldvalues");
            String customFieldKey = customField.getKey();
            if ("com.atlassian.jira.plugin.system.customfieldtypes:datetime".equals(customFieldKey) || "com.atlassian.jira.plugin.system.customfieldtypes:datepicker".equals(customFieldKey)) {
                Iterator<AbstractTestIssueNavigatorView.CustomField.Value> j = customField.getValues().iterator();
                while (j.hasNext()) {
                    xpath.append("[customfieldvalue=*]");
                    j.next();
                }
            } else if (this.DISPLAYABLE_CUSTOM_FIELDS.stream().anyMatch(x -> x.equals(customFieldKey))) {
                for (AbstractTestIssueNavigatorView.CustomField.Value value : customField.getValues()) {
                    xpath.append("[customfieldvalue='");
                    xpath.append(value.getDisplayValue());
                    xpath.append("']");
                }
            } else {
                for (AbstractTestIssueNavigatorView.CustomField.Value value : customField.getValues()) {
                    xpath.append("[customfieldvalue='");
                    xpath.append(value.getValue());
                    xpath.append("']");
                }
            }
            xpath.append("]");
            this.logger.log((Object)("Searching for existence of xpath " + xpath));
            XMLAssert.assertXpathExists((String)xpath.toString(), (Document)doc);
        }
    }

    private void checkIssueCountTag(int start, int tempMax) throws Exception {
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?sorter/field=issuekey&sorter/order=DESC&pager/start=" + start + "&tempMax=" + tempMax);
        String responseText = this.tester.getDialog().getResponse().getText();
        int end = Math.min(start + tempMax, this.items.size());
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//issue[@start='" + start + "'][@end='" + end + "'][@total='" + this.items.size() + "']";
        this.logger.log((Object)("Searching for existence of xpath " + xpath));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
    }
}

