/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LocatorFactory;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.TextAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.log.FuncTestLogger;
import java.io.IOException;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.FILTERS, Category.SECURITY})
@LoginAs(user="admin")
public class TestSearchRequestViewSecurity
extends BaseJiraFuncTest {
    private static final String SR_PRINTABLE_SUCCESS = "/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html";
    private static final String SR_FULL_CONTENT_SUCCESS = "/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html";
    private static final String SR_XML_SUCCESS = "/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml";
    private static final String SR_RSS_SUCCESS = "/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml";
    private static final String SR_RSS_COMMENTS_SUCCESS = "/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml";
    private static final String SR_WORD_SUCCESS = "/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc";
    private static final String SR_GLOBAL_PRINTABLE_SUCCESS = "/sr/jira.issueviews:searchrequest-printable/10010/SearchRequest-10010.html";
    private static final String SR_GLOBAL_FULL_CONTENT_SUCCESS = "/sr/jira.issueviews:searchrequest-fullcontent/10010/SearchRequest-10010.html";
    private static final String SR_GLOBAL_XML_SUCCESS = "/sr/jira.issueviews:searchrequest-xml/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_RSS_SUCCESS = "/sr/jira.issueviews:searchrequest-rss/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_RSS_COMMENTS_SUCCESS = "/sr/jira.issueviews:searchrequest-comments-rss/10010/SearchRequest-10010.xml";
    private static final String SR_GLOBAL_WORD_SUCCESS = "/sr/jira.issueviews:searchrequest-word/10010/SearchRequest-10010.doc";
    private static final String SR_RSS_COMMENTS_FAILED = "/sr/jira.issueviews:searchrequest-comments-rss/10001/SearchRequest-10000.xml";
    private static final String SR_PRINTABLE_FAILED = "/sr/jira.issueviews:searchrequest-printable/10001/SearchRequest-10000.html";
    private static final String SR_FULL_CONTENT_FAILED = "/sr/jira.issueviews:searchrequest-fullcontent/10001/SearchRequest-10000.html";
    private static final String SR_XML_FAILED = "/sr/jira.issueviews:searchrequest-xml/10001/SearchRequest-10000.xml";
    private static final String SR_RSS_FAILED = "/sr/jira.issueviews:searchrequest-rss/10001/SearchRequest-10000.xml";
    private static final String SR_WORD_FAILED = "/sr/jira.issueviews:searchrequest-word/10001/SearchRequest-10000.doc";
    @Inject
    private FuncTestLogger logger;
    @Inject
    private Administration administration;
    @Inject
    private LocatorFactory locator;
    @Inject
    private TextAssertions textAssertions;

    @Before
    public void setUpTest() {
        this.administration.restoreData("TestSearchRequestViewSecurity.xml");
    }

    @Test
    public void testGlobalSearchRequestRequiresNoLogin() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_PRINTABLE_SUCCESS);
        this.textAssertions.assertTextPresent(this.locator.page(), "HSP-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Bug 01");
        this.textAssertions.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_FULL_CONTENT_SUCCESS);
        this.textAssertions.assertTextPresent(this.locator.page(), "HSP-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Bug 01");
        this.textAssertions.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_XML_SUCCESS);
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_RSS_SUCCESS);
        Assert.assertEquals((Object)"application/rss+xml", (Object)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_RSS_COMMENTS_SUCCESS);
        Assert.assertEquals((Object)"application/rss+xml", (Object)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_GLOBAL_WORD_SUCCESS);
        Assert.assertEquals((Object)"application/vnd.ms-word", (Object)this.tester.getDialog().getResponse().getContentType());
    }

    @Test
    public void testErrorsWithGzipFilter() {
        this.administration.generalConfiguration().turnOnGZipCompression();
        this.navigation.logout();
        this.navigation.gotoPage(SR_PRINTABLE_SUCCESS);
        this.textAssertions.assertTextPresent(this.locator.page(), "You must log in to access this page.");
        this.navigation.login("admin", "admin");
        this.navigation.gotoPage("/sr/jira.issueviews:searchrequest-printable/10002/SearchRequest-10002.html");
        this.textAssertions.assertTextPresent(this.locator.page(), "Error processing Search Request");
    }

    @Test
    public void testLoginRequiredSuccess() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.navigation.logout();
        this.tester.gotoPage(SR_PRINTABLE_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        this.textAssertions.assertTextPresent(this.locator.page(), "HSP-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Bug 01");
        this.textAssertions.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_FULL_CONTENT_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        this.textAssertions.assertTextPresent(this.locator.page(), "HSP-1");
        this.textAssertions.assertTextPresent(this.locator.page(), "Bug 01");
        this.textAssertions.assertTextPresent(this.locator.page(), "Back to previous view");
        this.navigation.logout();
        this.tester.gotoPage(SR_XML_SUCCESS);
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for non-existance of xpath [" + xpath + "]"));
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.navigation.login("admin", "admin");
        this.tester.gotoPage(SR_XML_SUCCESS);
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'0.92')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_RSS_SUCCESS);
        this.assertions.assertHttpStatusCode(HttpStatus.UNAUTHORIZED);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml?os_username=admin&os_password=admin");
        Assert.assertEquals((Object)"application/rss+xml", (Object)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_RSS_COMMENTS_SUCCESS);
        this.assertions.assertHttpStatusCode(HttpStatus.UNAUTHORIZED);
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml?os_username=admin&os_password=admin");
        Assert.assertEquals((Object)"application/rss+xml", (Object)this.tester.getDialog().getResponse().getContentType());
        responseText = this.tester.getDialog().getResponse().getText();
        doc = XMLUnit.buildControlDocument((String)responseText);
        xpath = "//rss[contains(@version,'2.0')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(SR_WORD_SUCCESS);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage("admin", "admin");
        Assert.assertEquals((Object)"application/vnd.ms-word", (Object)this.tester.getDialog().getResponse().getContentType());
    }

    @Test
    public void testLoginRequiredAndSearchRequestDoesntExist() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.checkLoginInvalidSRorPermission(SR_PRINTABLE_FAILED, SR_FULL_CONTENT_FAILED, SR_XML_FAILED, SR_RSS_FAILED, SR_RSS_COMMENTS_FAILED, SR_WORD_FAILED, "admin");
    }

    @Test
    public void testLoginRequiredAndInvalidPermission() throws TransformerException, IOException, ParserConfigurationException, SAXException {
        this.checkLoginInvalidSRorPermission(SR_PRINTABLE_SUCCESS, SR_FULL_CONTENT_SUCCESS, SR_XML_SUCCESS, SR_RSS_SUCCESS, SR_RSS_COMMENTS_SUCCESS, SR_WORD_SUCCESS, "fred");
    }

    private void loginFromErrorPage(String username, String password) {
        this.tester.setFormElement("os_username", username);
        this.tester.setFormElement("os_password", password);
        this.tester.setWorkingForm("login-form");
        this.tester.submit();
    }

    private void checkNoLoginPageAndClickLink() {
        this.textAssertions.assertTextPresent(this.locator.page(), "You must log in to access this page.");
    }

    private void checkErrorProcessingSearchRequest() {
        this.textAssertions.assertTextPresent(this.locator.page(), "Error processing Search Request");
        this.textAssertions.assertTextPresent(this.locator.page(), "The saved filter you are trying to view no longer exists or you do not have access rights to view it.");
    }

    private void checkLoginSearchRequestDoesntExist(String url, String username, String password) {
        this.navigation.logout();
        this.tester.gotoPage(url);
        this.checkNoLoginPageAndClickLink();
        this.loginFromErrorPage(username, password);
        this.checkErrorProcessingSearchRequest();
    }

    private void checkLoginInvalidSRorPermission(String printable, String fullContent, String xml, String rss, String rssComments, String word, String usernamePassword) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        this.checkLoginSearchRequestDoesntExist(printable, usernamePassword, usernamePassword);
        this.checkLoginSearchRequestDoesntExist(fullContent, usernamePassword, usernamePassword);
        this.navigation.logout();
        this.tester.gotoPage(xml);
        Assert.assertEquals((Object)"text/xml", (Object)this.tester.getDialog().getResponse().getContentType());
        String responseText = this.tester.getDialog().getResponse().getText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        String xpath = "//rss[contains(@version,'0.92')]";
        this.logger.log((Object)("Testing for xpath [" + xpath + "]"));
        XMLAssert.assertXpathExists((String)xpath, (Document)doc);
        xpath = "//item";
        this.logger.log((Object)("Testing for non-existance of xpath [" + xpath + "]"));
        XMLAssert.assertXpathNotExists((String)xpath, (Document)doc);
        this.navigation.logout();
        this.tester.gotoPage(rss);
        this.assertions.assertHttpStatusCode(HttpStatus.UNAUTHORIZED);
        this.tester.gotoPage(rss + "?os_username=admin&os_password=admin");
        if ("admin".equals(usernamePassword)) {
            this.assertions.assertHttpStatusCode(HttpStatus.FORBIDDEN);
        } else {
            this.assertions.assertHttpStatusCode(HttpStatus.OK);
        }
        this.navigation.logout();
        this.tester.gotoPage(rssComments);
        this.assertions.assertHttpStatusCode(HttpStatus.UNAUTHORIZED);
        this.tester.gotoPage(rssComments + "?os_username=admin&os_password=admin");
        if ("admin".equals(usernamePassword)) {
            this.assertions.assertHttpStatusCode(HttpStatus.FORBIDDEN);
        } else {
            this.assertions.assertHttpStatusCode(HttpStatus.OK);
        }
        this.checkLoginSearchRequestDoesntExist(word, usernamePassword, usernamePassword);
    }

    private static final class ContentTypes {
        private static final String XML = "text/xml";
        private static final String RSS = "application/rss+xml";
        private static final String WORD = "application/vnd.ms-word";
        private static final String EXCEL = "application/vnd.ms-excel";

        private ContentTypes() {
        }
    }
}

