/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.JqlAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@Restore(value="TestJqlAttachments.xml")
public class TestJqlAttachmentsField
extends BaseJiraFuncTest {
    @Inject
    private JqlAssertions jqlAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testAllIssuesWithAttachments() {
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY");
        this.assertIssues("NUMBER-2", "MKY-3", "HSP-3");
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY AND project = MKY");
        this.assertIssues("MKY-3");
    }

    void assertIssues(String ... keys) {
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(keys);
    }

    @Test
    public void testIssuesWithoutAttachments() {
        this.navigation.issueNavigator().createSearch("attachments is EMPTY");
        this.assertIssues("NUMBER-1", "MKY-2", "MKY-1", "MK-2", "MK-1", "HSP-4", "HSP-1");
    }

    @Test
    public void testDisableAttachments() {
        this.backdoor.attachments().disable();
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY");
        this.assertIssues("NUMBER-2", "MKY-3", "HSP-3");
        this.navigation.issueNavigator().createSearch("attachments is EMPTY");
        this.assertIssues("NUMBER-1", "MKY-2", "MKY-1", "MK-2", "MK-1", "HSP-4", "HSP-1");
        this.backdoor.attachments().enable();
    }

    @Test
    public void testRemovingAttachments() {
        this.navigation.issueNavigator().createSearch("attachments is not EMPTY");
        this.assertIssues("NUMBER-2", "MKY-3", "HSP-3", "HSP-2");
        this.navigation.issue().viewIssue("HSP-2");
        this.tester.clickLink("manage-attachment-link");
        this.tester.clickLink("del_10002");
        this.tester.submit("Delete");
        this.navigation.issueNavigator().createSearch("attachments is EMPTY AND issuekey = HSP-2");
        this.assertIssues("HSP-2");
    }

    @Test
    public void testInvalidJqlQuery() {
        this.jqlAssertions.assertTooComplex("attachments is \"file.png\"");
        this.jqlAssertions.assertTooComplex("attachments is not empt");
        this.jqlAssertions.assertTooComplex("attachments is empt");
        this.jqlAssertions.assertTooComplex("attachments = empt");
        this.jqlAssertions.assertTooComplex("attachments != empt");
    }
}

