/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
@Restore(value="TestJqlVoterAndWatcherFields.xml")
public class TestJqlVoterAndWatcherFields
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;

    @Before
    public void setUp() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "bob");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "fred");
    }

    @Test
    public void testVoterField() {
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "voter = currentUser()", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "voter = bob", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "voter = BoB", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "voter = fred", new String[0]);
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "voter = FreD", new String[0]);
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "voter = currentUser()", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "voter = fred", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "voter = FreD", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "voter = bob", "HSP-4");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "voter = BoB", "HSP-4");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "voter = fred", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "voter = FreD", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "voter = bob", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "voter = BoB", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithWarningForUser("admin", "voter = dingbat", "The value 'dingbat' does not exist for the field 'voter'.");
    }

    @Test
    public void testWatcherField() {
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "watcher = currentUser()", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "watcher = bob", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "watcher = BoB", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "watcher = fred", new String[0]);
        this.issueTableAssertions.assertSearchWithResultsForUser("bob", "watcher = FreD", new String[0]);
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "watcher = currentUser()", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "watcher = fred", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "watcher = FreD", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "watcher = bob", new String[0]);
        this.issueTableAssertions.assertSearchWithResultsForUser("fred", "watcher = BoB", new String[0]);
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "watcher = fred", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "watcher = FreD", "HSP-4", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "watcher = bob", "HSP-3");
        this.issueTableAssertions.assertSearchWithResultsForUser("admin", "watcher = BoB", "HSP-3");
        this.issueTableAssertions.assertSearchWithWarningForUser("admin", "watcher = dingbat", "The value 'dingbat' does not exist for the field 'watcher'.");
    }
}

