/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.Administration;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL})
@LoginAs(user="admin")
public class TestSystemFieldLiterals
extends BaseJiraFuncTest {
    private static final String ORIGINAL_ESTIMATE = "originalEstimate";
    private static final String REMAINING_ESTIMATE = "remainingEstimate";
    private static final String TIME_SPENT = "timeSpent";
    @Inject
    private Administration administration;

    @Test
    @Restore(value="TestSystemFieldLiteralsVersion.xml")
    public void testAffectedVersion() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "affectedVersion";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'New Version 1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10001'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("affectedVersion", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsAssignee.xml")
    public void testAssignee() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "assignee";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("administrator", new Result(new String[]{"HSP-1"}));
        matrix.put("admin", new Result(new String[]{"HSP-2"}));
        matrix.put("'Fred Normal'", new Result(new String[]{"HSP-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("12345", new Result(new String[]{"HSP-5"}));
        matrix.put("'12345'", new Result(new String[]{"HSP-5"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("assignee", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsCategory.xml")
    public void testCategory() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "category";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Category1'", new Result(new String[]{"CAT-1"}));
        matrix.put("'10000'", new Result(new String[]{"CATTWO-1"}));
        matrix.put("'10001'", new Result(new String[]{"CATTWO-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"CAT-1"}));
        matrix.put("10001", new Result(new String[]{"CATTWO-1"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"NOT-1"}));
        this._testLiteralMatrix("category", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsComment.xml")
    public void testComment() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "comment";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"COM-1"}));
        matrix.put("'-Test'", new Result(new String[]{"COM-2"}));
        matrix.put("'123456'", new Result(new String[]{"COM-2"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"COM-1"}));
        matrix.put("123456", new Result(new String[]{"COM-2"}));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("comment", "~", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsComponent.xml")
    public void testComponent() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "component";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Component 1'", new Result(new String[]{"CMP-1"}));
        matrix.put("'10010'", new Result(new String[]{"CMP-2"}));
        matrix.put("'10011'", new Result(new String[]{"CMP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10010", new Result(new String[]{"CMP-1"}));
        matrix.put("10011", new Result(new String[]{"CMP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"CMP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("component", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsCreated.xml")
    public void testCreated() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "created";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("'1d'", new Result(new String[]{"CRE-3", "CRE-2", "CRE-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"CRE-1"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"CRE-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"CRE-1"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"CRE-1"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("created", "<", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsDescription.xml")
    public void testDescription() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "description";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-Test'", new Result(new String[]{"HSP-2"}));
        matrix.put("'123456'", new Result(new String[]{"HSP-2"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"HSP-1"}));
        matrix.put("123456", new Result(new String[]{"HSP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("description", "~", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsDueDate.xml")
    public void testDueDate() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "due";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242204510000", new Result(new String[]{"HSP-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_RELATIVE_DATE_FORMAT));
        matrix.put("'2009/05/13'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-13'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"HSP-2"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"HSP-2"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_RELATIVE_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_RELATIVE_DATE_FORMAT));
        this._testLiteralMatrix("due", "=", matrix);
        matrix = new LinkedHashMap();
        matrix.put("'1d'", new Result(new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        this._testLiteralMatrix("due", "<", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsEnvironment.xml")
    public void testEnvironment() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "environment";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Test'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-Test'", new Result(new String[]{"HSP-2"}));
        matrix.put("'123456'", new Result(new String[]{"HSP-2"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("Test", new Result(new String[]{"HSP-1"}));
        matrix.put("123456", new Result(new String[]{"HSP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("environment", "~", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsVersion.xml")
    public void testFixVersion() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "fixVersion";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'New Version 1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10001'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        this._testLiteralMatrix("fixVersion", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldOperatorsIssue.xml")
    public void testIssue() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "issue";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10000'", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("''", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("'HSP-2'", new Result(new String[]{"HSP-2"}));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("issue", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsLevel.xml")
    public void testLevel() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "level";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Level 1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10010'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10010", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-3"}));
        this._testLiteralMatrix("level", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsTime.xml")
    public void testTimeTracking() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'60'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2h'", new Result(new String[]{"HSP-2"}));
        matrix.put("'0h'", new Result(new String[]{"HSP-5"}));
        matrix.put("'hh'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("240", new Result(new String[]{"HSP-3"}));
        matrix.put("0", new Result(new String[]{"HSP-5"}));
        matrix.put("'-240'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("1d", new Result(new String[]{"HSP-7"}));
        matrix.put("1w", new Result(new String[]{"HSP-8"}));
        this._testLiteralMatrix(ORIGINAL_ESTIMATE, matrix);
        matrix = new LinkedHashMap();
        matrix.put("'40'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1h'", new Result(new String[]{"HSP-3", "HSP-2"}));
        matrix.put("'0m'", new Result(new String[]{"HSP-5"}));
        matrix.put("'hh'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("60", new Result(new String[]{"HSP-3", "HSP-2"}));
        matrix.put("0", new Result(new String[]{"HSP-5"}));
        matrix.put("'-60'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("1d", new Result(new String[]{"HSP-7"}));
        matrix.put("1w", new Result(new String[]{"HSP-8"}));
        this._testLiteralMatrix(REMAINING_ESTIMATE, matrix);
        matrix = new LinkedHashMap();
        matrix.put("'20'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1h'", new Result(new String[]{"HSP-2"}));
        matrix.put("'0d'", new Result(new String[0]));
        matrix.put("'hh'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("180", new Result(new String[]{"HSP-3"}));
        matrix.put("0", new Result(new String[0]));
        matrix.put("'-180'", new Result(ErrorType.INVALID_DURATION_FORMAT));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("1d", new Result(new String[]{"HSP-7"}));
        matrix.put("1w", new Result(new String[]{"HSP-8"}));
        this._testLiteralMatrix(TIME_SPENT, matrix);
        matrix = new LinkedHashMap();
        matrix.put("'33'", new Result(new String[]{"HSP-1"}));
        matrix.put("'33.3'", new Result(ErrorType.INVALID_INTEGER_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_INTEGER_FORMAT));
        matrix.put("0", new Result(new String[0]));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix("workRatio", matrix);
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable("6", "2", TimeTracking.Format.PRETTY, TimeTracking.Unit.HOUR, TimeTracking.Mode.MODERN);
        this.administration.reIndex();
        matrix = new LinkedHashMap();
        matrix.put("1d", new Result(new String[]{"HSP-6"}));
        matrix.put("1w", new Result(new String[]{"HSP-10"}));
        matrix.put("8", new Result(new String[]{"HSP-7"}));
        this._testLiteralMatrix(TIME_SPENT, matrix);
        this._testLiteralMatrix(ORIGINAL_ESTIMATE, matrix);
        this._testLiteralMatrix(REMAINING_ESTIMATE, matrix);
    }

    @Test
    @Restore(value="TestSystemFieldOperatorsParent.xml")
    public void testParent() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "parent";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10000'", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("''", new Result(ErrorType.ISSUE_KEY_INVALID));
        matrix.put("'HSP-2'", new Result(new String[]{"HSP-4"}));
        matrix.put("10000", new Result(new String[]{"HSP-3"}));
        matrix.put("10001", new Result(new String[]{"HSP-4"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("parent", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsPriority.xml")
    public void testPriority() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "priority";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Blocker'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1'", new Result(new String[]{"HSP-2", "HSP-1"}));
        matrix.put("'2'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("priority", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsProject.xml")
    public void testProject() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "project";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10010'", new Result(new String[]{"NUM-1"}));
        matrix.put("'10011'", new Result(new String[]{"NUM-1"}));
        matrix.put("'DUP'", new Result(new String[]{"DUP-1"}));
        matrix.put("'HSP'", new Result(new String[]{"HSP-1"}));
        matrix.put("'homosapien'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10010", new Result(new String[]{"HSP-1"}));
        matrix.put("10011", new Result(new String[]{"NUM-1"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("project", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsAssignee.xml")
    public void testReporter() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "reporter";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("administrator", new Result(new String[]{"HSP-1"}));
        matrix.put("admin", new Result(new String[]{"HSP-2"}));
        matrix.put("'Fred Normal'", new Result(new String[]{"HSP-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        matrix.put("12345", new Result(new String[]{"HSP-5"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("'12345'", new Result(new String[]{"HSP-5"}));
        this._testLiteralMatrix("reporter", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsResolution.xml")
    public void testResolution() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "resolution";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'Fixed'", new Result(new String[]{"HSP-1"}));
        matrix.put("'1'", new Result(new String[]{"HSP-2", "HSP-1"}));
        matrix.put("'3'", new Result(new String[]{"HSP-3"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[]{"HSP-4"}));
        this._testLiteralMatrix("resolution", matrix);
        this.assertSearchResults("resolution = unresolved", "HSP-4");
        this.assertSearchResults("resolution in (unresolved)", "HSP-4");
        this.assertSearchResults("resolution in (unresolved, Fixed)", "HSP-4", "HSP-1");
        this.assertSearchResults("resolution != unresolved", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved, Fixed)", "HSP-3", "HSP-2");
        this.assertSearchAndErrorMessagePresent("resolution = '\"unresolved\"'");
        this.administration.resolutions().addResolution("unRESOLVED");
        this.assertSearchResults("resolution = unresolved", "HSP-4");
        this.assertSearchResults("resolution in (unresolved)", "HSP-4");
        this.assertSearchResults("resolution in (unresolved, Fixed)", "HSP-4", "HSP-1");
        this.assertSearchResults("resolution != unresolved", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved)", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved, Fixed)", "HSP-3", "HSP-2");
        this.assertSearchResults("resolution = '\"unresolved\"'", new String[0]);
        this.assertSearchResults("resolution in ('\"unresolved\"')", new String[0]);
        this.assertSearchResults("resolution in ('\"unresolved\"', Fixed)", "HSP-1");
        this.assertSearchResults("resolution != '\"unresolved\"'", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"')", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"', Fixed)", "HSP-3", "HSP-2");
        String issue = this.navigation.issue().createIssue("homosapien", "Bug", "test");
        this.navigation.issue().resolveIssue(issue, "unRESOLVED", "test");
        this.assertSearchResults("resolution = unresolved", "HSP-4");
        this.assertSearchResults("resolution in (unresolved)", "HSP-4");
        this.assertSearchResults("resolution in (unresolved, Fixed)", "HSP-4", "HSP-1");
        this.assertSearchResults("resolution != unresolved", issue, "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved)", issue, "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in (unresolved, Fixed)", issue, "HSP-3", "HSP-2");
        this.assertSearchResults("resolution = '\"unresolved\"'", issue);
        this.assertSearchResults("resolution in ('\"unresolved\"')", issue);
        this.assertSearchResults("resolution in ('\"unresolved\"', Fixed)", issue, "HSP-1");
        this.assertSearchResults("resolution != '\"unresolved\"'", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"')", "HSP-3", "HSP-2", "HSP-1");
        this.assertSearchResults("resolution not in ('\"unresolved\"', Fixed)", "HSP-3", "HSP-2");
        this.assertSearchAndErrorMessagePresent("resolution > unresolved");
        this.assertSearchAndErrorMessagePresent("resolution >= unresolved");
        this.assertSearchAndErrorMessagePresent("resolution < unresolved");
        this.assertSearchAndErrorMessagePresent("resolution <= unresolved");
        this.assertSearchAndErrorMessagePresent("resolution = \"\\\"\\\"unresolved\\\"\\\"\"");
        this.administration.resolutions().addResolution("\"unresolved\"");
        this.assertSearchResults("resolution = \"\\\"\\\"unresolved\\\"\\\"\"", new String[0]);
        issue = this.navigation.issue().createIssue("homosapien", "Bug", "test");
        this.navigation.issue().resolveIssue(issue, "\"unresolved\"", "test");
        this.assertSearchResults("resolution = \"\\\"\\\"unresolved\\\"\\\"\"", issue);
    }

    @Test
    @Restore(value="TestSystemFieldOperatorsResolution.xml")
    public void testResolutionDate() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "resolved";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'1d'", new Result(new String[]{"HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("resolved", "<", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsSavedFilter.xml")
    public void testSavedFilter() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "savedFilter";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'10000'", new Result(new String[]{"HSP-2"}));
        matrix.put("'10001'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bugs'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("10000", new Result(new String[]{"HSP-1"}));
        matrix.put("10001", new Result(new String[]{"HSP-2"}));
        matrix.put("999", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("savedFilter", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsStatus.xml")
    public void testStatus() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "status";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'1'", new Result(new String[]{"HSP-2", "HSP-1"}));
        matrix.put("'3'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Open'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("3", new Result(new String[]{"HSP-2"}));
        matrix.put("999", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("status", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsSummary.xml")
    public void testSummary() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "summary";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'OneTwoThree'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-OneTwoThree'", new Result(new String[]{"HSP-2"}));
        matrix.put("'456'", new Result(new String[]{"HSP-2"}));
        matrix.put("OneTwoThree", new Result(new String[]{"HSP-1"}));
        matrix.put("456", new Result(new String[]{"HSP-2"}));
        matrix.put("-456", new Result(new String[]{"HSP-1"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("summary", "~", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsSummary.xml")
    public void testText() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "text";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'OneTwoThree'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-OneTwoThree'", new Result(new String[]{"HSP-2"}));
        matrix.put("'456'", new Result(new String[]{"HSP-2"}));
        matrix.put("OneTwoThree", new Result(new String[]{"HSP-1"}));
        matrix.put("456", new Result(new String[]{"HSP-2"}));
        matrix.put("-456", new Result(new String[]{"HSP-1"}));
        matrix.put("'?'", new Result(ErrorType.INVALID_START_CHAR));
        matrix.put("'BAD +'", new Result(ErrorType.CANT_PARSE_QUERY));
        matrix.put("''", new Result(ErrorType.EMPTY_STRING_NOT_SUPPORTED));
        matrix.put("EMPTY", new Result(ErrorType.EMPTY_NOT_SUPPORTED));
        this._testLiteralMatrix("text", "~", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldLiteralsType.xml")
    public void testType() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "type";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'1'", new Result(new String[]{"HSP-2", "HSP-1"}));
        matrix.put("'2'", new Result(new String[]{"HSP-2"}));
        matrix.put("'Bug'", new Result(new String[]{"HSP-1"}));
        matrix.put("'Bad String'", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("''", new Result(ErrorType.NAME_NOT_FOUND));
        matrix.put("1", new Result(new String[]{"HSP-1"}));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("999", new Result(new String[]{"HSP-3"}));
        matrix.put("666", new Result(ErrorType.ID_NOT_FOUND));
        matrix.put("EMPTY", new Result(new String[0]));
        this._testLiteralMatrix("type", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldOperatorsResolution.xml")
    public void testUpdated() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "updated";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("1242604510000", new Result(new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'1d'", new Result(new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"}));
        matrix.put("'dd'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-13 18:50'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009/05/14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'2009-05-14'", new Result(new String[]{"HSP-1"}));
        matrix.put("'14/May/09'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'09/1/1'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2009/05/14 bad'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("'2010/02/35'", new Result(ErrorType.INVALID_DATE_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_DATE_FORMAT));
        this._testLiteralMatrix("updated", "<", matrix);
    }

    @Test
    @Restore(value="TestSystemFieldOperatorsVotes.xml")
    public void testVotes() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        String fieldName = "votes";
        LinkedHashMap<String, Result> matrix = new LinkedHashMap<String, Result>();
        matrix.put("'0'", new Result(new String[]{"HSP-3"}));
        matrix.put("'1'", new Result(new String[]{"HSP-1"}));
        matrix.put("'-3'", new Result(ErrorType.INVALID_VOTES_FORMAT));
        matrix.put("''", new Result(ErrorType.INVALID_VOTES_FORMAT));
        matrix.put("2", new Result(new String[]{"HSP-2"}));
        matrix.put("-3", new Result(ErrorType.INVALID_VOTES_FORMAT_WITH_QUOTES));
        matrix.put("EMPTY", new Result(ErrorType.INVALID_VOTES_FORMAT_WITH_QUOTES));
        this._testLiteralMatrix("votes", matrix);
    }

    private void _testLiteralMatrix(String fieldName, Map<String, Result> matrix) {
        this._testLiteralMatrix(fieldName, "=", matrix);
    }

    private void _testLiteralMatrix(String fieldName, String operator, Map<String, Result> matrix) {
        for (Map.Entry<String, Result> entry : matrix.entrySet()) {
            String operand = entry.getKey();
            String jqlQuery = String.format("%s %s %s", fieldName, operator, operand);
            Result result = entry.getValue();
            if (result.issueKeys == null && result.errorType != null) {
                this.assertSearchAndErrorMessagePresent(jqlQuery);
                continue;
            }
            this.assertSearchResults(jqlQuery, result.issueKeys);
        }
    }

    private void assertSearchResults(String jqlQuery, String ... issueKeys) {
        ArrayList<SearchResultsCondition> conditions = new ArrayList<SearchResultsCondition>();
        conditions.add(new ContainsIssueKeysCondition(this.assertions.getTextAssertions(), issueKeys));
        conditions.add(new NumberOfIssuesCondition(this.assertions.getTextAssertions(), issueKeys.length));
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(conditions);
    }

    private void assertSearchAndErrorMessagePresent(String jqlQuery) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.tester.assertElementNotPresent("issuetable");
    }

    private static class Result {
        private String[] issueKeys = null;
        private ErrorType errorType = null;

        private Result(String ... issueKeys) {
            this.issueKeys = issueKeys;
        }

        private Result(ErrorType errorType) {
            this.errorType = errorType;
        }
    }

    private static enum ErrorType {
        EMPTY_NOT_SUPPORTED,
        EMPTY_STRING_NOT_SUPPORTED,
        ISSUE_KEY_INVALID,
        INVALID_VOTES_FORMAT,
        INVALID_VOTES_FORMAT_WITH_QUOTES,
        INVALID_INTEGER_FORMAT,
        INVALID_DURATION_FORMAT,
        INVALID_DATE_FORMAT,
        INVALID_RELATIVE_DATE_FORMAT,
        CANT_PARSE_QUERY,
        INVALID_START_CHAR,
        NAME_NOT_FOUND,
        ID_NOT_FOUND;

    }
}

