/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.reporter;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.LoginAs;
import com.atlassian.jira.functest.framework.assertions.ChangeHistoryAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rule.SinceBuildRule;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
@LoginAs(user="admin")
@Restore(value="TestChangeHistorySearch.xml")
public class TestReporterWasSearching
extends BaseJiraFuncTest {
    private static final String FIELD_NAME = "reporter";
    private static final String[] ALL_ISSUES = new String[]{"HSP-10", "HSP-9", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
    private static final String INDEXING_LIMIT = "6";
    private static final long HSP_PROJECT_ID = 10000L;
    @Inject
    private ChangeHistoryAssertions changeHistoryAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.systemProperties().setProperty("jira.safeguards.indexing.issue.changelogs", INDEXING_LIMIT);
        this.backdoor.indexing().reindexProject(10000L);
    }

    @After
    public void tearDown() {
        this.backdoor.systemProperties().unsetProperty("jira.safeguards.indexing.issue.changelogs");
    }

    @Test
    public void testWasEmptySearch() {
        String[] issueKeys = new String[]{"HSP-9"};
        this.changeHistoryAssertions.assertWasEmptySearchReturnsEmptyValuesUsingEmptyKeyword(FIELD_NAME, issueKeys);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasNotEmptySearch() {
        String[] issueKeys = new String[]{"HSP-10", "HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasNotEmptySearchReturnsNotEmptyValuesWithEmptyKeyword(FIELD_NAME, issueKeys);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchUsingSingleValueOperandsReturnsExpectedValues() {
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "admin", expectedIssues);
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "fred", "HSP-10", "HSP-9");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "bob", "HSP-10");
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchUsingListOperands() {
        HashSet users = Sets.newHashSet((Object[])new String[]{"fred", "admin"});
        this.changeHistoryAssertions.assertWasInSearchReturnsExpectedValues(FIELD_NAME, users, ALL_ISSUES);
        users = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        this.changeHistoryAssertions.assertWasInSearchReturnsExpectedValues(FIELD_NAME, users, "HSP-10", "HSP-9");
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasNotInSearchUsingListOperands() {
        String[] expected = new String[]{"HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        HashSet users = Sets.newHashSet((Object[])new String[]{"fred", "bob"});
        this.changeHistoryAssertions.assertWasNotInSearchReturnsExpectedValues(FIELD_NAME, users, expected);
    }

    @Test
    public void testWasSearchUsingByPredicate() {
        String[] expected = new String[]{"HSP-9"};
        this.changeHistoryAssertions.assertWasBySearchReturnsExpectedValues(FIELD_NAME, "fred", "admin", expected);
        expected = new String[]{};
        this.changeHistoryAssertions.assertWasBySearchReturnsExpectedValues(FIELD_NAME, "admin", "fred", expected);
        this.changeHistoryAssertions.assertWasBySearchUsingListOperandsReturnsExpectedValues(FIELD_NAME, "empty", Sets.newHashSet((Object[])new String[]{"fred", "admin"}), "HSP-9");
    }

    @Test
    public void testWasSearchUsingDuringPredicate() {
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasDuringSearchReturnsExpectedValues(FIELD_NAME, "admin", "'2011/05/01'", "'2011/05/31'", expectedIssues);
        this.changeHistoryAssertions.assertWasDuringSearchReturnsExpectedValues(FIELD_NAME, "fred", "'2011/05/01'", "'2011/05/31'", "HSP-9");
    }

    @Test
    public void testWasSearchUsingBeforePredicate() {
        String[] expected = new String[]{"HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, "admin", "'2010/05/01'", expected);
        this.changeHistoryAssertions.assertWasBeforeSearchReturnsExpectedValues(FIELD_NAME, "fred", "'2011/05/21 10:55'", "HSP-9");
    }

    @Test
    public void testWasSearchUsingAfterPredicate() {
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, "admin", "'2011/05/01'", expectedIssues);
        String[] expected = new String[]{"HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasAfterSearchReturnsExpectedValues(FIELD_NAME, "admin", "'2011/06/03 10:55'", expected);
    }

    @Test
    public void testWasSearchUsingOnPredicate() {
        String[] expected = new String[]{"HSP-8", "HSP-7", "HSP-6", "HSP-5", "HSP-4", "HSP-3", "HSP-2", "HSP-1"};
        this.changeHistoryAssertions.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, "admin", "'2011/05/01'", expected);
        expected = new String[]{"HSP-9"};
        this.changeHistoryAssertions.assertWasOnSearchReturnsExpectedValues(FIELD_NAME, "fred", "'2011/06/01'", expected);
    }

    @Test
    public void testWasSearchUsingLongOperandsIsInvalid() {
        String expectedError = "A value with ID '1' does not exist for the field 'reporter'.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "1", "", "A value with ID '1' does not exist for the field 'reporter'.");
    }

    @Test
    public void testWasSearchUsingUnclosedListIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting ')' before the end of the query.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob", "", "Error in the JQL Query: Expecting ')' before the end of the query.");
    }

    @Test
    public void testWasSearchUsingIncorrectPredicateIsInvalid() {
        String expectedError = "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 26)";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "(fred, bob)", "at '10:55'", "Error in the JQL Query: Expecting either 'OR' or 'AND' but got 'at'. (line 1, character 26)");
    }

    @Test
    public void testWasSearchUsingIncorrectFunctionIsInvalid() {
        String expectedError = "A value provided by the function 'currentLogin' is invalid for the field 'reporter'.";
        this.changeHistoryAssertions.assertInvalidSearchProducesError(FIELD_NAME, "currentLogin()", "", "A value provided by the function 'currentLogin' is invalid for the field 'reporter'.");
    }

    @Test
    public void testWasSearchingForNotIndexedReporter() {
        String[] expectedIssues = this.exclude(ALL_ISSUES, "HSP-10");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "admin", expectedIssues);
    }

    @SinceBuildRule.SinceBuild(buildNumber=900004)
    @Test
    public void testWasSearchingForIndexedReporter() {
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "bob", "HSP-10");
        this.changeHistoryAssertions.assertWasSearchReturnsExpectedValues(FIELD_NAME, "fred", "HSP-10", "HSP-9");
    }

    private String[] exclude(String[] notFilteredArray, String ... elementsToFilterOut) {
        HashSet excludeElements = Sets.newHashSet((Object[])elementsToFilterOut);
        return (String[])Arrays.stream(notFilteredArray).filter(element -> !excludeElements.contains(element)).toArray(String[]::new);
    }
}

