/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql.changehistory.status;

import com.atlassian.integrationtesting.runner.restore.Restore;
import com.atlassian.jira.functest.framework.BaseJiraFuncTest;
import com.atlassian.jira.functest.framework.assertions.IssueTableAssertions;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import javax.inject.Inject;
import org.junit.Before;
import org.junit.Test;

@WebTest(value={Category.FUNC_TEST, Category.JQL, Category.CHANGE_HISTORY})
@Restore(value="TestWasSearch.xml")
public class TestSearchChangesInStatusByASpecificUser
extends BaseJiraFuncTest {
    @Inject
    private IssueTableAssertions issueTableAssertions;

    @Before
    public void setUpTest() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Test
    public void testOnlyReturnsTheIssuesChangedToAStatusByTheSpecifiedUser() {
        this.navigation.login("fred");
        this.navigation.issue().closeIssue("HSP-1", "Fixed", "Fixed");
        this.navigation.login("admin");
        this.navigation.issue().closeIssue("HSP-2", "Fixed", "Fixed");
        this.assertExactSearchWithResults("status was Closed order by key asc", "HSP-1", "HSP-2");
        this.issueTableAssertions.assertSearchWithResults("status was Closed by fred", "HSP-1");
        this.issueTableAssertions.assertSearchWithResults("status was Closed by admin", "HSP-2");
    }

    private void assertExactSearchWithResults(String jqlString, String ... issueKeys) {
        this.navigation.issueNavigator().createSearch(jqlString);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(issueKeys);
    }
}

