/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class OsgiTestUtils {
    private static final String EXPECTED_SYSTEM_BUNDLE_EXPORTS_FILE = "TestOsgiExports-system-bundles.txt";
    private static final String EXPECTED_PUBLIC_API_EXPORTS_FILE = "TestOsgiExports-public-packages.txt";
    private static final String EXPECTED_DEPRECATED_EXPORTS_FILE = "TestOsgiExports-deprecated-packages.txt";
    private static final String RESOURCES_PATH = "/resources/";
    private static final Predicate<String> FILTER = Stream.of(StringUtils::isNotBlank, line -> !StringUtils.startsWith((CharSequence)line, (CharSequence)"#")).reduce(Predicate::and).get();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<String> readOsgiPackagesFromFile(String exportsFile) {
        String prefix = RESOURCES_PATH + OsgiTestUtils.class.getPackage().getName().replace('.', '/') + "/" + exportsFile;
        try (InputStream stream = OsgiTestUtils.class.getResourceAsStream(prefix);){
            Set set = IOUtils.readLines((InputStream)stream, (Charset)StandardCharsets.UTF_8).stream().filter(FILTER).map(line -> StringUtils.split((String)line, (String)",")[0]).collect(Collectors.toCollection(TreeSet::new));
            return set;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read expected system bundle exports file", e);
        }
    }

    public static String systemPackagesFilename() {
        return EXPECTED_SYSTEM_BUNDLE_EXPORTS_FILE;
    }

    public static String publicApiPackagesFilename() {
        return EXPECTED_PUBLIC_API_EXPORTS_FILE;
    }

    public static String deprecatedPackagesFilename() {
        return EXPECTED_DEPRECATED_EXPORTS_FILE;
    }
}

